/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.ab.view.chart.CategorySeries;
import com.ab.view.chart.DefaultRenderer;
import com.ab.view.chart.PieMapper;
import com.ab.view.chart.Point;
import com.ab.view.chart.RoundChart;
import com.ab.view.chart.SeriesSelection;
import java.util.ArrayList;

public class PieChart
extends RoundChart {
    private PieMapper mPieMapper = new PieMapper();

    public PieChart(CategorySeries dataset, DefaultRenderer renderer) {
        super(dataset, renderer);
    }

    @Override
    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        boolean loadPieCfg;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, 0.0f);
        int left = x;
        int top = y;
        int right = x + width;
        int sLength = this.mDataset.getItemCount();
        double total = 0.0;
        String[] titles = new String[sLength];
        int i = 0;
        while (i < sLength) {
            total += this.mDataset.getValue(i);
            titles[i] = this.mDataset.getCategory(i);
            ++i;
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        float currentAngle = this.mRenderer.getStartAngle();
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (left + right) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (bottom + top) / 2;
        }
        this.mPieMapper.setDimensions(radius, this.mCenterX, this.mCenterY);
        boolean bl = loadPieCfg = !this.mPieMapper.areAllSegmentPresent(sLength);
        if (loadPieCfg) {
            this.mPieMapper.clearPieSegments();
        }
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        RectF oval = new RectF((float)(this.mCenterX - radius), (float)(this.mCenterY - radius), (float)(this.mCenterX + radius), (float)(this.mCenterY + radius));
        ArrayList<RectF> prevLabelsBounds = new ArrayList<RectF>();
        int i2 = 0;
        while (i2 < sLength) {
            paint.setColor(this.mRenderer.getSeriesRendererAt(i2).getColor());
            float value = (float)this.mDataset.getValue(i2);
            float angle = (float)((double)value / total * 360.0);
            canvas.drawArc(oval, currentAngle, angle, true, paint);
            this.drawLabel(canvas, this.mDataset.getCategory(i2), this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius, longRadius, currentAngle, angle, left, right, this.mRenderer.getLabelsColor(), paint, true);
            if (this.mRenderer.isDisplayValues()) {
                this.drawLabel(canvas, this.getLabel(this.mDataset.getValue(i2)), this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius / 2.0f, longRadius / 2.0f, currentAngle, angle, left, right, this.mRenderer.getLabelsColor(), paint, false);
            }
            if (loadPieCfg) {
                this.mPieMapper.addPieSegment(i2, value, currentAngle, angle);
            }
            currentAngle += angle;
            ++i2;
        }
        prevLabelsBounds.clear();
        this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, false);
        this.drawTitle(canvas, x, y, width, paint);
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        return this.mPieMapper.getSeriesAndPointForScreenCoordinate(screenPoint);
    }
}

