/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import com.ab.view.chart.PieSegment;
import com.ab.view.chart.Point;
import com.ab.view.chart.SeriesSelection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PieMapper
implements Serializable {
    private List<PieSegment> mPieSegmentList = new ArrayList<PieSegment>();
    private int mPieChartRadius;
    private int mCenterX;
    private int mCenterY;

    public void setDimensions(int pieRadius, int centerX, int centerY) {
        this.mPieChartRadius = pieRadius;
        this.mCenterX = centerX;
        this.mCenterY = centerY;
    }

    public boolean areAllSegmentPresent(int datasetSize) {
        return this.mPieSegmentList.size() == datasetSize;
    }

    public void addPieSegment(int dataIndex, float value, float startAngle, float angle) {
        this.mPieSegmentList.add(new PieSegment(dataIndex, value, startAngle, angle));
    }

    public void clearPieSegments() {
        this.mPieSegmentList.clear();
    }

    public double getAngle(Point screenPoint) {
        double dx = screenPoint.getX() - (float)this.mCenterX;
        double dy = -(screenPoint.getY() - (float)this.mCenterY);
        double inRads = Math.atan2(dy, dx);
        inRads = inRads < 0.0 ? Math.abs(inRads) : Math.PI * 2 - inRads;
        return Math.toDegrees(inRads);
    }

    public boolean isOnPieChart(Point screenPoint) {
        double radiusSquared;
        double sqValue = Math.pow((float)this.mCenterX - screenPoint.getX(), 2.0) + Math.pow((float)this.mCenterY - screenPoint.getY(), 2.0);
        boolean isOnPieChart = sqValue <= (radiusSquared = (double)(this.mPieChartRadius * this.mPieChartRadius));
        return isOnPieChart;
    }

    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        if (this.isOnPieChart(screenPoint)) {
            double angleFromPieCenter = this.getAngle(screenPoint);
            for (PieSegment pieSeg : this.mPieSegmentList) {
                if (!pieSeg.isInSegment(angleFromPieCenter)) continue;
                return new SeriesSelection(0, pieSeg.getDataIndex(), pieSeg.getValue(), pieSeg.getValue());
            }
        }
        return null;
    }
}

