/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import com.ab.view.chart.IndexXYMap;
import com.ab.view.chart.XYEntry;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;

public class XYSeries
implements Serializable {
    private String mTitle;
    private final IndexXYMap<Double, Double> mXY = new IndexXYMap();
    private final IndexXYMap<Double, Integer> mXC = new IndexXYMap();
    private final IndexXYMap<Double, String> mXE = new IndexXYMap();
    private double mMinX = Double.MAX_VALUE;
    private double mMaxX = -1.7976931348623157E308;
    private double mMinY = Double.MAX_VALUE;
    private double mMaxY = -1.7976931348623157E308;
    private final int mScaleNumber;

    public XYSeries(String title) {
        this(title, 0);
    }

    public XYSeries(String title, int scaleNumber) {
        this.mTitle = title;
        this.mScaleNumber = scaleNumber;
        this.initRange();
    }

    public int getScaleNumber() {
        return this.mScaleNumber;
    }

    private void initRange() {
        this.mMinX = Double.MAX_VALUE;
        this.mMaxX = -1.7976931348623157E308;
        this.mMinY = Double.MAX_VALUE;
        this.mMaxY = -1.7976931348623157E308;
        int length = this.getItemCount();
        int k = 0;
        while (k < length) {
            double x = this.getX(k);
            double y = this.getY(k);
            this.updateRange(x, y);
            ++k;
        }
    }

    private void updateRange(double x, double y) {
        this.mMinX = Math.min(this.mMinX, x);
        this.mMaxX = Math.max(this.mMaxX, x);
        this.mMinY = Math.min(this.mMinY, y);
        this.mMaxY = Math.max(this.mMaxY, y);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public synchronized void add(double x, double y) {
        this.mXY.put(x, y);
        this.updateRange(x, y);
    }

    public synchronized void add(double x, double y, int c) {
        this.mXY.put(x, y);
        this.updateRange(x, y);
        this.mXC.put(x, c);
    }

    public synchronized void add(double x, double y, int c, String e) {
        this.mXY.put(x, y);
        this.updateRange(x, y);
        this.mXC.put(x, c);
        this.mXE.put(x, e);
    }

    public synchronized void remove(int index) {
        XYEntry<Double, Double> removedEntry = this.mXY.removeByIndex(index);
        double removedX = removedEntry.getKey();
        double removedY = removedEntry.getValue();
        if (removedX == this.mMinX || removedX == this.mMaxX || removedY == this.mMinY || removedY == this.mMaxY) {
            this.initRange();
        }
    }

    public synchronized void clear() {
        this.mXY.clear();
        this.initRange();
    }

    public synchronized double getX(int index) {
        return this.mXY.getXByIndex(index);
    }

    public synchronized double getY(int index) {
        return this.mXY.getYByIndex(index);
    }

    public synchronized SortedMap<Double, Double> getRange(double start, double stop, int beforeAfterPoints) {
        SortedMap tailMap;
        SortedMap headMap = this.mXY.headMap(start);
        if (!headMap.isEmpty()) {
            start = headMap.lastKey();
        }
        if (!(tailMap = this.mXY.tailMap(stop)).isEmpty()) {
            Iterator<Double> tailIterator = tailMap.keySet().iterator();
            Double next = tailIterator.next();
            stop = tailIterator.hasNext() ? tailIterator.next() : (stop += next.doubleValue());
        }
        return this.mXY.subMap(start, stop);
    }

    public int getIndexForKey(double key) {
        return this.mXY.getIndexForKey(key);
    }

    public synchronized int getItemCount() {
        return this.mXY.size();
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }

    public IndexXYMap<Double, Integer> getmXC() {
        return this.mXC;
    }

    public int getmXCValue(double key) {
        Object c = this.mXC.get(key);
        if (c == null) {
            return 0;
        }
        return (Integer)this.mXC.get(key);
    }

    public IndexXYMap<Double, String> getmXE() {
        return this.mXE;
    }

    public String getmXEValue(double key) {
        Object e = this.mXC.get(key);
        if (e == null) {
            return "";
        }
        return (String)this.mXE.get(key);
    }
}

