/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.cropimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.ab.view.cropimage.CropImage;
import com.ab.view.cropimage.CropViewBase;
import com.ab.view.cropimage.HighlightView;
import java.util.ArrayList;

public class CropImageView
extends CropViewBase {
    public ArrayList<HighlightView> mHighlightViews = new ArrayList();
    HighlightView mMotionHighlightView = null;
    float mLastX;
    float mLastY;
    int mMotionEdge;
    private CropImage mCropImage;

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mBitmapDisplayed.getBitmap() != null) {
            for (HighlightView hv : this.mHighlightViews) {
                hv.mMatrix.set(this.getImageMatrix());
                hv.invalidate();
                if (!hv.mIsFocused) continue;
                this.centerBasedOnHighlightView(hv);
            }
        }
    }

    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void zoomTo(float scale, float centerX, float centerY) {
        super.zoomTo(scale, centerX, centerY);
        for (HighlightView hv : this.mHighlightViews) {
            hv.mMatrix.set(this.getImageMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void zoomIn() {
        super.zoomIn();
        for (HighlightView hv : this.mHighlightViews) {
            hv.mMatrix.set(this.getImageMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void zoomOut() {
        super.zoomOut();
        for (HighlightView hv : this.mHighlightViews) {
            hv.mMatrix.set(this.getImageMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void postTranslate(float deltaX, float deltaY) {
        super.postTranslate(deltaX, deltaY);
        int i = 0;
        while (i < this.mHighlightViews.size()) {
            HighlightView hv = this.mHighlightViews.get(i);
            hv.mMatrix.postTranslate(deltaX, deltaY);
            hv.invalidate();
            ++i;
        }
    }

    private void recomputeFocus(MotionEvent event) {
        HighlightView hv;
        int i = 0;
        while (i < this.mHighlightViews.size()) {
            hv = this.mHighlightViews.get(i);
            hv.setFocus(false);
            hv.invalidate();
            ++i;
        }
        i = 0;
        while (i < this.mHighlightViews.size()) {
            hv = this.mHighlightViews.get(i);
            int edge = hv.getHit(event.getX(), event.getY());
            if (edge != 1) {
                if (hv.hasFocus()) break;
                hv.setFocus(true);
                hv.invalidate();
                break;
            }
            ++i;
        }
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        CropImage cropImage = this.mCropImage;
        if (cropImage.mSaving) {
            return false;
        }
        block0 : switch (event.getAction()) {
            case 0: {
                if (cropImage.mWaitingToPick) {
                    this.recomputeFocus(event);
                    break;
                }
                int i = 0;
                while (i < this.mHighlightViews.size()) {
                    HighlightView hv = this.mHighlightViews.get(i);
                    int edge = hv.getHit(event.getX(), event.getY());
                    if (edge != 1) {
                        this.mMotionEdge = edge;
                        this.mMotionHighlightView = hv;
                        this.mLastX = event.getX();
                        this.mLastY = event.getY();
                        this.mMotionHighlightView.setMode(edge == 32 ? HighlightView.ModifyMode.Move : HighlightView.ModifyMode.Grow);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                if (cropImage.mWaitingToPick) {
                    int i = 0;
                    while (i < this.mHighlightViews.size()) {
                        HighlightView hv = this.mHighlightViews.get(i);
                        if (hv.hasFocus()) {
                            cropImage.mCrop = hv;
                            int j = 0;
                            while (j < this.mHighlightViews.size()) {
                                if (j != i) {
                                    this.mHighlightViews.get(j).setHidden(true);
                                }
                                ++j;
                            }
                            this.centerBasedOnHighlightView(hv);
                            this.mCropImage.mWaitingToPick = false;
                            return true;
                        }
                        ++i;
                    }
                } else if (this.mMotionHighlightView != null) {
                    this.centerBasedOnHighlightView(this.mMotionHighlightView);
                    this.mMotionHighlightView.setMode(HighlightView.ModifyMode.None);
                }
                this.mMotionHighlightView = null;
                break;
            }
            case 2: {
                if (cropImage.mWaitingToPick) {
                    this.recomputeFocus(event);
                    break;
                }
                if (this.mMotionHighlightView == null) break;
                this.mMotionHighlightView.handleMotion(this.mMotionEdge, event.getX() - this.mLastX, event.getY() - this.mLastY);
                this.mLastX = event.getX();
                this.mLastY = event.getY();
                this.ensureVisible(this.mMotionHighlightView);
            }
        }
        switch (event.getAction()) {
            case 1: {
                this.center(true, true);
                break;
            }
            case 2: {
                this.center(true, true);
            }
        }
        return true;
    }

    private void ensureVisible(HighlightView hv) {
        int panDeltaY;
        Rect r = hv.mDrawRect;
        int panDeltaX1 = Math.max(0, this.getLeft() - r.left);
        int panDeltaX2 = Math.min(0, this.getRight() - r.right);
        int panDeltaY1 = Math.max(0, this.getTop() - r.top);
        int panDeltaY2 = Math.min(0, this.getBottom() - r.bottom);
        int panDeltaX = panDeltaX1 != 0 ? panDeltaX1 : panDeltaX2;
        int n = panDeltaY = panDeltaY1 != 0 ? panDeltaY1 : panDeltaY2;
        if (panDeltaX != 0 || panDeltaY != 0) {
            this.panBy(panDeltaX, panDeltaY);
        }
    }

    private void centerBasedOnHighlightView(HighlightView hv) {
        Rect drawRect = hv.mDrawRect;
        float width = drawRect.width();
        float height = drawRect.height();
        float thisWidth = this.getWidth();
        float thisHeight = this.getHeight();
        float z1 = thisWidth / width * 0.6f;
        float z2 = thisHeight / height * 0.6f;
        float zoom = Math.min(z1, z2);
        zoom *= this.getScale();
        if ((double)(Math.abs((zoom = Math.max(1.0f, zoom)) - this.getScale()) / zoom) > 0.1) {
            float[] coordinates = new float[]{hv.mCropRect.centerX(), hv.mCropRect.centerY()};
            this.getImageMatrix().mapPoints(coordinates);
            this.zoomTo(zoom, coordinates[0], coordinates[1], 300.0f);
        }
        this.ensureVisible(hv);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int i = 0;
        while (i < this.mHighlightViews.size()) {
            this.mHighlightViews.get(i).draw(canvas);
            ++i;
        }
    }

    public void add(HighlightView hv) {
        this.mHighlightViews.clear();
        this.mHighlightViews.add(hv);
        this.invalidate();
    }

    public void setCropImage(CropImage cropImage) {
        this.mCropImage = cropImage;
    }

    public void resetView(Bitmap b) {
        int cropWidth;
        this.setImageBitmap(b);
        this.setImageBitmapResetBase(b, true);
        this.setImageMatrix(this.getImageViewMatrix());
        int width = this.mBitmapDisplayed.getWidth();
        int height = this.mBitmapDisplayed.getHeight();
        Rect imageRect = new Rect(0, 0, width, height);
        int cropHeight = cropWidth = Math.min(width, height) * 4 / 5;
        int x = (width - cropWidth) / 2;
        int y = (height - cropHeight) / 2;
        RectF cropRect = new RectF((float)x, (float)y, (float)(x + cropWidth), (float)(y + cropHeight));
        HighlightView hv = new HighlightView((View)this);
        hv.setup(this.getImageViewMatrix(), imageRect, cropRect, false, true);
        hv.setFocus(true);
        this.add(hv);
        this.centerBasedOnHighlightView(hv);
        hv.setMode(HighlightView.ModifyMode.None);
        this.center(true, true);
        this.invalidate();
    }
}

