/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.cropimage;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RegionIterator;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.ab.util.AbFileUtil;
import com.ab.util.AbImageUtil;

public class HighlightView {
    private static final String TAG = "HighlightView";
    View mContext;
    public static final int GROW_NONE = 1;
    public static final int GROW_LEFT_EDGE = 2;
    public static final int GROW_RIGHT_EDGE = 4;
    public static final int GROW_TOP_EDGE = 8;
    public static final int GROW_BOTTOM_EDGE = 16;
    public static final int MOVE = 32;
    public boolean mIsFocused;
    boolean mHidden;
    private ModifyMode mMode = ModifyMode.None;
    public Rect mDrawRect;
    public RectF mImageRect;
    public RectF mCropRect;
    public Matrix mMatrix;
    private boolean mMaintainAspectRatio = false;
    private float mInitialAspectRatio;
    private boolean mCircle = false;
    private Drawable mResizeDrawableDiagonal;
    private Drawable mResizeDrawableDiagonal2;
    private final Paint mFocusPaint = new Paint();
    private final Paint mNoFocusPaint = new Paint();
    private final Paint mOutlinePaint = new Paint();

    public HighlightView(View ctx) {
        this.mContext = ctx;
    }

    private void init() {
        this.mResizeDrawableDiagonal = AbImageUtil.bitmapToDrawable(AbFileUtil.getBitmapFormSrc("image/crop_big.png"));
        this.mResizeDrawableDiagonal2 = AbImageUtil.bitmapToDrawable(AbFileUtil.getBitmapFormSrc("image/crop_small.png"));
    }

    public boolean hasFocus() {
        return this.mIsFocused;
    }

    public void setFocus(boolean f) {
        this.mIsFocused = f;
    }

    public void setHidden(boolean hidden) {
        this.mHidden = hidden;
    }

    public void draw(Canvas canvas) {
        if (this.mHidden) {
            return;
        }
        canvas.save();
        Path path = new Path();
        if (!this.hasFocus()) {
            this.mOutlinePaint.setColor(-16777216);
            canvas.drawRect(this.mDrawRect, this.mOutlinePaint);
        } else {
            Rect viewDrawingRect = new Rect();
            this.mContext.getDrawingRect(viewDrawingRect);
            if (this.mCircle) {
                float width = this.mDrawRect.width();
                float height = this.mDrawRect.height();
                path.addCircle((float)this.mDrawRect.left + width / 2.0f, (float)this.mDrawRect.top + height / 2.0f, width / 2.0f, Path.Direction.CW);
                this.mOutlinePaint.setColor(-1112874);
            } else {
                path.addRect(new RectF(this.mDrawRect), Path.Direction.CW);
                this.mOutlinePaint.setColor(-30208);
            }
            Region region = new Region();
            region.set(viewDrawingRect);
            region.op(this.mDrawRect, Region.Op.DIFFERENCE);
            RegionIterator iter = new RegionIterator(region);
            Rect r = new Rect();
            while (iter.next(r)) {
                canvas.drawRect(r, this.hasFocus() ? this.mFocusPaint : this.mNoFocusPaint);
            }
            canvas.restore();
            canvas.drawPath(path, this.mOutlinePaint);
            if (this.mMode == ModifyMode.Grow && this.mCircle) {
                int width = this.mResizeDrawableDiagonal.getIntrinsicWidth();
                int height = this.mResizeDrawableDiagonal.getIntrinsicHeight();
                int d = (int)Math.round(Math.cos(0.7853981633974483) * ((double)this.mDrawRect.width() / 2.0));
                int x = this.mDrawRect.left + this.mDrawRect.width() / 2 + d - width / 2;
                int y = this.mDrawRect.top + this.mDrawRect.height() / 2 - d - height / 2;
                this.mResizeDrawableDiagonal.setBounds(x, y, x + this.mResizeDrawableDiagonal.getIntrinsicWidth(), y + this.mResizeDrawableDiagonal.getIntrinsicHeight());
                this.mResizeDrawableDiagonal.draw(canvas);
            }
            if (!this.mCircle) {
                int left = this.mDrawRect.left + 1;
                int right = this.mDrawRect.right + 1;
                int top = this.mDrawRect.top + 4;
                int bottom = this.mDrawRect.bottom + 3;
                int widthWidth = this.mResizeDrawableDiagonal.getIntrinsicWidth() / 2;
                int widthHeight = this.mResizeDrawableDiagonal.getIntrinsicHeight() / 2;
                this.mResizeDrawableDiagonal2.setBounds(left - widthWidth, top - widthHeight, left + widthWidth, top + widthHeight);
                this.mResizeDrawableDiagonal2.draw(canvas);
                this.mResizeDrawableDiagonal.setBounds(right - widthWidth, top - widthHeight, right + widthWidth, top + widthHeight);
                this.mResizeDrawableDiagonal.draw(canvas);
                this.mResizeDrawableDiagonal.setBounds(left - widthWidth, bottom - widthHeight, left + widthWidth, bottom + widthHeight);
                this.mResizeDrawableDiagonal.draw(canvas);
                this.mResizeDrawableDiagonal2.setBounds(right - widthWidth, bottom - widthHeight, right + widthWidth, bottom + widthHeight);
                this.mResizeDrawableDiagonal2.draw(canvas);
            }
        }
    }

    public void setMode(ModifyMode mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.mContext.invalidate();
        }
    }

    public int getHit(float x, float y) {
        Rect r = this.computeLayout();
        float hysteresis = 20.0f;
        int retval = 1;
        if (this.mCircle) {
            int radius;
            float distY;
            float distX = x - (float)r.centerX();
            int distanceFromCenter = (int)Math.sqrt(distX * distX + (distY = y - (float)r.centerY()) * distY);
            int delta = distanceFromCenter - (radius = this.mDrawRect.width() / 2);
            retval = (float)Math.abs(delta) <= 20.0f ? (Math.abs(distY) > Math.abs(distX) ? (distY < 0.0f ? 8 : 16) : (distX < 0.0f ? 2 : 4)) : (distanceFromCenter < radius ? 32 : 1);
        } else {
            boolean horizCheck;
            boolean verticalCheck = y >= (float)r.top - 20.0f && y < (float)r.bottom + 20.0f;
            boolean bl = horizCheck = x >= (float)r.left - 20.0f && x < (float)r.right + 20.0f;
            if (Math.abs((float)r.left - x) < 20.0f && verticalCheck) {
                retval |= 2;
            }
            if (Math.abs((float)r.right - x) < 20.0f && verticalCheck) {
                retval |= 4;
            }
            if (Math.abs((float)r.top - y) < 20.0f && horizCheck) {
                retval |= 8;
            }
            if (Math.abs((float)r.bottom - y) < 20.0f && horizCheck) {
                retval |= 0x10;
            }
            if (retval == 1 && r.contains((int)x, (int)y)) {
                retval = 32;
            }
        }
        return retval;
    }

    public void handleMotion(int edge, float dx, float dy) {
        Rect r = this.computeLayout();
        if (edge == 1) {
            return;
        }
        if (edge == 32) {
            this.moveBy(dx * (this.mCropRect.width() / (float)r.width()), dy * (this.mCropRect.height() / (float)r.height()));
        } else {
            if ((6 & edge) == 0) {
                dx = 0.0f;
            }
            if ((0x18 & edge) == 0) {
                dy = 0.0f;
            }
            float xDelta = dx * (this.mCropRect.width() / (float)r.width());
            float yDelta = dy * (this.mCropRect.height() / (float)r.height());
            this.growBy((float)((edge & 2) != 0 ? -1 : 1) * xDelta, (float)((edge & 8) != 0 ? -1 : 1) * yDelta);
        }
    }

    void moveBy(float dx, float dy) {
        Rect invalRect = new Rect(this.mDrawRect);
        this.mCropRect.offset(dx, dy);
        this.mCropRect.offset(Math.max(0.0f, this.mImageRect.left - this.mCropRect.left), Math.max(0.0f, this.mImageRect.top - this.mCropRect.top));
        this.mCropRect.offset(Math.min(0.0f, this.mImageRect.right - this.mCropRect.right), Math.min(0.0f, this.mImageRect.bottom - this.mCropRect.bottom));
        this.mDrawRect = this.computeLayout();
        invalRect.union(this.mDrawRect);
        invalRect.inset(-10, -10);
        this.mContext.invalidate();
    }

    void growBy(float dx, float dy) {
        float heightCap;
        float adjustment;
        if (this.mMaintainAspectRatio) {
            if (dx != 0.0f) {
                dy = dx / this.mInitialAspectRatio;
            } else if (dy != 0.0f) {
                dx = dy * this.mInitialAspectRatio;
            }
        }
        RectF r = new RectF(this.mCropRect);
        if (dx > 0.0f && r.width() + 2.0f * dx > this.mImageRect.width()) {
            dx = adjustment = (this.mImageRect.width() - r.width()) / 2.0f;
            if (this.mMaintainAspectRatio) {
                dy = dx / this.mInitialAspectRatio;
            }
        }
        if (dy > 0.0f && r.height() + 2.0f * dy > this.mImageRect.height()) {
            dy = adjustment = (this.mImageRect.height() - r.height()) / 2.0f;
            if (this.mMaintainAspectRatio) {
                dx = dy * this.mInitialAspectRatio;
            }
        }
        r.inset(-dx, -dy);
        float widthCap = 25.0f;
        if (r.width() < 25.0f) {
            return;
        }
        float f = heightCap = this.mMaintainAspectRatio ? 25.0f / this.mInitialAspectRatio : 25.0f;
        if (r.height() < heightCap) {
            return;
        }
        if (r.left < this.mImageRect.left) {
            r.offset(this.mImageRect.left - r.left, 0.0f);
        } else if (r.right > this.mImageRect.right) {
            r.offset(-(r.right - this.mImageRect.right), 0.0f);
        }
        if (r.top < this.mImageRect.top) {
            r.offset(0.0f, this.mImageRect.top - r.top);
        } else if (r.bottom > this.mImageRect.bottom) {
            r.offset(0.0f, -(r.bottom - this.mImageRect.bottom));
        }
        this.mCropRect.set(r);
        this.mDrawRect = this.computeLayout();
        this.mContext.invalidate();
    }

    public Rect getCropRect() {
        return new Rect((int)this.mCropRect.left, (int)this.mCropRect.top, (int)this.mCropRect.right, (int)this.mCropRect.bottom);
    }

    private Rect computeLayout() {
        RectF r = new RectF(this.mCropRect.left, this.mCropRect.top, this.mCropRect.right, this.mCropRect.bottom);
        this.mMatrix.mapRect(r);
        return new Rect(Math.round(r.left), Math.round(r.top), Math.round(r.right), Math.round(r.bottom));
    }

    public void invalidate() {
        this.mDrawRect = this.computeLayout();
    }

    public void setup(Matrix m, Rect imageRect, RectF cropRect, boolean circle, boolean maintainAspectRatio) {
        if (circle) {
            maintainAspectRatio = true;
        }
        this.mMatrix = new Matrix(m);
        this.mCropRect = cropRect;
        this.mImageRect = new RectF(imageRect);
        this.mMaintainAspectRatio = maintainAspectRatio;
        this.mCircle = circle;
        this.mInitialAspectRatio = this.mCropRect.width() / this.mCropRect.height();
        this.mDrawRect = this.computeLayout();
        this.mFocusPaint.setARGB(125, 50, 50, 50);
        this.mNoFocusPaint.setARGB(125, 50, 50, 50);
        this.mOutlinePaint.setStrokeWidth(3.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
        this.mMode = ModifyMode.None;
        this.init();
    }

    public static enum ModifyMode {
        None,
        Move,
        Grow;

    }
}

