/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.progress;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.EmbossMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import com.ab.view.listener.AbOnProgressListener;

public class AbCircleProgressBar
extends View {
    private int progress = 0;
    private int max = 100;
    private Paint pathPaint = null;
    private Paint fillArcPaint = null;
    private RectF oval;
    private int[] arcColors = new int[]{-16596970, -12717242, -12521003, -16596970};
    private int[] shadowsColors = new int[]{-15658735, 0xAAAAAA, 0xAAAAAA};
    private int pathColor = -987425;
    private int pathBorderColor = -2960956;
    private int pathWidth = 35;
    private int width;
    private int height;
    private int radius = 120;
    private EmbossMaskFilter emboss = null;
    float[] direction = new float[]{1.0f, 1.0f, 1.0f};
    float light = 0.4f;
    float specular = 6.0f;
    float blur = 3.5f;
    private BlurMaskFilter mBlur = null;
    private AbOnProgressListener mAbOnProgressListener = null;
    private boolean reset = false;

    public AbCircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.pathPaint = new Paint();
        this.pathPaint.setAntiAlias(true);
        this.pathPaint.setFlags(1);
        this.pathPaint.setStyle(Paint.Style.STROKE);
        this.pathPaint.setDither(true);
        this.pathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.fillArcPaint = new Paint();
        this.fillArcPaint.setAntiAlias(true);
        this.fillArcPaint.setFlags(1);
        this.fillArcPaint.setStyle(Paint.Style.STROKE);
        this.fillArcPaint.setDither(true);
        this.fillArcPaint.setStrokeJoin(Paint.Join.ROUND);
        this.oval = new RectF();
        this.emboss = new EmbossMaskFilter(this.direction, this.light, this.specular, this.blur);
        this.mBlur = new BlurMaskFilter(20.0f, BlurMaskFilter.Blur.NORMAL);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.reset) {
            canvas.drawColor(0);
            this.reset = false;
        }
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredHeight();
        this.radius = this.getMeasuredWidth() / 2 - this.pathWidth;
        this.pathPaint.setColor(this.pathColor);
        this.pathPaint.setStrokeWidth((float)this.pathWidth);
        this.pathPaint.setMaskFilter((MaskFilter)this.emboss);
        canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)this.radius, this.pathPaint);
        this.pathPaint.setStrokeWidth(0.5f);
        this.pathPaint.setColor(this.pathBorderColor);
        canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)(this.radius + this.pathWidth / 2) + 0.5f, this.pathPaint);
        canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)(this.radius - this.pathWidth / 2) - 0.5f, this.pathPaint);
        SweepGradient sweepGradient = new SweepGradient((float)(this.width / 2), (float)(this.height / 2), this.arcColors, null);
        this.fillArcPaint.setShader((Shader)sweepGradient);
        this.fillArcPaint.setMaskFilter((MaskFilter)this.mBlur);
        this.fillArcPaint.setStrokeCap(Paint.Cap.ROUND);
        this.fillArcPaint.setStrokeWidth((float)this.pathWidth);
        this.oval.set((float)(this.width / 2 - this.radius), (float)(this.height / 2 - this.radius), (float)(this.width / 2 + this.radius), (float)(this.height / 2 + this.radius));
        canvas.drawArc(this.oval, -90.0f, (float)this.progress / (float)this.max * 360.0f, false, this.fillArcPaint);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.invalidate();
        if (this.mAbOnProgressListener != null) {
            if (this.max <= this.progress) {
                this.mAbOnProgressListener.onComplete(progress);
            } else {
                this.mAbOnProgressListener.onProgress(progress);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    public AbOnProgressListener getAbOnProgressListener() {
        return this.mAbOnProgressListener;
    }

    public void setAbOnProgressListener(AbOnProgressListener mAbOnProgressListener) {
        this.mAbOnProgressListener = mAbOnProgressListener;
    }

    public void reset() {
        this.reset = true;
        this.progress = 0;
        this.invalidate();
    }
}

