/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.ab.util.AbDateUtil;
import com.ab.util.AbFileUtil;
import com.ab.util.AbViewUtil;

public class AbListViewHeader
extends LinearLayout {
    private Context mContext;
    private LinearLayout headerView;
    private ImageView arrowImageView;
    private ProgressBar headerProgressBar;
    private Bitmap arrowImage = null;
    private TextView tipsTextview;
    private TextView headerTimeView;
    private int mState = -1;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;
    private final int ROTATE_ANIM_DURATION = 180;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_READY = 1;
    public static final int STATE_REFRESHING = 2;
    private String lastRefreshTime = null;
    private int headerHeight;

    public AbListViewHeader(Context context) {
        super(context);
        this.initView(context);
    }

    public AbListViewHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        this.headerView = new LinearLayout(context);
        this.headerView.setOrientation(0);
        this.headerView.setGravity(17);
        this.headerView.setPadding(0, 5, 0, 5);
        FrameLayout headImage = new FrameLayout(context);
        this.arrowImageView = new ImageView(context);
        this.arrowImage = AbFileUtil.getBitmapFormSrc("image/arrow.png");
        this.arrowImageView.setImageBitmap(this.arrowImage);
        this.headerProgressBar = new ProgressBar(context, null, 0x1010077);
        this.headerProgressBar.setVisibility(8);
        LinearLayout.LayoutParams layoutParamsWW = new LinearLayout.LayoutParams(-2, -2);
        layoutParamsWW.gravity = 17;
        layoutParamsWW.width = 50;
        layoutParamsWW.height = 50;
        headImage.addView((View)this.arrowImageView, (ViewGroup.LayoutParams)layoutParamsWW);
        headImage.addView((View)this.headerProgressBar, (ViewGroup.LayoutParams)layoutParamsWW);
        LinearLayout headTextLayout = new LinearLayout(context);
        this.tipsTextview = new TextView(context);
        this.headerTimeView = new TextView(context);
        headTextLayout.setOrientation(1);
        headTextLayout.setGravity(16);
        headTextLayout.setPadding(12, 0, 0, 0);
        LinearLayout.LayoutParams layoutParamsWW2 = new LinearLayout.LayoutParams(-2, -2);
        headTextLayout.addView((View)this.tipsTextview, (ViewGroup.LayoutParams)layoutParamsWW2);
        headTextLayout.addView((View)this.headerTimeView, (ViewGroup.LayoutParams)layoutParamsWW2);
        this.tipsTextview.setTextColor(Color.rgb((int)107, (int)107, (int)107));
        this.headerTimeView.setTextColor(Color.rgb((int)107, (int)107, (int)107));
        this.tipsTextview.setTextSize(15.0f);
        this.headerTimeView.setTextSize(14.0f);
        LinearLayout.LayoutParams layoutParamsWW3 = new LinearLayout.LayoutParams(-2, -2);
        layoutParamsWW3.gravity = 17;
        layoutParamsWW3.bottomMargin = 5;
        layoutParamsWW3.topMargin = 5;
        LinearLayout headerLayout = new LinearLayout(context);
        headerLayout.setOrientation(0);
        headerLayout.setGravity(17);
        headerLayout.addView((View)headImage, (ViewGroup.LayoutParams)layoutParamsWW3);
        headerLayout.addView((View)headTextLayout, (ViewGroup.LayoutParams)layoutParamsWW3);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.gravity = 80;
        this.headerView.addView((View)headerLayout, (ViewGroup.LayoutParams)lp);
        this.addView((View)this.headerView, (ViewGroup.LayoutParams)lp);
        AbViewUtil.measureView((View)this);
        this.headerHeight = this.getMeasuredHeight();
        this.headerView.setPadding(0, -1 * this.headerHeight, 0, 0);
        this.mRotateUpAnim = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateUpAnim.setDuration(180L);
        this.mRotateUpAnim.setFillAfter(true);
        this.mRotateDownAnim = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateDownAnim.setDuration(180L);
        this.mRotateDownAnim.setFillAfter(true);
        this.setState(0);
    }

    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        if (state == 2) {
            this.arrowImageView.clearAnimation();
            this.arrowImageView.setVisibility(4);
            this.headerProgressBar.setVisibility(0);
        } else {
            this.arrowImageView.setVisibility(0);
            this.headerProgressBar.setVisibility(4);
        }
        switch (state) {
            case 0: {
                if (this.mState == 1) {
                    this.arrowImageView.startAnimation(this.mRotateDownAnim);
                }
                if (this.mState == 2) {
                    this.arrowImageView.clearAnimation();
                }
                this.tipsTextview.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0");
                if (this.lastRefreshTime == null) {
                    this.lastRefreshTime = AbDateUtil.getCurrentDate(AbDateUtil.dateFormatHMS);
                    this.headerTimeView.setText((CharSequence)("\u5237\u65b0\u65f6\u95f4\uff1a" + this.lastRefreshTime));
                    break;
                }
                this.headerTimeView.setText((CharSequence)("\u4e0a\u6b21\u5237\u65b0\u65f6\u95f4\uff1a" + this.lastRefreshTime));
                break;
            }
            case 1: {
                if (this.mState == 1) break;
                this.arrowImageView.clearAnimation();
                this.arrowImageView.startAnimation(this.mRotateUpAnim);
                this.tipsTextview.setText((CharSequence)"\u677e\u5f00\u5237\u65b0");
                this.headerTimeView.setText((CharSequence)("\u4e0a\u6b21\u5237\u65b0\u65f6\u95f4\uff1a" + this.lastRefreshTime));
                this.lastRefreshTime = AbDateUtil.getCurrentDate(AbDateUtil.dateFormatHMS);
                break;
            }
            case 2: {
                this.tipsTextview.setText((CharSequence)"\u6b63\u5728\u5237\u65b0...");
                this.headerTimeView.setText((CharSequence)("\u672c\u6b21\u5237\u65b0\u65f6\u95f4\uff1a" + this.lastRefreshTime));
            }
        }
        this.mState = state;
    }

    public void setVisiableHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.headerView.getLayoutParams();
        lp.height = height;
        this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public int getVisiableHeight() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.headerView.getLayoutParams();
        return lp.height;
    }

    public LinearLayout getHeaderView() {
        return this.headerView;
    }

    public void setRefreshTime(String time) {
        this.headerTimeView.setText((CharSequence)time);
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setTextColor(int color) {
        this.tipsTextview.setTextColor(color);
        this.headerTimeView.setTextColor(color);
    }

    public void setBackgroundColor(int color) {
        this.headerView.setBackgroundColor(color);
    }

    public ProgressBar getHeaderProgressBar() {
        return this.headerProgressBar;
    }

    public void setHeaderProgressBarDrawable(Drawable indeterminateDrawable) {
        this.headerProgressBar.setIndeterminateDrawable(indeterminateDrawable);
    }
}

