/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ListAdapter;
import com.ab.view.pullview.AbMultiColumnAdapterView;
import com.ab.view.pullview.AbMultiColumnBaseAbsListView;
import com.ab.view.pullview.AbMultiColumnHeaderViewListAdapter;
import java.util.ArrayList;

public class AbMultiColumnAbsListView
extends AbMultiColumnBaseAbsListView {
    static final int NO_POSITION = -1;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private ArrayList<FixedViewInfo> mHeaderViewInfos = new ArrayList();
    private ArrayList<FixedViewInfo> mFooterViewInfos = new ArrayList();
    Drawable mOverScrollHeader;
    Drawable mOverScrollFooter;
    private boolean mIsCacheColorOpaque;
    private boolean mDividerIsOpaque;
    private boolean mAreAllItemsSelectable = true;
    private boolean mItemsCanFocus = false;
    private final Rect mTempRect = new Rect();

    public AbMultiColumnAbsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Drawable osFooter;
        Drawable osHeader = null;
        if (osHeader != null) {
            this.setOverscrollHeader(osHeader);
        }
        if ((osFooter = null) != null) {
            this.setOverscrollFooter(osFooter);
        }
    }

    public AbMultiColumnAbsListView(Context context) {
        super(context);
    }

    public int getMaxScrollAmount() {
        return (int)(0.33f * (float)(this.getBottom() - this.getTop()));
    }

    private void adjustViewsUpOrDown() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int delta;
            if (!this.mStackFromBottom) {
                int firstTop = this.getScrollChildTop();
                delta = firstTop - this.mListPadding.top;
                if (delta < 0) {
                    delta = 0;
                }
            } else {
                int lastBottom = this.getScrollChildBottom();
                delta = lastBottom - (this.getHeight() - this.mListPadding.bottom);
                if (delta > 0) {
                    delta = 0;
                }
            }
            if (delta != 0) {
                this.tryOffsetChildrenTopAndBottom(-delta);
            }
        }
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        FixedViewInfo info = new FixedViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean isFixedView(View v) {
        FixedViewInfo info;
        ArrayList<FixedViewInfo> where = this.mHeaderViewInfos;
        int len = where.size();
        int i = 0;
        while (i < len) {
            info = where.get(i);
            if (info.view == v) {
                return true;
            }
            ++i;
        }
        where = this.mFooterViewInfos;
        len = where.size();
        i = 0;
        while (i < len) {
            info = where.get(i);
            if (info.view == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            if (((AbMultiColumnHeaderViewListAdapter)this.mAdapter).removeHeader(v)) {
                this.mDataSetObserver.onChanged();
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private void removeFixedViewInfo(View v, ArrayList<FixedViewInfo> where) {
        int len = where.size();
        int i = 0;
        while (i < len) {
            FixedViewInfo info = where.get(i);
            if (info.view == v) {
                where.remove(i);
                break;
            }
            ++i;
        }
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        FixedViewInfo info = new FixedViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    @Override
    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            if (((AbMultiColumnHeaderViewListAdapter)this.mAdapter).removeFooter(v)) {
                this.mDataSetObserver.onChanged();
                result = true;
            }
            this.removeFixedViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new AbMultiColumnHeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter) : adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AbMultiColumnAdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
        } else {
            this.mAreAllItemsSelectable = true;
            this.checkFocus();
        }
        this.requestLayout();
    }

    @Override
    public int getFirstVisiblePosition() {
        return Math.max(0, this.mFirstPosition - this.getHeaderViewsCount());
    }

    @Override
    public int getLastVisiblePosition() {
        return Math.min(this.mFirstPosition + this.getChildCount() - 1, this.mAdapter.getCount() - 1);
    }

    @Override
    void resetList() {
        this.clearRecycledState(this.mHeaderViewInfos);
        this.clearRecycledState(this.mFooterViewInfos);
        super.resetList();
        this.mLayoutMode = 0;
    }

    private void clearRecycledState(ArrayList<FixedViewInfo> infos) {
        if (infos != null) {
            int count = infos.size();
            int i = 0;
            while (i < count) {
                View child = infos.get((int)i).view;
                AbMultiColumnBaseAbsListView.LayoutParams p = (AbMultiColumnBaseAbsListView.LayoutParams)child.getLayoutParams();
                if (p != null) {
                    p.recycledHeaderFooter = false;
                }
                ++i;
            }
        }
    }

    private boolean showingTopFadingEdge() {
        int listTop = this.getScrollY() + this.mListPadding.top;
        return this.mFirstPosition > 0 || this.getChildAt(0).getTop() > listTop;
    }

    private boolean showingBottomFadingEdge() {
        int childCount = this.getChildCount();
        int bottomOfBottomChild = this.getChildAt(childCount - 1).getBottom();
        int lastVisiblePosition = this.mFirstPosition + childCount - 1;
        int listBottom = this.getScrollY() + this.getHeight() - this.mListPadding.bottom;
        return lastVisiblePosition < this.mItemCount - 1 || bottomOfBottomChild < listBottom;
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        boolean scroll;
        int rectTopWithinChild = rect.top;
        rect.offset(child.getLeft(), child.getTop());
        rect.offset(-child.getScrollX(), -child.getScrollY());
        int height = this.getHeight();
        int listUnfadedTop = this.getScrollY();
        int listUnfadedBottom = listUnfadedTop + height;
        int fadingEdge = this.getVerticalFadingEdgeLength();
        if (this.showingTopFadingEdge() && rectTopWithinChild > fadingEdge) {
            listUnfadedTop += fadingEdge;
        }
        int childCount = this.getChildCount();
        int bottomOfBottomChild = this.getChildAt(childCount - 1).getBottom();
        if (this.showingBottomFadingEdge() && rect.bottom < bottomOfBottomChild - fadingEdge) {
            listUnfadedBottom -= fadingEdge;
        }
        int scrollYDelta = 0;
        if (rect.bottom > listUnfadedBottom && rect.top > listUnfadedTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - listUnfadedTop) : (scrollYDelta += rect.bottom - listUnfadedBottom);
            int distanceToBottom = bottomOfBottomChild - listUnfadedBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < listUnfadedTop && rect.bottom < listUnfadedBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= listUnfadedBottom - rect.bottom) : (scrollYDelta -= listUnfadedTop - rect.top);
            int top = this.getChildAt(0).getTop();
            int deltaToTop = top - listUnfadedTop;
            scrollYDelta = Math.max(scrollYDelta, deltaToTop);
        }
        boolean bl = scroll = scrollYDelta != 0;
        if (scroll) {
            this.scrollListItemsBy(-scrollYDelta);
            this.positionSelector(child);
            this.mSelectedTop = child.getTop();
            this.invalidate();
        }
        return scroll;
    }

    protected int getItemLeft(int pos) {
        return this.mListPadding.left;
    }

    protected int getItemTop(int pos) {
        int count = this.getChildCount();
        return count > 0 ? this.getChildAt(count - 1).getBottom() : this.getListPaddingTop();
    }

    protected int getItemBottom(int pos) {
        int count = this.getChildCount();
        return count > 0 ? this.getChildAt(0).getTop() : this.getHeight() - this.getListPaddingBottom();
    }

    @Override
    protected void fillGap(boolean down) {
        int count = this.getChildCount();
        if (down) {
            this.fillDown(this.mFirstPosition + count, this.getItemTop(this.mFirstPosition + count));
            this.onAdjustChildViews(down);
        } else {
            this.fillUp(this.mFirstPosition - 1, this.getItemBottom(this.mFirstPosition - 1));
            this.onAdjustChildViews(down);
        }
    }

    private View fillDown(int pos, int top) {
        int end = this.getBottom() - this.getTop() - this.mListPadding.bottom;
        int childTop = this.getFillChildBottom();
        while (childTop < end && pos < this.mItemCount) {
            this.makeAndAddView(pos, this.getItemTop(pos), true, false);
            ++pos;
            childTop = this.getFillChildBottom();
        }
        return null;
    }

    private View fillUp(int pos, int bottom) {
        int end = this.mListPadding.top;
        int childBottom = this.getFillChildTop();
        while (childBottom > end && pos >= 0) {
            this.makeAndAddView(pos, this.getItemBottom(pos), false, false);
            childBottom = this.getItemBottom(--pos);
        }
        this.mFirstPosition = pos + 1;
        return null;
    }

    private View fillFromTop(int nextTop) {
        this.mFirstPosition = Math.min(this.mFirstPosition, -1);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillDown(this.mFirstPosition, nextTop);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidth = 0;
        int childHeight = 0;
        int n = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (widthMode == 0 || heightMode == 0)) {
            View child = this.obtainView(0, this.mIsScrap);
            this.measureScrapChild(child, 0, widthMeasureSpec);
            childWidth = child.getMeasuredWidth();
            childHeight = child.getMeasuredHeight();
            if (this.recycleOnMeasure() && this.mRecycler.shouldRecycleViewType(((AbMultiColumnBaseAbsListView.LayoutParams)child.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(child);
            }
        }
        if (widthMode == 0) {
            widthSize = this.mListPadding.left + this.mListPadding.right + childWidth + this.getVerticalScrollbarWidth();
        }
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getVerticalFadingEdgeLength() * 2;
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = this.measureHeightOfChildren(widthMeasureSpec, 0, -1, heightSize, -1);
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    private void measureScrapChild(View child, int position, int widthMeasureSpec) {
        AbMultiColumnBaseAbsListView.LayoutParams p = (AbMultiColumnBaseAbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = new AbMultiColumnBaseAbsListView.LayoutParams(-1, -2, 0);
            child.setLayoutParams((ViewGroup.LayoutParams)p);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        p.forceAdd = true;
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.mListPadding.left + this.mListPadding.right), (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    protected boolean recycleOnMeasure() {
        return true;
    }

    final int measureHeightOfChildren(int widthMeasureSpec, int startPosition, int endPosition, int maxHeight, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return this.mListPadding.top + this.mListPadding.bottom;
        }
        int returnedHeight = this.mListPadding.top + this.mListPadding.bottom;
        int prevHeightWithoutPartialChild = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        AbMultiColumnBaseAbsListView.RecycleBin recycleBin = this.mRecycler;
        boolean recyle = this.recycleOnMeasure();
        boolean[] isScrap = this.mIsScrap;
        int i = startPosition;
        while (i <= endPosition) {
            View child = this.obtainView(i, isScrap);
            this.measureScrapChild(child, i, widthMeasureSpec);
            if (recyle && recycleBin.shouldRecycleViewType(((AbMultiColumnBaseAbsListView.LayoutParams)child.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(child);
            }
            if ((returnedHeight += child.getMeasuredHeight()) >= maxHeight) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedHeight != maxHeight ? prevHeightWithoutPartialChild : maxHeight;
            }
            if (disallowPartialChildPosition >= 0 && i >= disallowPartialChildPosition) {
                prevHeightWithoutPartialChild = returnedHeight;
            }
            ++i;
        }
        return returnedHeight;
    }

    @Override
    int findMotionRow(int y) {
        block6: {
            int childCount = this.getChildCount();
            if (childCount <= 0) break block6;
            if (!this.mStackFromBottom) {
                int i = 0;
                while (i < childCount) {
                    View v = this.getChildAt(i);
                    if (y <= v.getBottom()) {
                        return this.mFirstPosition + i;
                    }
                    ++i;
                }
            } else {
                int i = childCount - 1;
                while (i >= 0) {
                    View v = this.getChildAt(i);
                    if (y >= v.getTop()) {
                        return this.mFirstPosition + i;
                    }
                    --i;
                }
            }
        }
        return -1;
    }

    private View fillSpecific(int position, int top) {
        View temp = this.makeAndAddView(position, top, true, false);
        this.mFirstPosition = position;
        if (!this.mStackFromBottom) {
            this.fillUp(position - 1, temp.getTop());
            this.adjustViewsUpOrDown();
            this.fillDown(position + 1, temp.getBottom());
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooHigh(childCount);
            }
        } else {
            this.fillDown(position + 1, temp.getBottom());
            this.adjustViewsUpOrDown();
            this.fillUp(position - 1, temp.getTop());
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooLow(childCount);
            }
        }
        return null;
    }

    private void correctTooHigh(int childCount) {
        int lastPosition = this.mFirstPosition + childCount - 1;
        if (lastPosition == this.mItemCount - 1 && childCount > 0) {
            int lastBottom = this.getScrollChildBottom();
            int end = this.getBottom() - this.getTop() - this.mListPadding.bottom;
            int bottomOffset = end - lastBottom;
            int firstTop = this.getScrollChildTop();
            if (bottomOffset > 0 && (this.mFirstPosition > 0 || firstTop < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    bottomOffset = Math.min(bottomOffset, this.mListPadding.top - firstTop);
                }
                this.tryOffsetChildrenTopAndBottom(bottomOffset);
                if (this.mFirstPosition > 0) {
                    int newFirstTop = this.getScrollChildTop();
                    this.fillUp(this.mFirstPosition - 1, newFirstTop);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private void correctTooLow(int childCount) {
        if (this.mFirstPosition == 0 && childCount > 0) {
            int firstTop = this.getScrollChildTop();
            int start = this.mListPadding.top;
            int end = this.getBottom() - this.getTop() - this.mListPadding.bottom;
            int topOffset = firstTop - start;
            int lastBottom = this.getScrollChildBottom();
            int lastPosition = this.mFirstPosition + childCount - 1;
            if (topOffset > 0) {
                if (lastPosition < this.mItemCount - 1 || lastBottom > end) {
                    if (lastPosition == this.mItemCount - 1) {
                        topOffset = Math.min(topOffset, lastBottom - end);
                    }
                    this.tryOffsetChildrenTopAndBottom(-topOffset);
                    if (lastPosition < this.mItemCount - 1) {
                        this.fillDown(lastPosition + 1, this.getFillChildTop());
                        this.adjustViewsUpOrDown();
                    }
                } else if (lastPosition == this.mItemCount - 1) {
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    @Override
    protected void layoutChildren() {
        boolean blockLayoutRequests = this.mBlockLayoutRequests;
        if (blockLayoutRequests) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            super.layoutChildren();
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            int childrenTop = this.mListPadding.top;
            int childrenBottom = this.getBottom() - this.getTop() - this.mListPadding.bottom;
            int childCount = this.getChildCount();
            boolean index = false;
            View oldFirst = null;
            View focusLayoutRestoreView = null;
            switch (this.mLayoutMode) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    oldFirst = this.getChildAt(0);
                }
            }
            boolean dataChanged = this.mDataChanged;
            if (dataChanged) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            if (this.mItemCount != this.mAdapter.getCount()) {
                throw new IllegalStateException("The content of the adapter has changed but ListView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. [in ListView(" + this.getId() + ", " + ((Object)((Object)this)).getClass() + ") with Adapter(" + this.mAdapter.getClass() + ")]");
            }
            int firstPosition = this.mFirstPosition;
            AbMultiColumnBaseAbsListView.RecycleBin recycleBin = this.mRecycler;
            if (dataChanged) {
                int i = 0;
                while (i < childCount) {
                    recycleBin.addScrapView(this.getChildAt(i));
                    ++i;
                }
            } else {
                recycleBin.fillActiveViews(childCount, firstPosition);
            }
            View focusedChild = this.getFocusedChild();
            if (focusedChild != null) {
                if ((!dataChanged || this.isDirectChildHeaderOrFooter(focusedChild)) && (focusLayoutRestoreView = this.findFocus()) != null) {
                    focusLayoutRestoreView.onStartTemporaryDetach();
                }
                this.requestFocus();
            }
            switch (this.mLayoutMode) {
                case 5: {
                    this.onLayoutSync(this.mSyncPosition);
                    this.detachAllViewsFromParent();
                    this.fillSpecific(this.mSyncPosition, this.mSpecificTop);
                    this.onLayoutSyncFinished(this.mSyncPosition);
                    break;
                }
                case 3: {
                    this.detachAllViewsFromParent();
                    this.fillUp(this.mItemCount - 1, childrenBottom);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 1: {
                    this.detachAllViewsFromParent();
                    this.mFirstPosition = 0;
                    this.fillFromTop(childrenTop);
                    this.adjustViewsUpOrDown();
                    break;
                }
                default: {
                    if (childCount == 0) {
                        this.detachAllViewsFromParent();
                        if (!this.mStackFromBottom) {
                            this.fillFromTop(childrenTop);
                            break;
                        }
                        this.fillUp(this.mItemCount - 1, childrenBottom);
                        break;
                    }
                    if (this.mFirstPosition < this.mItemCount) {
                        this.onLayoutSync(this.mFirstPosition);
                        this.detachAllViewsFromParent();
                        this.fillSpecific(this.mFirstPosition, oldFirst == null ? childrenTop : oldFirst.getTop());
                        this.onLayoutSyncFinished(this.mFirstPosition);
                        break;
                    }
                    this.onLayoutSync(0);
                    this.detachAllViewsFromParent();
                    this.fillSpecific(0, childrenTop);
                    this.onLayoutSyncFinished(0);
                }
            }
            recycleBin.scrapActiveViews();
            if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                View child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (child != null) {
                    this.positionSelector(child);
                }
            } else {
                this.mSelectedTop = 0;
                this.mSelectorRect.setEmpty();
            }
            if (this.hasFocus() && focusLayoutRestoreView != null) {
                focusLayoutRestoreView.requestFocus();
            }
            if (focusLayoutRestoreView != null && focusLayoutRestoreView.getWindowToken() != null) {
                focusLayoutRestoreView.onFinishTemporaryDetach();
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            this.mNeedSync = false;
            this.invokeOnItemScrollListener();
        }
        finally {
            if (!blockLayoutRequests) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    private boolean isDirectChildHeaderOrFooter(View child) {
        ArrayList<FixedViewInfo> headers = this.mHeaderViewInfos;
        int numHeaders = headers.size();
        int i = 0;
        while (i < numHeaders) {
            if (child == headers.get((int)i).view) {
                return true;
            }
            ++i;
        }
        ArrayList<FixedViewInfo> footers = this.mFooterViewInfos;
        int numFooters = footers.size();
        int i2 = 0;
        while (i2 < numFooters) {
            if (child == footers.get((int)i2).view) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private View makeAndAddView(int position, int childrenBottomOrTop, boolean flow, boolean selected) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.getActiveView(position)) != null) {
            int childrenLeft = this.getItemLeft(position);
            this.setupChild(child, position, childrenBottomOrTop, flow, childrenLeft, selected, true);
            return child;
        }
        this.onItemAddedToList(position, flow);
        int childrenLeft = this.getItemLeft(position);
        child = this.obtainView(position, this.mIsScrap);
        this.setupChild(child, position, childrenBottomOrTop, flow, childrenLeft, selected, this.mIsScrap[0]);
        return child;
    }

    protected void onItemAddedToList(int position, boolean flow) {
    }

    private void setupChild(View child, int position, int y, boolean flowDown, int childrenLeft, boolean selected, boolean recycled) {
        int childTop;
        boolean isSelected = selected && this.shouldShowSelector();
        boolean updateChildSelected = isSelected ^ child.isSelected();
        int mode = this.mTouchMode;
        boolean isPressed = mode > 0 && mode < 3 && this.mMotionPosition == position;
        boolean updateChildPressed = isPressed ^ child.isPressed();
        boolean needToMeasure = !recycled || updateChildSelected || child.isLayoutRequested();
        AbMultiColumnBaseAbsListView.LayoutParams p = (AbMultiColumnBaseAbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = new AbMultiColumnBaseAbsListView.LayoutParams(-1, -2, 0);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        if (recycled && !p.forceAdd || p.recycledHeaderFooter && p.viewType == -2) {
            this.attachViewToParent(child, flowDown ? -1 : 0, p);
        } else {
            p.forceAdd = false;
            if (p.viewType == -2) {
                p.recycledHeaderFooter = true;
            }
            this.addViewInLayout(child, flowDown ? -1 : 0, p, true);
        }
        if (updateChildSelected) {
            child.setSelected(isSelected);
        }
        if (updateChildPressed) {
            child.setPressed(isPressed);
        }
        if (needToMeasure) {
            int childWidthSpec = ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mListPadding.left + this.mListPadding.right), (int)p.width);
            int lpHeight = p.height;
            int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.onMeasureChild(child, position, childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int n = childTop = flowDown ? y : y - h;
        if (needToMeasure) {
            int childRight = childrenLeft + w;
            int childBottom = childTop + h;
            this.onLayoutChild(child, position, childrenLeft, childTop, childRight, childBottom);
        } else {
            int offsetLeft = childrenLeft - child.getLeft();
            int offsetTop = childTop - child.getTop();
            this.onOffsetChild(child, position, offsetLeft, offsetTop);
        }
        if (this.mCachingStarted && !child.isDrawingCacheEnabled()) {
            child.setDrawingCacheEnabled(true);
        }
    }

    protected void onOffsetChild(View child, int position, int offsetLeft, int offsetTop) {
        child.offsetLeftAndRight(offsetLeft);
        child.offsetTopAndBottom(offsetTop);
    }

    protected void onLayoutChild(View child, int position, int l, int t, int r, int b) {
        child.layout(l, t, r, b);
    }

    protected void onMeasureChild(View child, int position, int widthMeasureSpec, int heightMeasureSpec) {
        child.measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onAdjustChildViews(boolean down) {
        if (down) {
            this.correctTooHigh(this.getChildCount());
        } else {
            this.correctTooLow(this.getChildCount());
        }
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    @Override
    public void setSelection(int position) {
    }

    @Override
    int lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int count = adapter.getCount();
        if (!this.mAreAllItemsSelectable) {
            if (lookDown) {
                position = Math.max(0, position);
                while (position < count && !adapter.isEnabled(position)) {
                    ++position;
                }
            } else {
                position = Math.min(position, count - 1);
                while (position >= 0 && !adapter.isEnabled(position)) {
                    --position;
                }
            }
            if (position < 0 || position >= count) {
                return -1;
            }
            return position;
        }
        if (position < 0 || position >= count) {
            return -1;
        }
        return position;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        boolean populated = super.dispatchPopulateAccessibilityEvent(event);
        if (!populated) {
            int itemCount = 0;
            int currentItemIndex = this.getSelectedItemPosition();
            ListAdapter adapter = this.getAdapter();
            if (adapter != null) {
                int count = adapter.getCount();
                if (count < 15) {
                    int i = 0;
                    while (i < count) {
                        if (adapter.isEnabled(i)) {
                            ++itemCount;
                        } else if (i <= currentItemIndex) {
                            --currentItemIndex;
                        }
                        ++i;
                    }
                } else {
                    itemCount = count;
                }
            }
            event.setItemCount(itemCount);
            event.setCurrentItemIndex(currentItemIndex);
        }
        return populated;
    }

    public boolean fullScroll(int direction) {
        boolean moved = false;
        if (direction == 33) {
            int position = this.lookForSelectablePosition(0, true);
            if (position >= 0) {
                this.mLayoutMode = 1;
                this.invokeOnItemScrollListener();
                moved = true;
            }
        } else if (direction == 130) {
            int position = this.lookForSelectablePosition(this.mItemCount - 1, true);
            if (position >= 0) {
                this.mLayoutMode = 3;
                this.invokeOnItemScrollListener();
            }
            moved = true;
        }
        if (moved && !this.awakenScrollBars()) {
            this.awakenScrollBars();
            this.invalidate();
        }
        return moved;
    }

    private void scrollListItemsBy(int amount) {
        this.tryOffsetChildrenTopAndBottom(amount);
        int listBottom = this.getHeight() - this.mListPadding.bottom;
        int listTop = this.mListPadding.top;
        AbMultiColumnBaseAbsListView.RecycleBin recycleBin = this.mRecycler;
        if (amount < 0) {
            View last = this.getLastChild();
            int numChildren = this.getChildCount();
            while (last.getBottom() < listBottom) {
                int lastVisiblePosition = this.mFirstPosition + numChildren - 1;
                if (lastVisiblePosition >= this.mItemCount - 1) break;
                this.addViewBelow(last, lastVisiblePosition);
                last = this.getLastChild();
                ++numChildren;
            }
            if (last.getBottom() < listBottom) {
                this.tryOffsetChildrenTopAndBottom(listBottom - last.getBottom());
            }
            View first = this.getChildAt(0);
            while (first.getBottom() < listTop) {
                AbMultiColumnBaseAbsListView.LayoutParams layoutParams = (AbMultiColumnBaseAbsListView.LayoutParams)first.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(first);
                    recycleBin.addScrapView(first);
                } else {
                    this.removeViewInLayout(first);
                }
                first = this.getChildAt(0);
                ++this.mFirstPosition;
            }
        } else {
            View first = this.getChildAt(0);
            while (first.getTop() > listTop && this.mFirstPosition > 0) {
                first = this.addViewAbove(first, this.mFirstPosition);
                --this.mFirstPosition;
            }
            if (first.getTop() > listTop) {
                this.tryOffsetChildrenTopAndBottom(listTop - first.getTop());
            }
            int lastIndex = this.getChildCount() - 1;
            View last = this.getChildAt(lastIndex);
            while (last.getTop() > listBottom) {
                AbMultiColumnBaseAbsListView.LayoutParams layoutParams = (AbMultiColumnBaseAbsListView.LayoutParams)last.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(last);
                    recycleBin.addScrapView(last);
                } else {
                    this.removeViewInLayout(last);
                }
                last = this.getChildAt(--lastIndex);
            }
        }
    }

    protected View getLastChild() {
        int numChildren = this.getChildCount();
        return this.getChildAt(numChildren - 1);
    }

    private View addViewAbove(View theView, int position) {
        int abovePosition = position - 1;
        View view = this.obtainView(abovePosition, this.mIsScrap);
        int edgeOfNewChild = theView.getTop();
        this.setupChild(view, abovePosition, edgeOfNewChild, false, this.mListPadding.left, false, this.mIsScrap[0]);
        return view;
    }

    private View addViewBelow(View theView, int position) {
        int belowPosition = position + 1;
        View view = this.obtainView(belowPosition, this.mIsScrap);
        int edgeOfNewChild = theView.getBottom();
        this.setupChild(view, belowPosition, edgeOfNewChild, true, this.mListPadding.left, false, this.mIsScrap[0]);
        return view;
    }

    public void setItemsCanFocus(boolean itemsCanFocus) {
        this.mItemsCanFocus = itemsCanFocus;
        if (!itemsCanFocus) {
            this.setDescendantFocusability(393216);
        }
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    public boolean isOpaque() {
        return this.mCachingStarted && this.mIsCacheColorOpaque && this.mDividerIsOpaque || super.isOpaque();
    }

    @Override
    public void setCacheColorHint(int color) {
        boolean opaque;
        this.mIsCacheColorOpaque = opaque = color >>> 24 == 255;
        super.setCacheColorHint(color);
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable, Rect bounds) {
        int height = drawable.getMinimumHeight();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.bottom - bounds.top;
        if (span < height) {
            bounds.top = bounds.bottom - height;
        }
        drawable.setBounds(bounds);
        drawable.draw(canvas);
        canvas.restore();
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable, Rect bounds) {
        int height = drawable.getMinimumHeight();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.bottom - bounds.top;
        if (span < height) {
            bounds.bottom = bounds.top + height;
        }
        drawable.setBounds(bounds);
        drawable.draw(canvas);
        canvas.restore();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean drawOverscrollFooter;
        Drawable overscrollHeader = this.mOverScrollHeader;
        Drawable overscrollFooter = this.mOverScrollFooter;
        boolean drawOverscrollHeader = overscrollHeader != null;
        boolean bl = drawOverscrollFooter = overscrollFooter != null;
        if (drawOverscrollHeader || drawOverscrollFooter) {
            Rect bounds = this.mTempRect;
            bounds.left = this.getPaddingLeft();
            bounds.right = this.getRight() - this.getLeft() - this.getPaddingRight();
            int count = this.getChildCount();
            int headerCount = this.mHeaderViewInfos.size();
            int itemCount = this.mItemCount;
            int footerLimit = itemCount - this.mFooterViewInfos.size() - 1;
            int first = this.mFirstPosition;
            boolean areAllItemsSelectable = this.mAreAllItemsSelectable;
            ListAdapter adapter = this.mAdapter;
            int listBottom = this.getBottom() - this.getTop() - this.mListPadding.bottom + this.getScrollY();
            if (!this.mStackFromBottom) {
                int bottom = 0;
                int scrollY = this.getScrollY();
                if (count > 0 && scrollY < 0 && drawOverscrollHeader) {
                    bounds.bottom = 0;
                    bounds.top = scrollY;
                    this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                }
                int i = 0;
                while (i < count) {
                    View child;
                    if (first + i >= headerCount && first + i < footerLimit && (bottom = (child = this.getChildAt(i)).getBottom()) < listBottom && (!drawOverscrollFooter || i != count - 1) && (areAllItemsSelectable || adapter.isEnabled(first + i) && (i == count - 1 || adapter.isEnabled(first + i + 1)))) {
                        bounds.top = bottom;
                        bounds.bottom = bottom;
                    }
                    ++i;
                }
                int overFooterBottom = this.getBottom() + this.getScrollY();
                if (drawOverscrollFooter && first + count == itemCount && overFooterBottom > bottom) {
                    bounds.top = bottom;
                    bounds.bottom = overFooterBottom;
                    this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                }
            } else {
                int start;
                int listTop = this.mListPadding.top;
                int scrollY = this.getScrollY();
                if (count > 0 && drawOverscrollHeader) {
                    bounds.top = scrollY;
                    bounds.bottom = this.getChildAt(0).getTop();
                    this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                }
                int i = start = drawOverscrollHeader ? 1 : 0;
                while (i < count) {
                    View child;
                    int top;
                    if (first + i >= headerCount && first + i < footerLimit && (top = (child = this.getChildAt(i)).getTop()) > listTop && (areAllItemsSelectable || adapter.isEnabled(first + i) && (i == count - 1 || adapter.isEnabled(first + i + 1)))) {
                        bounds.top = top;
                        bounds.bottom = top;
                    }
                    ++i;
                }
                if (count > 0 && scrollY > 0 && drawOverscrollFooter) {
                    int absListBottom;
                    bounds.top = absListBottom = this.getBottom();
                    bounds.bottom = absListBottom + scrollY;
                    this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    public void setOverscrollHeader(Drawable header) {
        this.mOverScrollHeader = header;
        if (this.getScrollY() < 0) {
            this.invalidate();
        }
    }

    public Drawable getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    public void setOverscrollFooter(Drawable footer) {
        this.mOverScrollFooter = footer;
        this.invalidate();
    }

    public Drawable getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        int closetChildIndex = -1;
        if (gainFocus && previouslyFocusedRect != null) {
            previouslyFocusedRect.offset(this.getScrollX(), this.getScrollY());
            ListAdapter adapter = this.mAdapter;
            if (adapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect otherRect = this.mTempRect;
            int minDistance = Integer.MAX_VALUE;
            int childCount = this.getChildCount();
            int firstPosition = this.mFirstPosition;
            int i = 0;
            while (i < childCount) {
                if (adapter.isEnabled(firstPosition + i)) {
                    View other = this.getChildAt(i);
                    other.getDrawingRect(otherRect);
                    this.offsetDescendantRectToMyCoords(other, otherRect);
                    int distance = AbMultiColumnAbsListView.getDistance(previouslyFocusedRect, otherRect, direction);
                    if (distance < minDistance) {
                        minDistance = distance;
                        closetChildIndex = i;
                    }
                }
                ++i;
            }
        }
        if (closetChildIndex >= 0) {
            this.setSelection(closetChildIndex + this.mFirstPosition);
        } else {
            this.requestLayout();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count > 0) {
            int i = 0;
            while (i < count) {
                this.addHeaderView(this.getChildAt(i));
                ++i;
            }
            this.removeAllViews();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mItemsCanFocus && ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        return super.onTouchEvent(ev);
    }

    @Override
    public boolean performItemClick(View view, int position, long id) {
        boolean handled = false;
        return handled |= super.performItemClick(view, position, id);
    }

    public void setItemChecked(int position, boolean value) {
    }

    public boolean isItemChecked(int position) {
        return false;
    }

    public int getCheckedItemPosition() {
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        return null;
    }

    @Deprecated
    public long[] getCheckItemIds() {
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            return this.getCheckedItemIds();
        }
        return new long[0];
    }

    public long[] getCheckedItemIds() {
        return new long[0];
    }

    public void clearChoices() {
    }

    public class FixedViewInfo {
        public View view;
        public Object data;
        public boolean isSelectable;
    }
}

