/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ListAdapter;
import android.widget.Scroller;
import com.ab.view.pullview.AbMultiColumnAdapterView;
import java.util.ArrayList;
import java.util.List;

public abstract class AbMultiColumnBaseAbsListView
extends AbMultiColumnAdapterView<ListAdapter>
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnTouchModeChangeListener {
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    static final int TOUCH_MODE_REST = -1;
    protected static final int TOUCH_MODE_DOWN = 0;
    protected static final int TOUCH_MODE_TAP = 1;
    protected static final int TOUCH_MODE_DONE_WAITING = 2;
    protected static final int TOUCH_MODE_SCROLL = 3;
    protected static final int TOUCH_MODE_FLING = 4;
    static final int LAYOUT_NORMAL = 0;
    static final int LAYOUT_FORCE_TOP = 1;
    static final int LAYOUT_SET_SELECTION = 2;
    static final int LAYOUT_FORCE_BOTTOM = 3;
    static final int LAYOUT_SPECIFIC = 4;
    static final int LAYOUT_SYNC = 5;
    static final int LAYOUT_MOVE_SELECTION = 6;
    int mLayoutMode = 0;
    AbMultiColumnAdapterView.AdapterDataSetObserver mDataSetObserver;
    protected ListAdapter mAdapter;
    boolean mDrawSelectorOnTop = false;
    Drawable mSelector;
    Rect mSelectorRect = new Rect();
    final RecycleBin mRecycler = new RecycleBin();
    int mSelectionLeftPadding = 0;
    int mSelectionTopPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionBottomPadding = 0;
    protected Rect mListPadding = new Rect();
    protected int mWidthMeasureSpec = 0;
    protected boolean mCachingStarted;
    protected int mMotionPosition;
    int mMotionViewOriginalTop;
    int mMotionViewNewTop;
    int mMotionX;
    int mMotionY;
    protected int mTouchMode = -1;
    int mLastY;
    int mMotionCorrection;
    private VelocityTracker mVelocityTracker;
    private FlingRunnable mFlingRunnable;
    private PositionScroller mPositionScroller;
    int mSelectedTop = 0;
    boolean mStackFromBottom;
    boolean mScrollingCacheEnabled;
    private OnScrollListener mOnScrollListener;
    private boolean mSmoothScrollbarEnabled = true;
    private Rect mTouchFrame;
    int mResurrectToPosition = -1;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    private static final int TOUCH_MODE_ON = 0;
    private static final int TOUCH_MODE_OFF = 1;
    private int mLastTouchMode = -1;
    private static final boolean PROFILE_SCROLLING = false;
    private boolean mScrollProfilingStarted = false;
    private static final boolean PROFILE_FLINGING = false;
    private boolean mFlingProfilingStarted = false;
    private Runnable mPendingCheckForTap;
    private PerformClick mPerformClick;
    private int mTranscriptMode;
    private int mCacheColorHint;
    private boolean mIsChildViewEnabled;
    private int mLastScrollState = 0;
    private int mTouchSlop;
    private Runnable mClearScrollingCache;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    final boolean[] mIsScrap = new boolean[1];
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    protected static final boolean DEBUG = false;
    private static final String TAG = "PLA_AbsListView";

    public AbMultiColumnBaseAbsListView(Context context) {
        super(context);
        this.initAbsListView();
        this.setVerticalScrollBarEnabled(true);
    }

    public AbMultiColumnBaseAbsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAbsListView();
        Drawable d = null;
        if (d != null) {
            this.setSelector(d);
        }
        this.mDrawSelectorOnTop = false;
        boolean stackFromBottom = false;
        this.setStackFromBottom(stackFromBottom);
        boolean scrollingCacheEnabled = true;
        this.setScrollingCacheEnabled(scrollingCacheEnabled);
        int transcriptMode = 0;
        this.setTranscriptMode(transcriptMode);
        int color = 0;
        this.setCacheColorHint(color);
        boolean smoothScrollbar = true;
        this.setSmoothScrollbarEnabled(smoothScrollbar);
    }

    private void initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void setOnScrollListener(OnScrollListener l) {
        this.mOnScrollListener = l;
        this.invokeOnItemScrollListener();
    }

    void invokeOnItemScrollListener() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    public void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled && !enabled) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = enabled;
    }

    public void getFocusedRect(Rect r) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(r);
            this.offsetDescendantRectToMyCoords(view, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    private void useDefaultSelector() {
        this.setSelector(this.getResources().getDrawable(17301602));
    }

    @ViewDebug.ExportedProperty
    public boolean isStackFromBottom() {
        return this.mStackFromBottom;
    }

    public void setStackFromBottom(boolean stackFromBottom) {
        if (this.mStackFromBottom != stackFromBottom) {
            this.mStackFromBottom = stackFromBottom;
            this.requestLayoutIfNecessary();
        }
    }

    void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        this.mDataChanged = true;
        this.requestLayout();
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.mSelectedTop = 0;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    protected int computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int extent = count * 100;
                View view = this.getChildAt(0);
                int top = this.getFillChildTop();
                int height = view.getHeight();
                if (height > 0) {
                    extent += top * 100 / height;
                }
                view = this.getChildAt(count - 1);
                int bottom = this.getScrollChildBottom();
                height = view.getHeight();
                if (height > 0) {
                    extent -= (bottom - this.getHeight()) * 100 / height;
                }
                return extent;
            }
            return 1;
        }
        return 0;
    }

    protected int computeVerticalScrollOffset() {
        int firstPosition = this.mFirstPosition;
        int childCount = this.getChildCount();
        if (firstPosition >= 0 && childCount > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int top = this.getFillChildTop();
                int height = view.getHeight();
                if (height > 0) {
                    return Math.max(firstPosition * 100 - top * 100 / height + (int)((float)this.getScrollY() / (float)this.getHeight() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int count = this.mItemCount;
                int index = firstPosition == 0 ? 0 : (firstPosition + childCount == count ? count : firstPosition + childCount / 2);
                return (int)((float)firstPosition + (float)childCount * ((float)index / (float)count));
            }
        }
        return 0;
    }

    protected int computeVerticalScrollRange() {
        int result = this.mSmoothScrollbarEnabled ? Math.max(this.mItemCount * 100, 0) : this.mItemCount;
        return result;
    }

    protected float getTopFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getTopFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition > 0) {
            return 1.0f;
        }
        int top = this.getChildAt(0).getTop();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return top < this.getPaddingTop() ? (float)(-(top - this.getPaddingTop())) / fadeLength : fadeEdge;
    }

    protected float getBottomFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getBottomFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition + count - 1 < this.mItemCount - 1) {
            return 1.0f;
        }
        int bottom = this.getChildAt(count - 1).getBottom();
        int height = this.getHeight();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return bottom > height - this.getPaddingBottom() ? (float)(bottom - height + this.getPaddingBottom()) / fadeLength : fadeEdge;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect listPadding = this.mListPadding;
        listPadding.left = this.mSelectionLeftPadding + this.getPaddingLeft();
        listPadding.top = this.mSelectionTopPadding + this.getPaddingTop();
        listPadding.right = this.mSelectionRightPadding + this.getPaddingRight();
        listPadding.bottom = this.mSelectionBottomPadding + this.getPaddingBottom();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        if (changed) {
            int childCount = this.getChildCount();
            int i = 0;
            while (i < childCount) {
                this.getChildAt(i).forceLayout();
                ++i;
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mInLayout = false;
    }

    protected void layoutChildren() {
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        return null;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    View obtainView(int position, boolean[] isScrap) {
        View child;
        isScrap[0] = false;
        View scrapView = this.mRecycler.getScrapView(position);
        if (scrapView != null) {
            child = this.mAdapter.getView(position, scrapView, (ViewGroup)this);
            if (child != scrapView) {
                this.mRecycler.addScrapView(scrapView);
                if (this.mCacheColorHint != 0) {
                    child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
                }
            } else {
                isScrap[0] = true;
                this.dispatchFinishTemporaryDetach(child);
            }
        } else {
            child = this.mAdapter.getView(position, null, (ViewGroup)this);
            if (this.mCacheColorHint != 0) {
                child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
            }
        }
        return child;
    }

    void positionSelector(View sel) {
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        this.positionSelector(selectorRect.left, selectorRect.top, selectorRect.right, selectorRect.bottom);
        boolean isChildViewEnabled = this.mIsChildViewEnabled;
        if (sel.isEnabled() != isChildViewEnabled) {
            this.mIsChildViewEnabled = !isChildViewEnabled;
            this.refreshDrawableState();
        }
    }

    private void positionSelector(int l, int t, int r, int b) {
        this.mSelectorRect.set(l - this.mSelectionLeftPadding, t - this.mSelectionTopPadding, r + this.mSelectionRightPadding, b + this.mSelectionBottomPadding);
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop = this.mDrawSelectorOnTop;
        if (!drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.getChildCount() > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
        }
    }

    boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected boolean shouldShowSelector() {
        return this.hasFocus() && !this.isInTouchMode() || this.touchModeDrawsInPressedState();
    }

    private void drawSelector(Canvas canvas) {
        if (this.shouldShowSelector() && this.mSelectorRect != null && !this.mSelectorRect.isEmpty()) {
            Drawable selector = this.mSelector;
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    public void setDrawSelectorOnTop(boolean onTop) {
        this.mDrawSelectorOnTop = onTop;
    }

    public void setSelector(int resID) {
        this.setSelector(this.getResources().getDrawable(resID));
    }

    public void setSelector(Drawable sel) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        Rect padding = new Rect();
        sel.getPadding(padding);
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
        sel.setCallback((Drawable.Callback)this);
        sel.setState(this.getDrawableState());
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mSelector != null) {
            this.mSelector.setState(this.getDrawableState());
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(extraSpace);
        }
        int enabledState = ENABLED_STATE_SET[0];
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        int enabledPos = -1;
        int i = state.length - 1;
        while (i >= 0) {
            if (state[i] == enabledState) {
                enabledPos = i;
                break;
            }
            --i;
        }
        if (enabledPos >= 0) {
            System.arraycopy(state, enabledPos + 1, state, enabledPos, state.length - enabledPos - 1);
        }
        return state;
    }

    public boolean verifyDrawable(Drawable dr) {
        return this.mSelector == dr || super.verifyDrawable(dr);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        if (treeObserver != null) {
            treeObserver.addOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRecycler.clear();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        if (treeObserver != null) {
            treeObserver.removeOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        int touchMode;
        super.onWindowFocusChanged(hasWindowFocus);
        int n = touchMode = this.isInTouchMode() ? 0 : 1;
        if (!hasWindowFocus) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.endFling();
                if (this.getScrollY() != 0) {
                    this.scrollTo(this.getScrollX(), 0);
                    this.invalidate();
                }
            }
        } else if (touchMode != this.mLastTouchMode && this.mLastTouchMode != -1) {
            this.mLayoutMode = 0;
            this.layoutChildren();
        }
        this.mLastTouchMode = touchMode;
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id) {
        return new AbMultiColumnAdapterView.AdapterContextMenuInfo(view, position, id);
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.mAdapter.getItemId(longPressPosition);
            boolean handled = false;
            if (this.mOnItemLongClickListener != null) {
                handled = this.mOnItemLongClickListener.onItemLongClick(this, originalView, longPressPosition, longPressId);
            }
            if (!handled) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(longPressPosition - this.mFirstPosition), longPressPosition, longPressId);
                handled = super.showContextMenuForChild(originalView);
            }
            return handled;
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    public int pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        int i = count - 1;
        while (i >= 0) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 0) {
                child.getHitRect(frame);
                if (frame.contains(x, y)) {
                    return this.mFirstPosition + i;
                }
            }
            --i;
        }
        return -1;
    }

    public long pointToRowId(int x, int y) {
        int position = this.pointToPosition(x, y);
        if (position >= 0) {
            return this.mAdapter.getItemId(position);
        }
        return Long.MIN_VALUE;
    }

    private boolean startScrollIfNeeded(int deltaY) {
        int distance = Math.abs(deltaY);
        if (distance > this.mTouchSlop) {
            this.createScrollingCache();
            this.mTouchMode = 3;
            this.mMotionCorrection = deltaY;
            this.setPressed(false);
            View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (motionView != null) {
                motionView.setPressed(false);
            }
            this.reportScrollStateChange(1);
            this.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return false;
    }

    public void onTouchModeChanged(boolean isInTouchMode) {
        if (isInTouchMode && this.getHeight() > 0 && this.getChildCount() > 0) {
            this.layoutChildren();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        int action = ev.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                int motionPosition = this.pointToPosition(x, y);
                if (!this.mDataChanged) {
                    if (this.mTouchMode != 4 && motionPosition >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(motionPosition)) {
                        this.mTouchMode = 0;
                        if (this.mPendingCheckForTap == null) {
                            this.mPendingCheckForTap = new CheckForTap();
                        }
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    } else {
                        if (ev.getEdgeFlags() != 0 && motionPosition < 0) {
                            return false;
                        }
                        if (this.mTouchMode == 4) {
                            this.createScrollingCache();
                            this.mTouchMode = 3;
                            this.mMotionCorrection = 0;
                            motionPosition = this.findMotionRow(y);
                            this.reportScrollStateChange(1);
                        }
                    }
                }
                if (motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                }
                this.mMotionX = x;
                this.mMotionY = y;
                this.mMotionPosition = motionPosition;
                this.mLastY = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                int y = (int)ev.getY(pointerIndex);
                int deltaY = y - this.mMotionY;
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.startScrollIfNeeded(deltaY);
                        break;
                    }
                    case 3: {
                        if (y == this.mLastY) break;
                        int incrementalDeltaY = this.mLastY != Integer.MIN_VALUE ? y - this.mLastY : (deltaY -= this.mMotionCorrection);
                        boolean atEdge = false;
                        if (incrementalDeltaY != 0) {
                            atEdge = this.trackMotionScroll(deltaY, incrementalDeltaY);
                        }
                        if (atEdge && this.getChildCount() > 0) {
                            int motionPosition = this.findMotionRow(y);
                            if (motionPosition >= 0) {
                                View motionView = this.getChildAt(motionPosition - this.mFirstPosition);
                                this.mMotionViewOriginalTop = motionView.getTop();
                            }
                            this.mMotionY = y;
                            this.mMotionPosition = motionPosition;
                            this.invalidate();
                        }
                        this.mLastY = y;
                    }
                }
                break;
            }
            case 1: {
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        int motionPosition = this.mMotionPosition;
                        final View child = this.getChildAt(motionPosition - this.mFirstPosition);
                        if (child != null && !child.hasFocusable()) {
                            if (this.mTouchMode != 0) {
                                child.setPressed(false);
                            }
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            final PerformClick performClick = this.mPerformClick;
                            performClick.mChild = child;
                            performClick.mClickMotionPosition = motionPosition;
                            performClick.rememberWindowAttachCount();
                            this.mResurrectToPosition = motionPosition;
                            if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                                this.mLayoutMode = 0;
                                if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                    Drawable d;
                                    this.mTouchMode = 1;
                                    this.layoutChildren();
                                    child.setPressed(true);
                                    this.positionSelector(child);
                                    this.setPressed(true);
                                    if (this.mSelector != null && (d = this.mSelector.getCurrent()) != null && d instanceof TransitionDrawable) {
                                        ((TransitionDrawable)d).resetTransition();
                                    }
                                    this.postDelayed(new Runnable(){

                                        @Override
                                        public void run() {
                                            child.setPressed(false);
                                            AbMultiColumnBaseAbsListView.this.setPressed(false);
                                            if (!AbMultiColumnBaseAbsListView.this.mDataChanged) {
                                                AbMultiColumnBaseAbsListView.this.post(performClick);
                                            }
                                            AbMultiColumnBaseAbsListView.this.mTouchMode = -1;
                                        }
                                    }, ViewConfiguration.getPressedStateDuration());
                                } else {
                                    this.mTouchMode = -1;
                                }
                                return true;
                            }
                            if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                this.post(performClick);
                            }
                        }
                        this.mTouchMode = -1;
                        break;
                    }
                    case 3: {
                        int childCount = this.getChildCount();
                        if (childCount > 0) {
                            int top = this.getFillChildTop();
                            int bottom = this.getFillChildBottom();
                            if (this.mFirstPosition == 0 && top >= this.mListPadding.top && this.mFirstPosition + childCount < this.mItemCount && bottom <= this.getHeight() - this.mListPadding.bottom) {
                                this.mTouchMode = -1;
                                this.reportScrollStateChange(0);
                                break;
                            }
                            VelocityTracker velocityTracker = this.mVelocityTracker;
                            velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                            int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                            if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                                if (this.mFlingRunnable == null) {
                                    this.mFlingRunnable = new FlingRunnable();
                                }
                                this.reportScrollStateChange(2);
                                this.mFlingRunnable.start(-initialVelocity);
                                break;
                            }
                            this.mTouchMode = -1;
                            this.reportScrollStateChange(0);
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                    }
                }
                this.setPressed(false);
                this.invalidate();
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mActivePointerId = -1;
                break;
            }
            case 3: {
                this.mTouchMode = -1;
                this.setPressed(false);
                View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (motionView != null) {
                    motionView.setPressed(false);
                }
                this.clearScrollingCache();
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int x = this.mMotionX;
                int y = this.mMotionY;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastY = y;
            }
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        block0 : switch (action & 0xFF) {
            case 0: {
                int touchMode = this.mTouchMode;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                int motionPosition = this.findMotionRow(y);
                if (touchMode != 4 && motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionX = x;
                    this.mMotionY = y;
                    this.mMotionPosition = motionPosition;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastY = Integer.MIN_VALUE;
                if (touchMode != 4) break;
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                        int y = (int)ev.getY(pointerIndex);
                        if (!this.startScrollIfNeeded(y - this.mMotionY)) break block0;
                        return true;
                    }
                }
                break;
            }
            case 1: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return false;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mMotionX = (int)ev.getX(newPointerIndex);
            this.mMotionY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    public void addTouchables(ArrayList<View> views) {
        int count = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        int i = 0;
        while (i < count) {
            View child = this.getChildAt(i);
            if (adapter.isEnabled(firstPosition + i)) {
                views.add(child);
            }
            child.addTouchables(views);
            ++i;
        }
    }

    void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(this, newState);
            this.mLastScrollState = newState;
        }
    }

    public void smoothScrollToPosition(int position) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(position);
    }

    public void smoothScrollToPosition(int position, int boundPosition) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(position, boundPosition);
    }

    public void smoothScrollBy(int distance, int duration) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        } else {
            this.mFlingRunnable.endFling();
        }
        this.mFlingRunnable.startScroll(distance, duration);
    }

    private void createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingStarted = true;
        }
    }

    private void clearScrollingCache() {
        if (this.mClearScrollingCache == null) {
            this.mClearScrollingCache = new Runnable(){

                @Override
                public void run() {
                    if (AbMultiColumnBaseAbsListView.this.mCachingStarted) {
                        AbMultiColumnBaseAbsListView.this.mCachingStarted = false;
                        AbMultiColumnBaseAbsListView.this.setChildrenDrawnWithCacheEnabled(false);
                        int mPersistentDrawingCache = AbMultiColumnBaseAbsListView.this.getPersistentDrawingCache();
                        if ((mPersistentDrawingCache & 2) == 0) {
                            AbMultiColumnBaseAbsListView.this.setChildrenDrawingCacheEnabled(false);
                        }
                        if (!AbMultiColumnBaseAbsListView.this.isAlwaysDrawnWithCacheEnabled()) {
                            AbMultiColumnBaseAbsListView.this.invalidate();
                        }
                    }
                }
            };
        }
        this.post(this.mClearScrollingCache);
    }

    boolean trackMotionScroll(int deltaY, int incrementalDeltaY) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        int firstTop = this.getScrollChildTop();
        int lastBottom = this.getScrollChildBottom();
        Rect listPadding = this.mListPadding;
        int end = this.getHeight() - listPadding.bottom;
        int spaceAbove = listPadding.top - this.getFillChildTop();
        int spaceBelow = this.getFillChildBottom() - end;
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        deltaY = deltaY < 0 ? Math.max(-(height - 1), deltaY) : Math.min(height - 1, deltaY);
        incrementalDeltaY = incrementalDeltaY < 0 ? Math.max(-(height - 1), incrementalDeltaY) : Math.min(height - 1, incrementalDeltaY);
        int firstPosition = this.mFirstPosition;
        if (firstPosition == 0 && firstTop >= listPadding.top && deltaY >= 0) {
            return true;
        }
        if (firstPosition + childCount == this.mItemCount && lastBottom <= end && deltaY <= 0) {
            return true;
        }
        boolean down = incrementalDeltaY < 0;
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        int start = 0;
        int count = 0;
        if (down) {
            int top = listPadding.top - incrementalDeltaY;
            int i = 0;
            while (i < childCount) {
                View child = this.getChildAt(i);
                if (child.getBottom() < top) {
                    ++count;
                    int position = firstPosition + i;
                    if (position >= headerViewsCount && position < footerViewsStart) {
                        this.mRecycler.addScrapView(child);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int bottom = this.getHeight() - listPadding.bottom - incrementalDeltaY;
            int i = childCount - 1;
            while (i >= 0) {
                View child = this.getChildAt(i);
                if (child.getTop() > bottom) {
                    start = i;
                    ++count;
                    int position = firstPosition + i;
                    if (position >= headerViewsCount && position < footerViewsStart) {
                        this.mRecycler.addScrapView(child);
                    }
                    --i;
                    continue;
                }
                break;
            }
        }
        this.mMotionViewNewTop = this.mMotionViewOriginalTop + deltaY;
        this.mBlockLayoutRequests = true;
        if (count > 0) {
            this.detachViewsFromParent(start, count);
        }
        this.tryOffsetChildrenTopAndBottom(incrementalDeltaY);
        if (down) {
            this.mFirstPosition += count;
        }
        this.invalidate();
        int absIncrementalDeltaY = Math.abs(incrementalDeltaY);
        if (spaceAbove < absIncrementalDeltaY || spaceBelow < absIncrementalDeltaY) {
            this.fillGap(down);
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        this.awakenScrollBars();
        return false;
    }

    protected void tryOffsetChildrenTopAndBottom(int offset) {
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            View v = this.getChildAt(i);
            v.offsetTopAndBottom(offset);
            ++i;
        }
    }

    int getHeaderViewsCount() {
        return 0;
    }

    int getFooterViewsCount() {
        return 0;
    }

    abstract void fillGap(boolean var1);

    abstract int findMotionRow(int var1);

    int findClosestMotionRow(int y) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int motionRow = this.findMotionRow(y);
        return motionRow != -1 ? motionRow : this.mFirstPosition + childCount - 1;
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    protected void handleDataChanged() {
        int count = this.mItemCount;
        if (count > 0) {
            if (this.mNeedSync) {
                this.mNeedSync = false;
                if (this.mTranscriptMode == 2 || this.mTranscriptMode == 1 && this.mFirstPosition + this.getChildCount() >= this.mOldItemCount) {
                    this.mLayoutMode = 3;
                    return;
                }
                switch (this.mSyncMode) {
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                int newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                int selectablePos = this.lookForSelectablePosition(newPos, true);
                selectablePos = this.lookForSelectablePosition(newPos, false);
                if (selectablePos >= 0) {
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromBottom ? 3 : 1;
        this.mNeedSync = false;
    }

    protected void onLayoutSync(int syncPosition) {
    }

    protected void onLayoutSyncFinished(int syncPosition) {
    }

    static int getDistance(Rect source, Rect dest, int direction) {
        int dY;
        int dX;
        int sY;
        int sX;
        switch (direction) {
            case 66: {
                sX = source.right;
                sY = source.top + source.height() / 2;
                dX = dest.left;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 130: {
                sX = source.left + source.width() / 2;
                sY = source.bottom;
                dX = dest.left + dest.width() / 2;
                dY = dest.top;
                break;
            }
            case 17: {
                sX = source.left;
                sY = source.top + source.height() / 2;
                dX = dest.right;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 33: {
                sX = source.left + source.width() / 2;
                sY = source.top;
                dX = dest.left + dest.width() / 2;
                dY = dest.bottom;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
        }
        int deltaX = dX - sX;
        int deltaY = dY - sY;
        return deltaY * deltaY + deltaX * deltaX;
    }

    public void onGlobalLayout() {
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setTranscriptMode(int mode) {
        this.mTranscriptMode = mode;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public void setCacheColorHint(int color) {
        if (color != this.mCacheColorHint) {
            this.mCacheColorHint = color;
            int count = this.getChildCount();
            int i = 0;
            while (i < count) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(color);
                ++i;
            }
            this.mRecycler.setCacheColorHint(color);
        }
    }

    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    public void reclaimViews(List<View> views) {
        int childCount = this.getChildCount();
        RecyclerListener listener = this.mRecycler.mRecyclerListener;
        int i = 0;
        while (i < childCount) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp != null && this.mRecycler.shouldRecycleViewType(lp.viewType)) {
                views.add(child);
                if (listener != null) {
                    listener.onMovedToScrapHeap(child);
                }
            }
            ++i;
        }
        this.mRecycler.reclaimScrapViews(views);
        this.removeAllViewsInLayout();
    }

    public void setRecyclerListener(RecyclerListener listener) {
        this.mRecycler.mRecyclerListener = listener;
    }

    private void dispatchFinishTemporaryDetach(View v) {
        if (v == null) {
            return;
        }
        v.onFinishTemporaryDetach();
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int count = group.getChildCount();
            int i = 0;
            while (i < count) {
                this.dispatchFinishTemporaryDetach(group.getChildAt(i));
                ++i;
            }
        }
    }

    protected int modifyFlingInitialVelocity(int initialVelocity) {
        return initialVelocity;
    }

    protected int getScrollChildTop() {
        int count = this.getChildCount();
        if (count == 0) {
            return 0;
        }
        return this.getChildAt(0).getTop();
    }

    protected int getFirstChildTop() {
        int count = this.getChildCount();
        if (count == 0) {
            return 0;
        }
        return this.getChildAt(0).getTop();
    }

    protected int getFillChildTop() {
        int count = this.getChildCount();
        if (count == 0) {
            return 0;
        }
        return this.getChildAt(0).getTop();
    }

    protected int getFillChildBottom() {
        int count = this.getChildCount();
        if (count == 0) {
            return 0;
        }
        return this.getChildAt(count - 1).getBottom();
    }

    protected int getScrollChildBottom() {
        int count = this.getChildCount();
        if (count == 0) {
            return 0;
        }
        return this.getChildAt(count - 1).getBottom();
    }

    final class CheckForTap
    implements Runnable {
        CheckForTap() {
        }

        @Override
        public void run() {
            if (AbMultiColumnBaseAbsListView.this.mTouchMode == 0) {
                AbMultiColumnBaseAbsListView.this.mTouchMode = 1;
                View child = AbMultiColumnBaseAbsListView.this.getChildAt(AbMultiColumnBaseAbsListView.this.mMotionPosition - AbMultiColumnBaseAbsListView.this.mFirstPosition);
                if (child != null && !child.hasFocusable()) {
                    AbMultiColumnBaseAbsListView.this.mLayoutMode = 0;
                    if (!AbMultiColumnBaseAbsListView.this.mDataChanged) {
                        Drawable d;
                        AbMultiColumnBaseAbsListView.this.layoutChildren();
                        child.setPressed(true);
                        AbMultiColumnBaseAbsListView.this.positionSelector(child);
                        AbMultiColumnBaseAbsListView.this.setPressed(true);
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = AbMultiColumnBaseAbsListView.this.isLongClickable();
                        if (AbMultiColumnBaseAbsListView.this.mSelector != null && (d = AbMultiColumnBaseAbsListView.this.mSelector.getCurrent()) != null && d instanceof TransitionDrawable) {
                            if (longClickable) {
                                ((TransitionDrawable)d).startTransition(longPressTimeout);
                            } else {
                                ((TransitionDrawable)d).resetTransition();
                            }
                        }
                        if (!longClickable) {
                            AbMultiColumnBaseAbsListView.this.mTouchMode = 2;
                        }
                    } else {
                        AbMultiColumnBaseAbsListView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final Scroller mScroller;
        private int mLastFlingY;

        FlingRunnable() {
            this.mScroller = new Scroller(AbMultiColumnBaseAbsListView.this.getContext());
        }

        void start(int initialVelocity) {
            int initialY;
            this.mLastFlingY = initialY = (initialVelocity = AbMultiColumnBaseAbsListView.this.modifyFlingInitialVelocity(initialVelocity)) < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.fling(0, initialY, 0, initialVelocity, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            AbMultiColumnBaseAbsListView.this.mTouchMode = 4;
            AbMultiColumnBaseAbsListView.this.post(this);
        }

        void startScroll(int distance, int duration) {
            int initialY;
            this.mLastFlingY = initialY = distance < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.startScroll(0, initialY, 0, distance, duration);
            AbMultiColumnBaseAbsListView.this.mTouchMode = 4;
            AbMultiColumnBaseAbsListView.this.post(this);
        }

        private void endFling() {
            this.mLastFlingY = 0;
            AbMultiColumnBaseAbsListView.this.mTouchMode = -1;
            AbMultiColumnBaseAbsListView.this.reportScrollStateChange(0);
            AbMultiColumnBaseAbsListView.this.clearScrollingCache();
            AbMultiColumnBaseAbsListView.this.removeCallbacks(this);
            if (AbMultiColumnBaseAbsListView.this.mPositionScroller != null) {
                AbMultiColumnBaseAbsListView.this.removeCallbacks(AbMultiColumnBaseAbsListView.this.mPositionScroller);
            }
            this.mScroller.forceFinished(true);
        }

        @Override
        public void run() {
            switch (AbMultiColumnBaseAbsListView.this.mTouchMode) {
                default: {
                    return;
                }
                case 4: 
            }
            if (AbMultiColumnBaseAbsListView.this.mItemCount == 0 || AbMultiColumnBaseAbsListView.this.getChildCount() == 0) {
                this.endFling();
                return;
            }
            Scroller scroller = this.mScroller;
            boolean more = scroller.computeScrollOffset();
            int y = scroller.getCurrY();
            int delta = this.mLastFlingY - y;
            if (delta > 0) {
                AbMultiColumnBaseAbsListView.this.mMotionPosition = AbMultiColumnBaseAbsListView.this.mFirstPosition;
                AbMultiColumnBaseAbsListView.this.mMotionViewOriginalTop = AbMultiColumnBaseAbsListView.this.getScrollChildTop();
                delta = Math.min(AbMultiColumnBaseAbsListView.this.getHeight() - AbMultiColumnBaseAbsListView.this.getPaddingBottom() - AbMultiColumnBaseAbsListView.this.getPaddingTop() - 1, delta);
            } else {
                int offsetToLast = AbMultiColumnBaseAbsListView.this.getChildCount() - 1;
                AbMultiColumnBaseAbsListView.this.mMotionPosition = AbMultiColumnBaseAbsListView.this.mFirstPosition + offsetToLast;
                AbMultiColumnBaseAbsListView.this.mMotionViewOriginalTop = AbMultiColumnBaseAbsListView.this.getScrollChildBottom();
                delta = Math.max(-(AbMultiColumnBaseAbsListView.this.getHeight() - AbMultiColumnBaseAbsListView.this.getPaddingBottom() - AbMultiColumnBaseAbsListView.this.getPaddingTop() - 1), delta);
            }
            boolean atEnd = AbMultiColumnBaseAbsListView.this.trackMotionScroll(delta, delta);
            if (more && !atEnd) {
                AbMultiColumnBaseAbsListView.this.invalidate();
                this.mLastFlingY = y;
                AbMultiColumnBaseAbsListView.this.post(this);
            } else {
                this.endFling();
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=-1, to="ITEM_VIEW_TYPE_IGNORE"), @ViewDebug.IntToString(from=-2, to="ITEM_VIEW_TYPE_HEADER_OR_FOOTER")})
        public int viewType;
        @ViewDebug.ExportedProperty
        public boolean recycledHeaderFooter;
        @ViewDebug.ExportedProperty
        public boolean forceAdd;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, int viewType) {
            super(w, h);
            this.viewType = viewType;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbMultiColumnBaseAbsListView var1, int var2);

        public void onScroll(AbMultiColumnBaseAbsListView var1, int var2, int var3, int var4);
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable {
        View mChild;
        int mClickMotionPosition;

        private PerformClick() {
        }

        @Override
        public void run() {
            if (AbMultiColumnBaseAbsListView.this.mDataChanged) {
                return;
            }
            ListAdapter adapter = AbMultiColumnBaseAbsListView.this.mAdapter;
            int motionPosition = this.mClickMotionPosition;
            if (adapter != null && AbMultiColumnBaseAbsListView.this.mItemCount > 0 && motionPosition != -1 && motionPosition < adapter.getCount() && this.sameWindow()) {
                AbMultiColumnBaseAbsListView.this.performItemClick(this.mChild, motionPosition, adapter.getItemId(motionPosition));
            }
        }
    }

    class PositionScroller
    implements Runnable {
        private static final int SCROLL_DURATION = 400;
        private static final int MOVE_DOWN_POS = 1;
        private static final int MOVE_UP_POS = 2;
        private static final int MOVE_DOWN_BOUND = 3;
        private static final int MOVE_UP_BOUND = 4;
        private int mMode;
        private int mTargetPos;
        private int mBoundPos;
        private int mLastSeenPos;
        private int mScrollDuration;
        private final int mExtraScroll;

        PositionScroller() {
            this.mExtraScroll = ViewConfiguration.get((Context)AbMultiColumnBaseAbsListView.this.getContext()).getScaledFadingEdgeLength();
        }

        void start(int position) {
            int firstPos = AbMultiColumnBaseAbsListView.this.mFirstPosition;
            int lastPos = firstPos + AbMultiColumnBaseAbsListView.this.getChildCount() - 1;
            int viewTravelCount = 0;
            if (position <= firstPos) {
                viewTravelCount = firstPos - position + 1;
                this.mMode = 2;
            } else if (position >= lastPos) {
                viewTravelCount = position - lastPos + 1;
                this.mMode = 1;
            } else {
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 400 / viewTravelCount : 400;
            this.mTargetPos = position;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            AbMultiColumnBaseAbsListView.this.post(this);
        }

        void start(int position, int boundPosition) {
            if (boundPosition == -1) {
                this.start(position);
                return;
            }
            int firstPos = AbMultiColumnBaseAbsListView.this.mFirstPosition;
            int lastPos = firstPos + AbMultiColumnBaseAbsListView.this.getChildCount() - 1;
            int viewTravelCount = 0;
            if (position <= firstPos) {
                int boundPosFromLast = lastPos - boundPosition;
                if (boundPosFromLast < 1) {
                    return;
                }
                int boundTravel = boundPosFromLast - 1;
                int posTravel = firstPos - position + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 4;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 2;
                }
            } else if (position >= lastPos) {
                int boundPosFromFirst = boundPosition - firstPos;
                if (boundPosFromFirst < 1) {
                    return;
                }
                int boundTravel = boundPosFromFirst - 1;
                int posTravel = position - lastPos + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 3;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 1;
                }
            } else {
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 400 / viewTravelCount : 400;
            this.mTargetPos = position;
            this.mBoundPos = boundPosition;
            this.mLastSeenPos = -1;
            AbMultiColumnBaseAbsListView.this.post(this);
        }

        void stop() {
            AbMultiColumnBaseAbsListView.this.removeCallbacks(this);
        }

        @Override
        public void run() {
            int listHeight = AbMultiColumnBaseAbsListView.this.getHeight();
            int firstPos = AbMultiColumnBaseAbsListView.this.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int lastViewIndex = AbMultiColumnBaseAbsListView.this.getChildCount() - 1;
                    int lastPos = firstPos + lastViewIndex;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    if (lastPos == this.mLastSeenPos) {
                        AbMultiColumnBaseAbsListView.this.post(this);
                        return;
                    }
                    View lastView = AbMultiColumnBaseAbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = lastPos < AbMultiColumnBaseAbsListView.this.mItemCount - 1 ? this.mExtraScroll : AbMultiColumnBaseAbsListView.this.mListPadding.bottom;
                    AbMultiColumnBaseAbsListView.this.smoothScrollBy(lastViewHeight - lastViewPixelsShowing + extraScroll, this.mScrollDuration);
                    this.mLastSeenPos = lastPos;
                    if (lastPos >= this.mTargetPos) break;
                    AbMultiColumnBaseAbsListView.this.post(this);
                    break;
                }
                case 3: {
                    boolean nextViewIndex = true;
                    int childCount = AbMultiColumnBaseAbsListView.this.getChildCount();
                    if (firstPos == this.mBoundPos || childCount <= 1 || firstPos + childCount >= AbMultiColumnBaseAbsListView.this.mItemCount) {
                        return;
                    }
                    int nextPos = firstPos + 1;
                    if (nextPos == this.mLastSeenPos) {
                        AbMultiColumnBaseAbsListView.this.post(this);
                        return;
                    }
                    View nextView = AbMultiColumnBaseAbsListView.this.getChildAt(1);
                    int nextViewHeight = nextView.getHeight();
                    int nextViewTop = nextView.getTop();
                    int extraScroll = this.mExtraScroll;
                    if (nextPos < this.mBoundPos) {
                        AbMultiColumnBaseAbsListView.this.smoothScrollBy(Math.max(0, nextViewHeight + nextViewTop - extraScroll), this.mScrollDuration);
                        this.mLastSeenPos = nextPos;
                        AbMultiColumnBaseAbsListView.this.post(this);
                        break;
                    }
                    if (nextViewTop <= extraScroll) break;
                    AbMultiColumnBaseAbsListView.this.smoothScrollBy(nextViewTop - extraScroll, this.mScrollDuration);
                    break;
                }
                case 2: {
                    if (firstPos == this.mLastSeenPos) {
                        AbMultiColumnBaseAbsListView.this.post(this);
                        return;
                    }
                    View firstView = AbMultiColumnBaseAbsListView.this.getChildAt(0);
                    if (firstView == null) {
                        return;
                    }
                    int firstViewTop = firstView.getTop();
                    int extraScroll = firstPos > 0 ? this.mExtraScroll : AbMultiColumnBaseAbsListView.this.mListPadding.top;
                    AbMultiColumnBaseAbsListView.this.smoothScrollBy(firstViewTop - extraScroll, this.mScrollDuration);
                    this.mLastSeenPos = firstPos;
                    if (firstPos <= this.mTargetPos) break;
                    AbMultiColumnBaseAbsListView.this.post(this);
                    break;
                }
                case 4: {
                    int lastViewIndex = AbMultiColumnBaseAbsListView.this.getChildCount() - 2;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    int lastPos = firstPos + lastViewIndex;
                    if (lastPos == this.mLastSeenPos) {
                        AbMultiColumnBaseAbsListView.this.post(this);
                        return;
                    }
                    View lastView = AbMultiColumnBaseAbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    this.mLastSeenPos = lastPos;
                    if (lastPos > this.mBoundPos) {
                        AbMultiColumnBaseAbsListView.this.smoothScrollBy(-(lastViewPixelsShowing - this.mExtraScroll), this.mScrollDuration);
                        AbMultiColumnBaseAbsListView.this.post(this);
                        break;
                    }
                    int bottom = listHeight - this.mExtraScroll;
                    int lastViewBottom = lastViewTop + lastViewHeight;
                    if (bottom <= lastViewBottom) break;
                    AbMultiColumnBaseAbsListView.this.smoothScrollBy(-(bottom - lastViewBottom), this.mScrollDuration);
                    break;
                }
            }
        }
    }

    class RecycleBin {
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews = new View[0];
        private ArrayList<View>[] mScrapViews;
        private int mViewTypeCount;
        private ArrayList<View> mCurrentScrap;

        RecycleBin() {
        }

        public void setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] scrapViews = new ArrayList[viewTypeCount];
            int i = 0;
            while (i < viewTypeCount) {
                scrapViews[i] = new ArrayList();
                ++i;
            }
            this.mViewTypeCount = viewTypeCount;
            this.mCurrentScrap = scrapViews[0];
            this.mScrapViews = scrapViews;
        }

        public void markChildrenDirty() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                int i = 0;
                while (i < scrapCount) {
                    scrap.get(i).forceLayout();
                    ++i;
                }
            } else {
                int typeCount = this.mViewTypeCount;
                int i = 0;
                while (i < typeCount) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    int j = 0;
                    while (j < scrapCount) {
                        scrap.get(j).forceLayout();
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public boolean shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        void clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                int i = 0;
                while (i < scrapCount) {
                    AbMultiColumnBaseAbsListView.this.removeDetachedView(scrap.remove(scrapCount - 1 - i), false);
                    ++i;
                }
            } else {
                int typeCount = this.mViewTypeCount;
                int i = 0;
                while (i < typeCount) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    int j = 0;
                    while (j < scrapCount) {
                        AbMultiColumnBaseAbsListView.this.removeDetachedView(scrap.remove(scrapCount - 1 - j), false);
                        ++j;
                    }
                    ++i;
                }
            }
        }

        void fillActiveViews(int childCount, int firstActivePosition) {
            if (this.mActiveViews.length < childCount) {
                this.mActiveViews = new View[childCount];
            }
            this.mFirstActivePosition = firstActivePosition;
            View[] activeViews = this.mActiveViews;
            int i = 0;
            while (i < childCount) {
                View child = AbMultiColumnBaseAbsListView.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp != null && lp.viewType != -2) {
                    activeViews[i] = child;
                }
                ++i;
            }
        }

        View getActiveView(int position) {
            int index = position - this.mFirstActivePosition;
            View[] activeViews = this.mActiveViews;
            if (index >= 0 && index < activeViews.length) {
                View match = activeViews[index];
                activeViews[index] = null;
                return match;
            }
            return null;
        }

        View getScrapView(int position) {
            ArrayList<View> scrapViews;
            int size;
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrapViews2 = this.mCurrentScrap;
                int size2 = scrapViews2.size();
                if (size2 > 0) {
                    return scrapViews2.remove(size2 - 1);
                }
                return null;
            }
            int whichScrap = AbMultiColumnBaseAbsListView.this.mAdapter.getItemViewType(position);
            if (whichScrap >= 0 && whichScrap < this.mScrapViews.length && (size = (scrapViews = this.mScrapViews[whichScrap]).size()) > 0) {
                return scrapViews.remove(size - 1);
            }
            return null;
        }

        void addScrapView(View scrap) {
            LayoutParams lp = (LayoutParams)scrap.getLayoutParams();
            if (lp == null) {
                return;
            }
            int viewType = lp.viewType;
            if (!this.shouldRecycleViewType(viewType)) {
                if (viewType != -2) {
                    AbMultiColumnBaseAbsListView.this.removeDetachedView(scrap, false);
                }
                return;
            }
            if (this.mViewTypeCount == 1) {
                AbMultiColumnBaseAbsListView.this.dispatchFinishTemporaryDetach(scrap);
                this.mCurrentScrap.add(scrap);
            } else {
                AbMultiColumnBaseAbsListView.this.dispatchFinishTemporaryDetach(scrap);
                this.mScrapViews[viewType].add(scrap);
            }
            if (this.mRecyclerListener != null) {
                this.mRecyclerListener.onMovedToScrapHeap(scrap);
            }
        }

        void scrapActiveViews() {
            View[] activeViews = this.mActiveViews;
            boolean hasListener = this.mRecyclerListener != null;
            boolean multipleScraps = this.mViewTypeCount > 1;
            ArrayList<View> scrapViews = this.mCurrentScrap;
            int count = activeViews.length;
            int i = count - 1;
            while (i >= 0) {
                View victim = activeViews[i];
                if (victim != null) {
                    int whichScrap = ((LayoutParams)victim.getLayoutParams()).viewType;
                    activeViews[i] = null;
                    if (!this.shouldRecycleViewType(whichScrap)) {
                        if (whichScrap != -2) {
                            AbMultiColumnBaseAbsListView.this.removeDetachedView(victim, false);
                        }
                    } else {
                        if (multipleScraps) {
                            scrapViews = this.mScrapViews[whichScrap];
                        }
                        AbMultiColumnBaseAbsListView.this.dispatchFinishTemporaryDetach(victim);
                        scrapViews.add(victim);
                        if (hasListener) {
                            this.mRecyclerListener.onMovedToScrapHeap(victim);
                        }
                    }
                }
                --i;
            }
            this.pruneScrapViews();
        }

        private void pruneScrapViews() {
            int maxViews = this.mActiveViews.length;
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            int i = 0;
            while (i < viewTypeCount) {
                ArrayList<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                int extras = size - maxViews;
                --size;
                int j = 0;
                while (j < extras) {
                    AbMultiColumnBaseAbsListView.this.removeDetachedView(scrapPile.remove(size--), false);
                    ++j;
                }
                ++i;
            }
        }

        void reclaimScrapViews(List<View> views) {
            if (this.mViewTypeCount == 1) {
                views.addAll(this.mCurrentScrap);
            } else {
                int viewTypeCount = this.mViewTypeCount;
                ArrayList<View>[] scrapViews = this.mScrapViews;
                int i = 0;
                while (i < viewTypeCount) {
                    ArrayList<View> scrapPile = scrapViews[i];
                    views.addAll(scrapPile);
                    ++i;
                }
            }
        }

        void setCacheColorHint(int color) {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                int i = 0;
                while (i < scrapCount) {
                    scrap.get(i).setDrawingCacheBackgroundColor(color);
                    ++i;
                }
            } else {
                int typeCount = this.mViewTypeCount;
                int i = 0;
                while (i < typeCount) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    int j = 0;
                    while (j < scrapCount) {
                        scrap.get(i).setDrawingCacheBackgroundColor(color);
                        ++j;
                    }
                    ++i;
                }
            }
            View[] activeViews = this.mActiveViews;
            int count = activeViews.length;
            int i = 0;
            while (i < count) {
                View victim = activeViews[i];
                if (victim != null) {
                    victim.setDrawingCacheBackgroundColor(color);
                }
                ++i;
            }
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    private class WindowRunnnable {
        private int mOriginalAttachCount;

        private WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = AbMultiColumnBaseAbsListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return AbMultiColumnBaseAbsListView.this.hasWindowFocus() && AbMultiColumnBaseAbsListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }
}

