/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import com.ab.view.pullview.AbMultiColumnAbsListView;

public class AbMultiColumnBaseListView
extends AbMultiColumnAbsListView {
    private static final String TAG = "MultiColumnListView";
    private static final int DEFAULT_COLUMN_NUMBER = 2;
    private int mColumnNumber = 2;
    private Column[] mColumns = null;
    private Column mFixedColumn = null;
    private SparseIntArray mItems = new SparseIntArray();
    private int mColumnPaddingLeft = 0;
    private int mColumnPaddingRight = 0;
    private Rect mFrameRect = new Rect();
    private int columnWidth;

    public AbMultiColumnBaseListView(Context context) {
        super(context);
        this.init(null);
    }

    public AbMultiColumnBaseListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.getWindowVisibleDisplayFrame(this.mFrameRect);
        if (attrs == null) {
            this.mColumnNumber = 2;
        } else {
            int landColNumber = 3;
            int defColNumber = 3;
            this.mColumnNumber = this.mFrameRect.width() > this.mFrameRect.height() && landColNumber != -1 ? landColNumber : (defColNumber != -1 ? defColNumber : 2);
            this.mColumnPaddingLeft = 0;
            this.mColumnPaddingRight = 0;
        }
        this.mColumns = new Column[this.getColumnNumber()];
        int i = 0;
        while (i < this.getColumnNumber()) {
            this.mColumns[i] = new Column(i);
            ++i;
        }
        this.mFixedColumn = new FixedColumn();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.columnWidth = (this.getMeasuredWidth() - this.mListPadding.left - this.mListPadding.right - this.mColumnPaddingLeft - this.mColumnPaddingRight) / this.getColumnNumber();
        int index = 0;
        while (index < this.getColumnNumber()) {
            this.mColumns[index].mColumnWidth = this.columnWidth;
            this.mColumns[index].mColumnLeft = this.mListPadding.left + this.mColumnPaddingLeft + this.columnWidth * index;
            ++index;
        }
        this.mFixedColumn.mColumnLeft = this.mListPadding.left;
        this.mFixedColumn.mColumnWidth = this.getMeasuredWidth();
    }

    @Override
    protected void onMeasureChild(View child, int position, int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isFixedView(child)) {
            child.measure(widthMeasureSpec, heightMeasureSpec);
        } else {
            child.measure(0x40000000 | this.getColumnWidth(position), heightMeasureSpec);
        }
    }

    @Override
    protected int modifyFlingInitialVelocity(int initialVelocity) {
        return initialVelocity / this.getColumnNumber();
    }

    @Override
    protected void onItemAddedToList(int position, boolean flow) {
        super.onItemAddedToList(position, flow);
        if (!this.isHeaderOrFooterPosition(position)) {
            Column col = this.getNextColumn(flow, position);
            this.mItems.append(position, col.getIndex());
        }
    }

    @Override
    protected void onLayoutSync(int syncPos) {
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            c.save();
            ++n2;
        }
    }

    @Override
    protected void onLayoutSyncFinished(int syncPos) {
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            c.clear();
            ++n2;
        }
    }

    @Override
    protected void onAdjustChildViews(boolean down) {
        int firstItem = this.getFirstVisiblePosition();
        if (!down && firstItem == 0) {
            int firstColumnTop = this.mColumns[0].getTop();
            Column[] columnArray = this.mColumns;
            int n = this.mColumns.length;
            int n2 = 0;
            while (n2 < n) {
                Column c = columnArray[n2];
                int top = c.getTop();
                c.offsetTopAndBottom(firstColumnTop - top);
                ++n2;
            }
        }
        super.onAdjustChildViews(down);
    }

    @Override
    protected int getFillChildBottom() {
        int result = Integer.MAX_VALUE;
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            int bottom = c.getBottom();
            result = result > bottom ? bottom : result;
            ++n2;
        }
        return result;
    }

    @Override
    protected int getFillChildTop() {
        int result = Integer.MIN_VALUE;
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            int top = c.getTop();
            result = result < top ? top : result;
            ++n2;
        }
        return result;
    }

    @Override
    protected int getScrollChildBottom() {
        int result = Integer.MIN_VALUE;
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            int bottom = c.getBottom();
            result = result < bottom ? bottom : result;
            ++n2;
        }
        return result;
    }

    @Override
    protected int getScrollChildTop() {
        int result = Integer.MAX_VALUE;
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            int top = c.getTop();
            result = result > top ? top : result;
            ++n2;
        }
        return result;
    }

    @Override
    protected int getItemLeft(int pos) {
        if (this.isHeaderOrFooterPosition(pos)) {
            return this.mFixedColumn.getColumnLeft();
        }
        return this.getColumnLeft(pos);
    }

    @Override
    protected int getItemTop(int pos) {
        if (this.isHeaderOrFooterPosition(pos)) {
            return this.mFixedColumn.getBottom();
        }
        int colIndex = this.mItems.get(pos, -1);
        if (colIndex == -1) {
            return this.getFillChildBottom();
        }
        return this.mColumns[colIndex].getBottom();
    }

    @Override
    protected int getItemBottom(int pos) {
        if (this.isHeaderOrFooterPosition(pos)) {
            return this.mFixedColumn.getTop();
        }
        int colIndex = this.mItems.get(pos, -1);
        if (colIndex == -1) {
            return this.getFillChildTop();
        }
        return this.mColumns[colIndex].getTop();
    }

    private Column getNextColumn(boolean flow, int position) {
        int colIndex = this.mItems.get(position, -1);
        if (colIndex != -1) {
            return this.mColumns[colIndex];
        }
        int lastVisiblePos = Math.max(0, position = Math.max(0, position - this.getHeaderViewsCount()));
        if (lastVisiblePos < this.getColumnNumber()) {
            return this.mColumns[lastVisiblePos];
        }
        if (flow) {
            return this.gettBottomColumn();
        }
        return this.getTopColumn();
    }

    private boolean isHeaderOrFooterPosition(int pos) {
        int type = this.mAdapter.getItemViewType(pos);
        return type == -2;
    }

    private Column getTopColumn() {
        Column result = this.mColumns[0];
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            result = result.getTop() > c.getTop() ? c : result;
            ++n2;
        }
        return result;
    }

    private Column gettBottomColumn() {
        Column result = this.mColumns[0];
        Column[] columnArray = this.mColumns;
        int n = this.mColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            result = result.getBottom() > c.getBottom() ? c : result;
            ++n2;
        }
        return result;
    }

    private int getColumnLeft(int pos) {
        int colIndex = this.mItems.get(pos, -1);
        if (colIndex == -1) {
            return 0;
        }
        return this.mColumns[colIndex].getColumnLeft();
    }

    private int getColumnWidth(int pos) {
        int colIndex = this.mItems.get(pos, -1);
        if (colIndex == -1) {
            return 0;
        }
        return this.mColumns[colIndex].getColumnWidth();
    }

    public int getColumnNumber() {
        return this.mColumnNumber;
    }

    private class Column {
        private int mIndex;
        private int mColumnWidth;
        private int mColumnLeft;
        private int mSynchedTop = 0;
        private int mSynchedBottom = 0;

        public Column(int index) {
            this.mIndex = index;
        }

        public int getColumnLeft() {
            return this.mColumnLeft;
        }

        public int getColumnWidth() {
            return this.mColumnWidth;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getBottom() {
            int bottom = Integer.MIN_VALUE;
            int childCount = AbMultiColumnBaseListView.this.getChildCount();
            int index = 0;
            while (index < childCount) {
                View v = AbMultiColumnBaseListView.this.getChildAt(index);
                if (v.getLeft() == this.mColumnLeft || AbMultiColumnBaseListView.this.isFixedView(v)) {
                    bottom = bottom < v.getBottom() ? v.getBottom() : bottom;
                }
                ++index;
            }
            if (bottom == Integer.MIN_VALUE) {
                return this.mSynchedBottom;
            }
            return bottom;
        }

        public void offsetTopAndBottom(int offset) {
            if (offset == 0) {
                return;
            }
            int childCount = AbMultiColumnBaseListView.this.getChildCount();
            int index = 0;
            while (index < childCount) {
                View v = AbMultiColumnBaseListView.this.getChildAt(index);
                if (v.getLeft() == this.mColumnLeft || AbMultiColumnBaseListView.this.isFixedView(v)) {
                    v.offsetTopAndBottom(offset);
                }
                ++index;
            }
        }

        public int getTop() {
            int top = Integer.MAX_VALUE;
            int childCount = AbMultiColumnBaseListView.this.getChildCount();
            int index = 0;
            while (index < childCount) {
                View v = AbMultiColumnBaseListView.this.getChildAt(index);
                if (v.getLeft() == this.mColumnLeft || AbMultiColumnBaseListView.this.isFixedView(v)) {
                    top = top > v.getTop() ? v.getTop() : top;
                }
                ++index;
            }
            if (top == Integer.MAX_VALUE) {
                return this.mSynchedTop;
            }
            return top;
        }

        public void save() {
            this.mSynchedTop = 0;
            this.mSynchedBottom = this.getTop();
        }

        public void clear() {
            this.mSynchedTop = 0;
            this.mSynchedBottom = 0;
        }
    }

    private class FixedColumn
    extends Column {
        public FixedColumn() {
            super(Integer.MAX_VALUE);
        }

        @Override
        public int getBottom() {
            return AbMultiColumnBaseListView.this.getScrollChildBottom();
        }

        @Override
        public int getTop() {
            return AbMultiColumnBaseListView.this.getScrollChildTop();
        }
    }
}

