/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;
import com.ab.view.pullview.AbMultiColumnAbsListView;
import java.util.ArrayList;

public class AbMultiColumnHeaderViewListAdapter
implements WrapperListAdapter,
Filterable {
    private final ListAdapter mAdapter;
    ArrayList<AbMultiColumnAbsListView.FixedViewInfo> mHeaderViewInfos;
    ArrayList<AbMultiColumnAbsListView.FixedViewInfo> mFooterViewInfos;
    static final ArrayList<AbMultiColumnAbsListView.FixedViewInfo> EMPTY_INFO_LIST = new ArrayList();
    boolean mAreAllFixedViewsSelectable;
    private final boolean mIsFilterable;

    public AbMultiColumnHeaderViewListAdapter(ArrayList<AbMultiColumnAbsListView.FixedViewInfo> headerViewInfos, ArrayList<AbMultiColumnAbsListView.FixedViewInfo> footerViewInfos, ListAdapter adapter) {
        this.mAdapter = adapter;
        this.mIsFilterable = adapter instanceof Filterable;
        this.mHeaderViewInfos = headerViewInfos == null ? EMPTY_INFO_LIST : headerViewInfos;
        this.mFooterViewInfos = footerViewInfos == null ? EMPTY_INFO_LIST : footerViewInfos;
        this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
    }

    public int getHeadersCount() {
        return this.mHeaderViewInfos.size();
    }

    public int getFootersCount() {
        return this.mFooterViewInfos.size();
    }

    public boolean isEmpty() {
        return this.mAdapter == null || this.mAdapter.isEmpty();
    }

    private boolean areAllListInfosSelectable(ArrayList<AbMultiColumnAbsListView.FixedViewInfo> infos) {
        if (infos != null) {
            for (AbMultiColumnAbsListView.FixedViewInfo info : infos) {
                if (info.isSelectable) continue;
                return false;
            }
        }
        return true;
    }

    public boolean removeHeader(View v) {
        int i = 0;
        while (i < this.mHeaderViewInfos.size()) {
            AbMultiColumnAbsListView.FixedViewInfo info = this.mHeaderViewInfos.get(i);
            if (info.view == v) {
                this.mHeaderViewInfos.remove(i);
                this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeFooter(View v) {
        int i = 0;
        while (i < this.mFooterViewInfos.size()) {
            AbMultiColumnAbsListView.FixedViewInfo info = this.mFooterViewInfos.get(i);
            if (info.view == v) {
                this.mFooterViewInfos.remove(i);
                this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getCount() {
        if (this.mAdapter != null) {
            return this.getFootersCount() + this.getHeadersCount() + this.mAdapter.getCount();
        }
        return this.getFootersCount() + this.getHeadersCount();
    }

    public boolean areAllItemsEnabled() {
        if (this.mAdapter != null) {
            return this.mAreAllFixedViewsSelectable && this.mAdapter.areAllItemsEnabled();
        }
        return true;
    }

    public boolean isEnabled(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).isSelectable;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.isEnabled(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).isSelectable;
    }

    public Object getItem(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).data;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItem(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).data;
    }

    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.mAdapter != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItemId(adjPosition);
        }
        return -1L;
    }

    public boolean hasStableIds() {
        if (this.mAdapter != null) {
            return this.mAdapter.hasStableIds();
        }
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).view;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getView(adjPosition, convertView, parent);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).view;
    }

    public int getItemViewType(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.mAdapter != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItemViewType(adjPosition);
        }
        return -2;
    }

    public int getViewTypeCount() {
        if (this.mAdapter != null) {
            return this.mAdapter.getViewTypeCount();
        }
        return 1;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        if (this.mAdapter != null) {
            this.mAdapter.registerDataSetObserver(observer);
        }
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(observer);
        }
    }

    public Filter getFilter() {
        if (this.mIsFilterable) {
            return ((Filterable)this.mAdapter).getFilter();
        }
        return null;
    }

    public ListAdapter getWrappedAdapter() {
        return this.mAdapter;
    }
}

