/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.Scroller;
import com.ab.view.listener.AbOnListViewListener;
import com.ab.view.pullview.AbListViewFooter;
import com.ab.view.pullview.AbListViewHeader;
import com.ab.view.pullview.AbMultiColumnBaseAbsListView;
import com.ab.view.pullview.AbMultiColumnBaseListView;

public class AbMultiColumnListView
extends AbMultiColumnBaseListView
implements AbMultiColumnBaseAbsListView.OnScrollListener {
    private float mLastY = -1.0f;
    private Scroller mScroller;
    private AbMultiColumnBaseAbsListView.OnScrollListener mScrollListener;
    private AbOnListViewListener mListViewListener;
    private AbListViewHeader mHeaderView;
    private int mHeaderViewHeight;
    private int mFooterViewHeight;
    private boolean mEnablePullRefresh = true;
    private boolean mPullRefreshing = false;
    private AbListViewFooter mFooterView;
    private boolean mEnablePullLoad;
    private boolean mPullLoading;
    private boolean mIsFooterReady = false;
    private int mTotalItemCount;
    private int mScrollBack;
    private static final int SCROLLBACK_HEADER = 0;
    private static final int SCROLLBACK_FOOTER = 1;
    private static final int SCROLL_DURATION = 200;
    private static final float OFFSET_RADIO = 1.8f;
    private int count = 0;

    public AbMultiColumnListView(Context context) {
        super(context);
        this.initView(context);
    }

    public AbMultiColumnListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        super.setOnScrollListener(this);
        this.mHeaderView = new AbListViewHeader(context);
        this.mHeaderViewHeight = this.mHeaderView.getHeaderHeight();
        this.mHeaderView.setGravity(80);
        this.addHeaderView((View)this.mHeaderView);
        this.mFooterView = new AbListViewFooter(context);
        this.mFooterViewHeight = this.mFooterView.getFooterHeight();
        this.mFooterView.hide();
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (!this.mIsFooterReady) {
            this.mIsFooterReady = true;
            this.mFooterView.setGravity(48);
            this.addFooterView((View)this.mFooterView);
        }
        super.setAdapter(adapter);
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        if (!this.mEnablePullRefresh) {
            this.mHeaderView.setVisibility(4);
        } else {
            this.mHeaderView.setVisibility(0);
        }
    }

    public void setPullLoadEnable(boolean enable) {
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.mFooterView.hide();
            this.mFooterView.setOnClickListener(null);
        } else {
            this.mPullLoading = false;
            this.mFooterView.show();
            this.mFooterView.setState(1);
            this.mFooterView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbMultiColumnListView.this.startLoadMore();
                }
            });
        }
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
        if (this.mAdapter.getCount() > 0) {
            this.mFooterView.setState(1);
        } else {
            this.mFooterView.setState(4);
        }
    }

    private void startLoadMore() {
        this.mFooterView.show();
        this.mPullLoading = true;
        this.mFooterView.setState(2);
        if (this.mListViewListener != null) {
            this.mListViewListener.onLoadMore();
        }
    }

    public void stopLoadMore() {
        this.mFooterView.hide();
        this.mPullLoading = false;
        int countNew = this.mAdapter.getCount();
        if (countNew > this.count) {
            this.mFooterView.setState(1);
        } else {
            this.mFooterView.setState(3);
        }
    }

    private void updateHeaderHeight(float delta) {
        int newHeight = (int)delta + this.mHeaderView.getVisiableHeight();
        this.mHeaderView.setVisiableHeight(newHeight);
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeaderView.getVisiableHeight() >= this.mHeaderViewHeight) {
                this.mHeaderView.setState(1);
            } else {
                this.mHeaderView.setState(0);
            }
        }
        this.setSelection(0);
    }

    private void resetHeaderHeight() {
        int height = this.mHeaderView.getVisiableHeight();
        if (height < this.mHeaderViewHeight || !this.mPullRefreshing) {
            this.mScrollBack = 0;
            this.mScroller.startScroll(0, height, 0, -1 * height, 200);
        } else if (height > this.mHeaderViewHeight || !this.mPullRefreshing) {
            this.mScrollBack = 0;
            this.mScroller.startScroll(0, height, 0, -(height - this.mHeaderViewHeight), 200);
        }
        this.invalidate();
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.getFirstVisiblePosition() == 0 && (this.mHeaderView.getVisiableHeight() > 0 || deltaY > 0.0f)) {
                    this.updateHeaderHeight(deltaY / 1.8f);
                    break;
                }
                if (!this.mEnablePullLoad || this.mPullLoading || this.getLastVisiblePosition() != this.mTotalItemCount - 1 || !(deltaY < 0.0f)) break;
                this.startLoadMore();
                break;
            }
            case 1: {
                this.mLastY = -1.0f;
                if (this.getFirstVisiblePosition() != 0) break;
                if (this.mEnablePullRefresh && this.mHeaderView.getVisiableHeight() >= this.mHeaderViewHeight) {
                    this.mPullRefreshing = true;
                    this.mHeaderView.setState(2);
                    if (this.mListViewListener != null) {
                        this.mListViewListener.onRefresh();
                    }
                }
                this.resetHeaderHeight();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeaderView.setVisiableHeight(this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
        super.computeScroll();
    }

    public void setAbOnListViewListener(AbOnListViewListener abOnListViewListener) {
        this.mListViewListener = abOnListViewListener;
    }

    @Override
    public void onScrollStateChanged(AbMultiColumnBaseAbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    @Override
    public void onScroll(AbMultiColumnBaseAbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.mTotalItemCount = totalItemCount;
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public AbListViewHeader getHeaderView() {
        return this.mHeaderView;
    }

    public AbListViewFooter getFooterView() {
        return this.mFooterView;
    }

    public ProgressBar getHeaderProgressBar() {
        return this.mHeaderView.getHeaderProgressBar();
    }

    public ProgressBar getFooterProgressBar() {
        return this.mFooterView.getFooterProgressBar();
    }
}

