/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.Scroller;
import com.ab.view.listener.AbOnListViewListener;
import com.ab.view.pullview.AbBaseGridView;
import com.ab.view.pullview.AbListViewFooter;
import com.ab.view.pullview.AbListViewHeader;

public class AbPullGridView
extends AbBaseGridView
implements AbsListView.OnScrollListener,
View.OnTouchListener {
    private float mLastY = -1.0f;
    private Scroller mScroller;
    private AbListViewHeader mHeaderView;
    private AbListViewFooter mFooterView;
    private int mHeaderViewHeight;
    private boolean mEnablePullRefresh = true;
    private boolean mEnablePullLoad = true;
    private boolean mPullRefreshing = false;
    private boolean mPullLoading;
    private AbOnListViewListener mListViewListener = null;
    private int mScrollBack;
    private static final int SCROLLBACK_HEADER = 0;
    private static final int SCROLL_DURATION = 200;
    private static final float OFFSET_RADIO = 1.8f;
    private GridView mGridView = null;
    private BaseAdapter mAdapter = null;
    private boolean childScrollState = false;
    private int count = 0;
    private int mTotalItemCount;

    public AbPullGridView(Context context) {
        super(context);
        this.initView(context);
    }

    public AbPullGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        this.mHeaderView = new AbListViewHeader(context);
        this.mHeaderViewHeight = this.mHeaderView.getHeaderHeight();
        this.mHeaderView.setGravity(80);
        this.addHeaderView((View)this.mHeaderView);
        this.mGridView = this.getGridView();
        this.mGridView.setCacheColorHint(context.getResources().getColor(17170445));
        this.mGridView.setColumnWidth(150);
        this.mGridView.setGravity(17);
        this.mGridView.setHorizontalSpacing(5);
        this.mGridView.setNumColumns(-1);
        this.mGridView.setPadding(5, 5, 5, 5);
        this.mGridView.setStretchMode(2);
        this.mGridView.setVerticalSpacing(5);
        this.mGridView.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.mGridView.setOnTouchListener((View.OnTouchListener)this);
        this.mFooterView = new AbListViewFooter(context);
        this.addFooterView((View)this.mFooterView);
        this.setPullRefreshEnable(true);
        this.setPullLoadEnable(true);
        this.mFooterView.hide();
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        if (!this.mEnablePullRefresh) {
            this.mHeaderView.setVisibility(4);
        } else {
            this.mHeaderView.setVisibility(0);
        }
    }

    public void setPullLoadEnable(boolean enable) {
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.mFooterView.hide();
            this.mFooterView.setOnClickListener(null);
        } else {
            this.mPullLoading = false;
            this.mFooterView.setState(1);
            this.mFooterView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbPullGridView.this.startLoadMore();
                }
            });
        }
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
    }

    private void startLoadMore() {
        this.mFooterView.show();
        this.mPullLoading = true;
        this.mFooterView.setState(2);
        if (this.mListViewListener != null) {
            this.mListViewListener.onLoadMore();
        }
    }

    public void stopLoadMore() {
        this.mFooterView.hide();
        this.mPullLoading = false;
        int countNew = this.mAdapter.getCount();
        if (countNew > this.count) {
            this.mFooterView.setState(1);
        } else {
            this.mFooterView.setState(3);
        }
    }

    private void updateHeaderHeight(float delta) {
        int newHeight = (int)delta + this.mHeaderView.getVisiableHeight();
        this.mHeaderView.setVisiableHeight(newHeight);
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeaderView.getVisiableHeight() >= this.mHeaderViewHeight) {
                this.mHeaderView.setState(1);
            } else {
                this.mHeaderView.setState(0);
            }
        }
    }

    private void resetHeaderHeight() {
        int height = this.mHeaderView.getVisiableHeight();
        if (height < this.mHeaderViewHeight || !this.mPullRefreshing) {
            this.mScrollBack = 0;
            this.mScroller.startScroll(0, height, 0, -1 * height, 200);
        } else if (height > this.mHeaderViewHeight || !this.mPullRefreshing) {
            this.mScrollBack = 0;
            this.mScroller.startScroll(0, height, 0, -(height - this.mHeaderViewHeight), 200);
        }
        this.childScrollState = true;
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.childScrollState) {
            return false;
        }
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.mEnablePullRefresh && (this.mHeaderView.getVisiableHeight() > 0 || deltaY > 0.0f)) {
                    this.updateHeaderHeight(deltaY / 1.8f);
                    break;
                }
                if (!this.mEnablePullLoad || this.mPullLoading || this.mGridView.getLastVisiblePosition() != this.mTotalItemCount - 1 || !(deltaY < 0.0f)) break;
                this.startLoadMore();
                break;
            }
            case 1: {
                this.mLastY = -1.0f;
                if (this.mEnablePullRefresh && this.mHeaderView.getVisiableHeight() >= this.mHeaderViewHeight) {
                    this.mPullRefreshing = true;
                    this.mHeaderView.setState(2);
                    if (this.mListViewListener != null) {
                        this.mListViewListener.onRefresh();
                    }
                }
                if (!this.mEnablePullRefresh) break;
                this.resetHeaderHeight();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeaderView.setVisiableHeight(this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
        super.computeScroll();
    }

    public void setAbOnListViewListener(AbOnListViewListener listViewListener) {
        this.mListViewListener = listViewListener;
    }

    public void setAdapter(BaseAdapter adapter) {
        this.mAdapter = adapter;
        this.mGridView.setAdapter((ListAdapter)this.mAdapter);
    }

    public boolean onTouch(View arg0, MotionEvent ev) {
        return this.onTouchEvent(ev);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.mTotalItemCount = totalItemCount;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        switch (scrollState) {
            case 0: {
                if (view.getFirstVisiblePosition() == 0) {
                    this.childScrollState = false;
                    break;
                }
                if (view.getLastVisiblePosition() == view.getCount() - 1) {
                    this.childScrollState = false;
                    break;
                }
                if (this.mPullRefreshing) break;
                this.childScrollState = true;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public AbListViewHeader getHeaderView() {
        return this.mHeaderView;
    }

    public AbListViewFooter getFooterView() {
        return this.mFooterView;
    }

    public ProgressBar getHeaderProgressBar() {
        return this.mHeaderView.getHeaderProgressBar();
    }

    public ProgressBar getFooterProgressBar() {
        return this.mFooterView.getFooterProgressBar();
    }
}

