/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.pullview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.Scroller;
import com.ab.view.listener.AbOnRefreshListener;
import com.ab.view.pullview.AbListViewHeader;

public class AbPullView
extends ScrollView {
    private float mLastY = -1.0f;
    private Scroller mScroller;
    private LinearLayout mScrollLayout;
    private AbListViewHeader mHeaderView;
    private int mHeaderViewHeight;
    private boolean mEnablePullRefresh = true;
    private boolean mPullRefreshing = false;
    private AbOnRefreshListener mAbOnRefreshListener = null;
    private int mScrollBack;
    private static final int SCROLLBACK_HEADER = 0;
    private static final int SCROLL_DURATION = 400;
    private static final float OFFSET_RADIO = 1.8f;

    public AbPullView(Context context) {
        super(context);
        this.initView(context);
    }

    public AbPullView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        LinearLayout.LayoutParams layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.mScrollLayout = new LinearLayout(context);
        this.mScrollLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParamsFW);
        this.mScrollLayout.setOrientation(1);
        this.mHeaderView = new AbListViewHeader(context);
        this.mHeaderViewHeight = this.mHeaderView.getHeaderHeight();
        this.mHeaderView.setGravity(80);
        this.mScrollLayout.addView((View)this.mHeaderView, (ViewGroup.LayoutParams)layoutParamsFW);
        this.addView((View)this.mScrollLayout);
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        if (!this.mEnablePullRefresh) {
            this.mHeaderView.setVisibility(4);
        } else {
            this.mHeaderView.setVisibility(0);
        }
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
    }

    private void updateHeaderHeight(float delta) {
        int newHeight = (int)delta + this.mHeaderView.getVisiableHeight();
        this.mHeaderView.setVisiableHeight(newHeight);
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeaderView.getVisiableHeight() >= this.mHeaderViewHeight) {
                this.mHeaderView.setState(1);
            } else {
                this.mHeaderView.setState(0);
            }
        }
    }

    private void resetHeaderHeight() {
        int height = this.mHeaderView.getVisiableHeight();
        if (height < this.mHeaderViewHeight || !this.mPullRefreshing) {
            this.mScrollBack = 0;
            this.mScroller.startScroll(0, height, 0, -1 * height, 400);
        } else if (height > this.mHeaderViewHeight || !this.mPullRefreshing) {
            this.mScrollBack = 0;
            this.mScroller.startScroll(0, height, 0, -(height - this.mHeaderViewHeight), 400);
        }
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.mHeaderView.getVisiableHeight() <= 0 && !(deltaY > 0.0f)) break;
                this.updateHeaderHeight(deltaY / 1.8f);
                break;
            }
            case 1: {
                this.mLastY = -1.0f;
                if (this.mEnablePullRefresh && this.mHeaderView.getVisiableHeight() >= this.mHeaderViewHeight) {
                    this.mPullRefreshing = true;
                    this.mHeaderView.setState(2);
                    if (this.mAbOnRefreshListener != null) {
                        this.mAbOnRefreshListener.onRefresh();
                    }
                }
                if (!this.mEnablePullRefresh) break;
                this.resetHeaderHeight();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeaderView.setVisiableHeight(this.mScroller.getCurrY());
            }
            this.postInvalidate();
        }
        super.computeScroll();
    }

    public void setAbOnRefreshListener(AbOnRefreshListener abOnRefreshListener) {
        this.mAbOnRefreshListener = abOnRefreshListener;
    }

    public void addChildView(View child, int index) {
        this.mScrollLayout.addView(child, index);
    }

    public void addChildView(View child) {
        this.mScrollLayout.addView(child);
    }

    public AbListViewHeader getHeaderView() {
        return this.mHeaderView;
    }

    public ProgressBar getHeaderProgressBar() {
        return this.mHeaderView.getHeaderProgressBar();
    }
}

