/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sample;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class AbScaleImageView
extends ImageView {
    private Bitmap currentBitmap;
    private int imageWidth;
    private int imageHeight;

    public AbScaleImageView(Context context) {
        super(context);
        this.init();
    }

    public AbScaleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public AbScaleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
    }

    public void recycle() {
        this.setImageBitmap(null);
        if (this.currentBitmap == null || this.currentBitmap.isRecycled()) {
            return;
        }
        this.currentBitmap.recycle();
        this.currentBitmap = null;
    }

    public void setImageBitmap(Bitmap bm) {
        this.currentBitmap = bm;
        super.setImageBitmap(this.currentBitmap);
    }

    public void setImageDrawable(Drawable d) {
        super.setImageDrawable(d);
    }

    public void setImageResource(int id) {
        super.setImageResource(id);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.imageWidth == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.setMeasuredDimension(this.imageWidth, this.imageHeight);
    }

    public void setImageWidth(int w) {
        this.imageWidth = w;
    }

    public void setImageHeight(int h) {
        this.imageHeight = h;
    }
}

