/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.ab.global.AbAppData;

public class AbSlidingButton
extends CheckBox {
    private String TAG = AbSlidingButton.class.getSimpleName();
    private boolean D = AbAppData.DEBUG;
    private Context context;
    private Bitmap btnFrame;
    private Bitmap btnMask;
    private Bitmap btnBottom;
    private Bitmap mBtnNormal;
    private Bitmap mBtnPressed;
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
    private boolean isChecked;
    private float mMaskHeight;
    private float mMaskWidth;
    private float mBtnOffPos;
    private float mBtnOnPos;
    private float mBtnPos;
    private float mLastBtnPos;
    private float mRealPos;
    private float mBtnWidth;
    private float mExtendOffsetY;
    private int mAlpha;
    private Paint mPaint;
    private PorterDuffXfermode mXfermode;
    private RectF mSaveLayerRectF;
    private Bitmap mCurBtnPic;
    private float mFirstDownX;
    private boolean mMoveEvent;
    private boolean mAnimating;
    private float mAnimationPosition;
    private float mAnimatedVelocity;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AbSlidingButton.this.mRealPos = AbSlidingButton.this.getRealPos(((Float)msg.obj).floatValue());
                    AbSlidingButton.this.mLastBtnPos = ((Float)msg.obj).floatValue();
                    AbSlidingButton.this.invalidate();
                    break;
                }
            }
        }
    };

    public AbSlidingButton(Context context) {
        super(context);
        this.init(context);
    }

    public AbSlidingButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.mAlpha = 255;
        this.isChecked = false;
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        float density = this.getResources().getDisplayMetrics().density;
        this.mAnimatedVelocity = (int)(0.5f + 350.0f * density);
    }

    protected void onDraw(Canvas canvas) {
        canvas.saveLayerAlpha(this.mSaveLayerRectF, this.mAlpha, 31);
        canvas.drawBitmap(this.btnMask, 0.0f, this.mExtendOffsetY, this.mPaint);
        this.mPaint.setXfermode((Xfermode)this.mXfermode);
        canvas.drawBitmap(this.btnBottom, this.mRealPos, this.mExtendOffsetY, this.mPaint);
        this.mPaint.setXfermode(null);
        canvas.drawBitmap(this.btnFrame, 0.0f, this.mExtendOffsetY, this.mPaint);
        canvas.drawBitmap(this.mCurBtnPic, this.mRealPos, 0.4f + this.mExtendOffsetY, this.mPaint);
        canvas.restore();
    }

    protected void onMeasure(int paramInt1, int paramInt2) {
        this.setMeasuredDimension((int)this.mMaskWidth, (int)(this.mMaskHeight + 2.0f * this.mExtendOffsetY));
    }

    public void setImageResource(int btnBottomResource, int btnFrameResource, int btnMaskResource, int btnNormalResource, int btnPressedResource) {
        this.btnBottom = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)btnBottomResource);
        this.btnFrame = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)btnFrameResource);
        this.btnMask = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)btnMaskResource);
        this.mBtnNormal = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)btnNormalResource);
        this.mBtnPressed = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)btnPressedResource);
        this.mMaskWidth = this.btnMask.getWidth();
        this.mMaskHeight = this.btnMask.getHeight();
        float density = this.getResources().getDisplayMetrics().density;
        this.mExtendOffsetY = (int)(0.5f + density * 0.0f);
        this.mSaveLayerRectF = new RectF(-20.0f, this.mExtendOffsetY, 20.0f + this.mMaskWidth, this.mMaskHeight + this.mExtendOffsetY);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
        this.mCurBtnPic = this.mBtnNormal;
        this.mBtnWidth = this.mBtnPressed.getWidth();
        this.mBtnOnPos = this.mBtnWidth / 2.0f;
        this.mBtnOffPos = this.mMaskWidth - this.mBtnWidth / 2.0f;
        this.mBtnPos = this.isChecked ? this.mBtnOnPos : this.mBtnOffPos;
        this.mRealPos = this.getRealPos(this.mBtnPos);
    }

    private float getRealPos(float paramFloat) {
        return paramFloat - this.mBtnWidth / 2.0f;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, false);
    }

    public void setChecked(boolean checked, boolean anim) {
        this.mBtnPos = checked ? this.mBtnOnPos : this.mBtnOffPos;
        if (anim) {
            this.startAnimation();
        } else {
            this.moveViewToTarget();
        }
    }

    public void setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mAnimating) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mMoveEvent = false;
                this.mFirstDownX = event.getX();
                this.mCurBtnPic = this.mBtnPressed;
                this.mBtnPos = this.isChecked ? this.mBtnOnPos : this.mBtnOffPos;
                this.mLastBtnPos = this.mBtnPos;
                if (!this.D) break;
                Log.d((String)this.TAG, (String)("\u539f\u6765\u7684X\u4f4d\u7f6e\uff1a" + this.mBtnPos));
                break;
            }
            case 2: {
                if (this.D) {
                    Log.d((String)this.TAG, (String)"\uff0d\uff0d\uff0d\uff0d\u79fb\u52a8\uff0d\uff0d\uff0d\uff0d");
                }
                float x = event.getX();
                float offsetX = x - this.mFirstDownX;
                if (this.D) {
                    Log.d((String)this.TAG, (String)("X\u9700\u8981\u79fb\u52a8\uff1a" + offsetX));
                }
                if (Math.abs(offsetX) < 5.0f) break;
                this.mMoveEvent = true;
                this.mFirstDownX = event.getX();
                this.mBtnPos += offsetX;
                if (this.D) {
                    Log.d((String)this.TAG, (String)("\u73b0\u5728\u7684X\u4f4d\u7f6e\uff1a" + this.mBtnPos));
                }
                if (this.mBtnPos < this.mBtnOffPos) {
                    this.mBtnPos = this.mBtnOffPos;
                }
                if (this.mBtnPos > this.mBtnOnPos) {
                    this.mBtnPos = this.mBtnOnPos;
                }
                this.moveViewToTarget();
                break;
            }
            default: {
                if (this.mMoveEvent) {
                    if (this.D) {
                        Log.d((String)this.TAG, (String)"\uff0d\uff0d\uff0d\uff0d\u5f39\u8d77\uff0d\uff0d\uff0d\uff0d");
                    }
                    this.mCurBtnPic = this.mBtnNormal;
                    this.mBtnPos = this.mBtnPos < (this.mBtnOnPos - this.mBtnOffPos) / 2.0f + this.mBtnOffPos ? this.mBtnOffPos : this.mBtnOnPos;
                    this.startAnimation();
                    float offsetX = 0.0f;
                    break;
                }
                this.setChecked(!this.isChecked, true);
            }
        }
        return true;
    }

    private void moveView(float pos) {
        this.moveView(pos, false);
    }

    private void moveView(float pos, boolean delay) {
        if (this.handler != null) {
            this.handler.obtainMessage(0, (Object)Float.valueOf(pos)).sendToTarget();
        }
    }

    private void startAnimation() {
        if (this.mLastBtnPos == this.mBtnPos) {
            return;
        }
        this.mAnimating = true;
        if (this.D) {
            Log.d((String)this.TAG, (String)("\u76ee\u6807\u79fb\u52a8X\u5230\uff1a" + this.mBtnPos + ",\u5f53\u524d\u5728:" + this.mLastBtnPos));
        }
        float mVelocity = this.mAnimatedVelocity;
        if (this.mLastBtnPos > this.mBtnPos) {
            mVelocity = -this.mAnimatedVelocity;
        }
        this.mAnimationPosition = this.mLastBtnPos;
        int i = 0;
        while (true) {
            this.mAnimationPosition += 16.0f * mVelocity / 1000.0f;
            if (this.D) {
                Log.d((String)this.TAG, (String)(String.valueOf(i) + "\u6b21\u79fb\u52a8X\u5230\uff1a" + this.mAnimationPosition));
            }
            if (this.mAnimationPosition >= this.mBtnOnPos) {
                this.mAnimationPosition = this.mBtnOnPos;
                this.moveView(this.mAnimationPosition, true);
                if (this.isChecked) break;
                this.isChecked = true;
                if (this.onCheckedChangeListener == null) break;
                this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this, this.isChecked);
                break;
            }
            if (this.mAnimationPosition <= this.mBtnOffPos) {
                this.mAnimationPosition = this.mBtnOffPos;
                this.moveView(this.mAnimationPosition, true);
                if (!this.isChecked) break;
                this.isChecked = false;
                if (this.onCheckedChangeListener == null) break;
                this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this, this.isChecked);
                break;
            }
            this.moveView(this.mAnimationPosition, true);
            ++i;
        }
        this.mAnimating = false;
    }

    private void moveViewToTarget() {
        this.moveView(this.mBtnPos);
        if (this.mBtnPos == this.mBtnOnPos) {
            if (!this.isChecked) {
                this.isChecked = true;
                if (this.onCheckedChangeListener != null) {
                    this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this, this.isChecked);
                }
            }
            return;
        }
        if (this.mBtnPos == this.mBtnOffPos) {
            if (this.isChecked) {
                this.isChecked = false;
                if (this.onCheckedChangeListener != null) {
                    this.onCheckedChangeListener.onCheckedChanged((CompoundButton)this, this.isChecked);
                }
            }
            return;
        }
    }

    public boolean performClick() {
        this.setChecked(!this.isChecked);
        return true;
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }
}

