/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.ab.adapter.AbViewPagerAdapter;
import com.ab.global.AbAppData;
import com.ab.util.AbFileUtil;
import com.ab.view.listener.AbOnChangeListener;
import com.ab.view.listener.AbOnItemClickListener;
import com.ab.view.listener.AbOnScrollListener;
import com.ab.view.listener.AbOnTouchListener;
import com.ab.view.sample.AbInnerViewPager;
import java.util.ArrayList;
import java.util.List;

public class AbSlidingPlayView
extends LinearLayout {
    private static String TAG = "AbSlidingPlayView";
    private static final boolean D = AbAppData.DEBUG;
    private Context context;
    private AbInnerViewPager mViewPager;
    private LinearLayout pageLineLayout;
    public LinearLayout.LayoutParams pageLineLayoutParams = null;
    private int count;
    private int position;
    private Bitmap displayImage;
    private Bitmap hideImage;
    private AbOnItemClickListener mOnItemClickListener;
    private AbOnChangeListener mAbChangeListener;
    private AbOnScrollListener mAbScrolledListener;
    private AbOnTouchListener mAbOnTouchListener;
    public LinearLayout.LayoutParams layoutParamsFF = null;
    public LinearLayout.LayoutParams layoutParamsFW = null;
    public LinearLayout.LayoutParams layoutParamsWF = null;
    private ArrayList<View> mListViews = null;
    private AbViewPagerAdapter mAbViewPagerAdapter = null;
    private LinearLayout mPageLineLayoutParent = null;
    private int pageLineHorizontalGravity = 5;
    private int playingDirection = 0;
    private boolean play = false;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                int count = AbSlidingPlayView.this.mListViews.size();
                int i = AbSlidingPlayView.this.mViewPager.getCurrentItem();
                if (AbSlidingPlayView.this.playingDirection == 0) {
                    if (i == count - 1) {
                        AbSlidingPlayView.this.playingDirection = -1;
                        --i;
                    } else {
                        ++i;
                    }
                } else if (i == 0) {
                    AbSlidingPlayView.this.playingDirection = 0;
                    ++i;
                } else {
                    --i;
                }
                AbSlidingPlayView.this.mViewPager.setCurrentItem(i, true);
                if (AbSlidingPlayView.this.play) {
                    AbSlidingPlayView.this.handler.postDelayed(AbSlidingPlayView.this.runnable, 5000L);
                }
            }
        }
    };
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (AbSlidingPlayView.this.mViewPager != null) {
                AbSlidingPlayView.this.handler.sendEmptyMessage(0);
            }
        }
    };

    public AbSlidingPlayView(Context context) {
        super(context);
        this.initView(context);
    }

    public AbSlidingPlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public void initView(Context context) {
        this.context = context;
        this.layoutParamsFF = new LinearLayout.LayoutParams(-1, -1);
        this.layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.layoutParamsWF = new LinearLayout.LayoutParams(-2, -1);
        this.pageLineLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.setOrientation(1);
        this.setBackgroundColor(Color.rgb((int)255, (int)255, (int)255));
        RelativeLayout mRelativeLayout = new RelativeLayout(context);
        this.mViewPager = new AbInnerViewPager(context);
        this.mViewPager.setId(1985);
        this.mPageLineLayoutParent = new LinearLayout(context);
        this.mPageLineLayoutParent.setPadding(0, 5, 0, 5);
        this.pageLineLayout = new LinearLayout(context);
        this.pageLineLayout.setPadding(15, 1, 15, 1);
        this.pageLineLayout.setVisibility(4);
        this.mPageLineLayoutParent.addView((View)this.pageLineLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        RelativeLayout.LayoutParams lp1 = new RelativeLayout.LayoutParams(-2, -2);
        lp1.addRule(12, -1);
        lp1.addRule(14, -1);
        lp1.addRule(15, -1);
        mRelativeLayout.addView((View)this.mViewPager, (ViewGroup.LayoutParams)lp1);
        RelativeLayout.LayoutParams lp2 = new RelativeLayout.LayoutParams(-1, -2);
        lp2.addRule(12, -1);
        mRelativeLayout.addView((View)this.mPageLineLayoutParent, (ViewGroup.LayoutParams)lp2);
        this.addView((View)mRelativeLayout, (ViewGroup.LayoutParams)this.layoutParamsFW);
        this.displayImage = AbFileUtil.getBitmapFormSrc("image/play_display.png");
        this.hideImage = AbFileUtil.getBitmapFormSrc("image/play_hide.png");
        this.mListViews = new ArrayList();
        this.mAbViewPagerAdapter = new AbViewPagerAdapter(context, this.mListViews);
        this.mViewPager.setAdapter(this.mAbViewPagerAdapter);
        this.mViewPager.setFadingEdgeLength(0);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int position) {
                AbSlidingPlayView.this.makesurePosition();
                AbSlidingPlayView.this.onPageSelectedCallBack(position);
            }

            public void onPageScrollStateChanged(int state) {
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                AbSlidingPlayView.this.onPageScrolledCallBack(position);
            }
        });
    }

    public void creatIndex() {
        this.pageLineLayout.removeAllViews();
        this.mPageLineLayoutParent.setHorizontalGravity(this.pageLineHorizontalGravity);
        this.pageLineLayout.setGravity(17);
        this.pageLineLayout.setVisibility(0);
        this.count = this.mListViews.size();
        int j = 0;
        while (j < this.count) {
            ImageView imageView = new ImageView(this.context);
            this.pageLineLayoutParams.setMargins(5, 5, 5, 5);
            imageView.setLayoutParams((ViewGroup.LayoutParams)this.pageLineLayoutParams);
            if (j == 0) {
                imageView.setImageBitmap(this.displayImage);
            } else {
                imageView.setImageBitmap(this.hideImage);
            }
            this.pageLineLayout.addView((View)imageView, j);
            ++j;
        }
    }

    public void makesurePosition() {
        this.position = this.mViewPager.getCurrentItem();
        int j = 0;
        while (j < this.count) {
            if (this.position == j) {
                ((ImageView)this.pageLineLayout.getChildAt(this.position)).setImageBitmap(this.displayImage);
            } else {
                ((ImageView)this.pageLineLayout.getChildAt(j)).setImageBitmap(this.hideImage);
            }
            ++j;
        }
    }

    public void addView(View view) {
        this.mListViews.add(view);
        if (!(view instanceof AbsListView)) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AbSlidingPlayView.this.mOnItemClickListener != null) {
                        AbSlidingPlayView.this.mOnItemClickListener.onClick(AbSlidingPlayView.this.position);
                    }
                }
            });
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent event) {
                    if (AbSlidingPlayView.this.mAbOnTouchListener != null) {
                        AbSlidingPlayView.this.mAbOnTouchListener.onTouch(event);
                    }
                    return false;
                }
            });
        }
        this.mAbViewPagerAdapter.notifyDataSetChanged();
        this.creatIndex();
    }

    public void addViews(List<View> views) {
        this.mListViews.addAll(views);
        for (View view : views) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AbSlidingPlayView.this.mOnItemClickListener != null) {
                        AbSlidingPlayView.this.mOnItemClickListener.onClick(AbSlidingPlayView.this.position);
                    }
                }
            });
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent event) {
                    if (AbSlidingPlayView.this.mAbOnTouchListener != null) {
                        AbSlidingPlayView.this.mAbOnTouchListener.onTouch(event);
                    }
                    return false;
                }
            });
        }
        this.mAbViewPagerAdapter.notifyDataSetChanged();
        this.creatIndex();
    }

    public void removeAllViews() {
        this.mListViews.clear();
        this.mAbViewPagerAdapter.notifyDataSetChanged();
        this.creatIndex();
    }

    private void onPageScrolledCallBack(int position) {
        if (this.mAbScrolledListener != null) {
            this.mAbScrolledListener.onScroll(position);
        }
    }

    private void onPageSelectedCallBack(int position) {
        if (this.mAbChangeListener != null) {
            this.mAbChangeListener.onChange(position);
        }
    }

    public void startPlay() {
        if (this.handler != null) {
            this.play = true;
            this.handler.postDelayed(this.runnable, 5000L);
        }
    }

    public void stopPlay() {
        if (this.handler != null) {
            this.play = false;
            this.handler.removeCallbacks(this.runnable);
        }
    }

    public void setOnItemClickListener(AbOnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnPageChangeListener(AbOnChangeListener abChangeListener) {
        this.mAbChangeListener = abChangeListener;
    }

    public void setOnPageScrolledListener(AbOnScrollListener abScrolledListener) {
        this.mAbScrolledListener = abScrolledListener;
    }

    public void setOnTouchListener(AbOnTouchListener abOnTouchListener) {
        this.mAbOnTouchListener = abOnTouchListener;
    }

    public void setPageLineImage(Bitmap displayImage, Bitmap hideImage) {
        this.displayImage = displayImage;
        this.hideImage = hideImage;
        this.creatIndex();
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public int getCount() {
        return this.mListViews.size();
    }

    public void setPageLineHorizontalGravity(int horizontalGravity) {
        this.pageLineHorizontalGravity = horizontalGravity;
    }

    public void setParentScrollView(ScrollView parentScrollView) {
        this.mViewPager.setParentScrollView(parentScrollView);
    }

    public void setParentListView(ListView parentListView) {
        this.mViewPager.setParentListView(parentListView);
    }

    public void setPageLineLayoutBackground(int resid) {
        this.pageLineLayout.setBackgroundResource(resid);
    }
}

