/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.table;

import android.content.Context;
import android.graphics.Color;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;
import com.ab.view.listener.AbOnItemClickListener;
import java.util.List;

public class AbTable {
    private static AbTable mAbTable = null;
    private static int mScreenWidth = 0;
    private static int mScreenHeight = 0;
    private String[] titles;
    private List<String[]> contents;
    private int[] cellTypes;
    private int[] cellWidth;
    private int[] rowHeight;
    private int[] rowTextSize;
    private int[] rowTextColor;
    private int[] tableResource;
    private AbOnItemClickListener itemCellTouchListener;
    private AbOnItemClickListener itemCellCheckListener;

    public static AbTable newAbTable(Context context, int columnSize) {
        if (columnSize <= 0) {
            Toast.makeText((Context)context, (CharSequence)"\u8bf7\u8bbe\u7f6e\u8868\u683c\u7684\u5217\u6570>0!", (int)0).show();
            return null;
        }
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        mScreenWidth = display.getWidth();
        mScreenHeight = display.getHeight();
        mAbTable = new AbTable();
        AbTable.mAbTable.titles = new String[columnSize];
        int i = 0;
        while (i < columnSize) {
            AbTable.mAbTable.titles[i] = "\u6807\u9898" + i;
            ++i;
        }
        AbTable.mAbTable.cellTypes = new int[columnSize];
        i = 0;
        while (i < columnSize) {
            AbTable.mAbTable.cellTypes[i] = 0;
            ++i;
        }
        AbTable.mAbTable.cellWidth = new int[columnSize];
        i = 0;
        while (i < columnSize) {
            AbTable.mAbTable.cellWidth[i] = mScreenWidth / columnSize;
            ++i;
        }
        AbTable.mAbTable.rowHeight = new int[]{30, 30};
        AbTable.mAbTable.rowTextSize = new int[]{18, 16};
        AbTable.mAbTable.rowTextColor = new int[]{Color.rgb((int)113, (int)113, (int)113), Color.rgb((int)113, (int)113, (int)113)};
        AbTable.mAbTable.tableResource = new int[]{17170445, 17170445, 17170445, 17170445};
        return mAbTable;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public void setTitles(String[] titles) {
        int i = 0;
        while (i < titles.length) {
            AbTable.mAbTable.titles[i] = titles[i];
            ++i;
        }
    }

    public List<String[]> getContents() {
        return this.contents;
    }

    public void setContents(List<String[]> contents) {
        this.contents = contents;
    }

    public int[] getCellTypes() {
        return this.cellTypes;
    }

    public void setCellTypes(int[] cellTypes) {
        this.cellTypes = cellTypes;
    }

    public int[] getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int[] cellWidth) {
        int i = 0;
        while (i < cellWidth.length) {
            AbTable.mAbTable.cellWidth[i] = mScreenWidth * cellWidth[i] / 100;
            ++i;
        }
    }

    public int[] getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int[] rowHeight) {
        int i = 0;
        while (i < rowHeight.length) {
            AbTable.mAbTable.rowHeight[i] = rowHeight[i];
            ++i;
        }
    }

    public int[] getRowTextSize() {
        return this.rowTextSize;
    }

    public void setRowTextSize(int[] rowTextSize) {
        int i = 0;
        while (i < rowTextSize.length) {
            AbTable.mAbTable.rowTextSize[i] = rowTextSize[i];
            ++i;
        }
    }

    public int[] getRowTextColor() {
        return this.rowTextColor;
    }

    public void setRowTextColor(int[] rowTextColor) {
        int i = 0;
        while (i < rowTextColor.length) {
            AbTable.mAbTable.rowTextColor[i] = rowTextColor[i];
            ++i;
        }
    }

    public int[] getTableResource() {
        return this.tableResource;
    }

    public void setTableResource(int[] tableResource) {
        int i = 0;
        while (i < tableResource.length) {
            this.tableResource[i] = tableResource[i];
            ++i;
        }
    }

    public AbOnItemClickListener getItemCellTouchListener() {
        return this.itemCellTouchListener;
    }

    public void setItemCellTouchListener(AbOnItemClickListener itemCellTouchListener) {
        this.itemCellTouchListener = itemCellTouchListener;
    }

    public AbOnItemClickListener getItemCellCheckListener() {
        return this.itemCellCheckListener;
    }

    public void setItemCellCheckListener(AbOnItemClickListener itemCellCheckListener) {
        this.itemCellCheckListener = itemCellCheckListener;
    }
}

