/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.table;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.ab.view.table.AbTable;
import com.ab.view.table.AbTableCell;
import com.ab.view.table.AbTableItemView;
import com.ab.view.table.AbTableRow;
import java.util.ArrayList;
import java.util.List;

public class AbTableArrayAdapter
extends BaseAdapter {
    private Context context;
    private ArrayList<View> tableView;
    private String[] titles;
    private List<String[]> contents;
    private int columns;
    private int[] cellWidth;
    private int[] cellTypes;
    private int[] tableResource;
    private int[] rowHeight;
    private int[] rowTextSize;
    private int[] rowTextColor;
    private AbTable table;

    public AbTableArrayAdapter(Context context, AbTable table) {
        this.context = context;
        this.tableView = new ArrayList();
        this.setTable(table);
    }

    public void setTable(AbTable table) {
        this.table = table;
        this.titles = table.getTitles();
        this.contents = table.getContents();
        this.cellTypes = table.getCellTypes();
        this.cellWidth = table.getCellWidth();
        this.rowHeight = table.getRowHeight();
        this.rowTextSize = table.getRowTextSize();
        this.rowTextColor = table.getRowTextColor();
        this.tableResource = table.getTableResource();
        this.columns = this.cellTypes.length;
        this.tableView.clear();
    }

    public int getCount() {
        return this.contents.size() + 1;
    }

    public long getItemId(int position) {
        return position;
    }

    public AbTableItemView getItem(int position) {
        return (AbTableItemView)this.tableView.get(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            if (position == 0) {
                AbTableCell[] tableCells = new AbTableCell[this.columns];
                int j = 0;
                while (j < this.columns) {
                    tableCells[j] = new AbTableCell(this.titles[j], this.cellWidth[j], this.cellTypes[j]);
                    ++j;
                }
                convertView = new AbTableItemView(this.context, this, position, new AbTableRow(tableCells, this.rowHeight[0], this.rowTextSize[0], this.rowTextColor[0], this.tableResource[1]), this.table);
                convertView.setBackgroundResource(this.tableResource[0]);
            } else {
                AbTableCell[] tableCells = new AbTableCell[this.columns];
                String[] content = this.contents.get(position - 1);
                int size = this.contents.size();
                if (size > 0) {
                    int j = 0;
                    while (j < this.columns) {
                        tableCells[j] = new AbTableCell(content[j], this.cellWidth[j], this.cellTypes[j]);
                        ++j;
                    }
                    convertView = new AbTableItemView(this.context, this, position, new AbTableRow(tableCells, this.rowHeight[1], this.rowTextSize[1], this.rowTextColor[1], this.tableResource[3]), this.table);
                }
                convertView.setBackgroundResource(this.tableResource[2]);
            }
        } else if (position == 0) {
            AbTableItemView rowView = (AbTableItemView)((Object)convertView);
            AbTableCell[] tableCells = new AbTableCell[this.columns];
            int j = 0;
            while (j < this.columns) {
                tableCells[j] = new AbTableCell(this.titles[j], this.cellWidth[j], this.cellTypes[j]);
                ++j;
            }
            rowView.setTableRowView(position, new AbTableRow(tableCells, this.rowHeight[0], this.rowTextSize[0], this.rowTextColor[0], this.tableResource[1]));
            convertView.setBackgroundResource(this.tableResource[0]);
        } else {
            AbTableItemView rowView = (AbTableItemView)((Object)convertView);
            AbTableCell[] tableCells = new AbTableCell[this.columns];
            String[] content = this.contents.get(position - 1);
            int size = this.contents.size();
            if (size > 0) {
                int j = 0;
                while (j < this.columns) {
                    tableCells[j] = new AbTableCell(content[j], this.cellWidth[j], this.cellTypes[j]);
                    ++j;
                }
                rowView.setTableRowView(position, new AbTableRow(tableCells, this.rowHeight[1], this.rowTextSize[1], this.rowTextColor[1], this.tableResource[3]));
            }
            convertView.setBackgroundResource(this.tableResource[2]);
        }
        if (this.tableView.size() > position) {
            this.tableView.set(position, (View)convertView);
        } else {
            this.tableView.add(position, (View)convertView);
        }
        return convertView;
    }

    public void addItem(String[] row) {
        this.contents.add(row);
        this.notifyDataSetChanged();
    }
}

