/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.table;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.global.AbAppData;
import com.ab.view.listener.AbOnItemClickListener;
import com.ab.view.table.AbTable;
import com.ab.view.table.AbTableArrayAdapter;
import com.ab.view.table.AbTableCell;
import com.ab.view.table.AbTableRow;

public class AbTableItemView
extends LinearLayout {
    private static String TAG = "AbTableItemView";
    private static final boolean D = AbAppData.DEBUG;
    private Context mContext;
    private int cellCount;
    private View[] rowCell;
    private int mPosition;
    private AbTable mTable = null;
    private AbTableArrayAdapter mAdapter = null;

    public AbTableItemView(Context context, AbTableArrayAdapter adapter, int position, AbTableRow tableRow, AbTable table) {
        super(context);
        this.mPosition = position;
        this.mContext = context;
        this.mTable = table;
        this.mAdapter = adapter;
        this.setOrientation(0);
        this.cellCount = tableRow.getCellSize();
        this.rowCell = new View[this.cellCount];
        LinearLayout.LayoutParams layoutParams = null;
        int i = 0;
        while (i < this.cellCount) {
            LinearLayout mLinearLayout;
            final int index = i;
            AbTableCell tableCell = tableRow.getCellValue(index);
            layoutParams = new LinearLayout.LayoutParams(-2, tableRow.height);
            if (tableCell.type == 0) {
                TextView textCell = new TextView(this.mContext);
                textCell.setMinimumWidth(tableCell.width);
                textCell.setMinimumHeight(tableRow.height);
                if (D) {
                    Log.d((String)TAG, (String)("\u884c\u9ad8\uff1a" + tableRow.height));
                }
                textCell.setLines(1);
                textCell.setGravity(17);
                textCell.setTextColor(tableRow.textColor);
                if (this.mPosition == 0) {
                    if (D) {
                        Log.d((String)TAG, (String)("\u6807\u9898\u680f\u7684\u989c\u8272\uff1a" + tableRow.textColor));
                    }
                    textCell.setTypeface(Typeface.DEFAULT_BOLD);
                    textCell.setBackgroundResource(this.mTable.getTableResource()[1]);
                } else {
                    textCell.setTypeface(Typeface.DEFAULT);
                    textCell.setBackgroundResource(this.mTable.getTableResource()[3]);
                }
                textCell.setText((CharSequence)String.valueOf(tableCell.value));
                textCell.setTextSize((float)tableRow.textSize);
                this.rowCell[i] = textCell;
                this.addView((View)textCell, (ViewGroup.LayoutParams)layoutParams);
            } else if (tableCell.type == 1) {
                mLinearLayout = new LinearLayout(this.mContext);
                mLinearLayout.setMinimumWidth(tableCell.width);
                ImageView imgCell = new ImageView(this.mContext);
                if (this.mPosition == 0) {
                    imgCell.setImageDrawable(null);
                    mLinearLayout.setGravity(17);
                    mLinearLayout.addView((View)imgCell, (ViewGroup.LayoutParams)layoutParams);
                    mLinearLayout.setBackgroundResource(this.mTable.getTableResource()[1]);
                    this.addView((View)mLinearLayout, (ViewGroup.LayoutParams)layoutParams);
                } else {
                    imgCell.setImageResource(Integer.parseInt((String)tableCell.value));
                    mLinearLayout.setGravity(17);
                    mLinearLayout.addView((View)imgCell, (ViewGroup.LayoutParams)layoutParams);
                    mLinearLayout.setBackgroundResource(this.mTable.getTableResource()[3]);
                    this.addView((View)mLinearLayout, (ViewGroup.LayoutParams)layoutParams);
                    imgCell.setOnTouchListener(new View.OnTouchListener(){

                        public boolean onTouch(View v, MotionEvent event) {
                            AbOnItemClickListener mAbOnItemClickListener;
                            if (event.getAction() == 0 && (mAbOnItemClickListener = AbTableItemView.this.mTable.getItemCellTouchListener()) != null) {
                                mAbOnItemClickListener.onClick(AbTableItemView.this.mPosition);
                            }
                            return false;
                        }
                    });
                }
                this.rowCell[i] = imgCell;
            } else if (tableCell.type == 3) {
                mLinearLayout = new LinearLayout(this.mContext);
                mLinearLayout.setMinimumWidth(tableCell.width);
                CheckBox mCheckBox = new CheckBox(context);
                mCheckBox.setGravity(17);
                mCheckBox.setOnCheckedChangeListener(null);
                mCheckBox.setFocusable(false);
                int isCheck = Integer.parseInt(String.valueOf(tableCell.value));
                if (isCheck == 1) {
                    mCheckBox.setChecked(true);
                } else {
                    mCheckBox.setChecked(false);
                }
                if (this.mPosition == 0) {
                    mLinearLayout.setGravity(17);
                    mLinearLayout.addView((View)mCheckBox, (ViewGroup.LayoutParams)layoutParams);
                    mLinearLayout.setBackgroundResource(this.mTable.getTableResource()[1]);
                    this.addView((View)mLinearLayout, (ViewGroup.LayoutParams)layoutParams);
                } else {
                    mLinearLayout.setGravity(17);
                    mLinearLayout.addView((View)mCheckBox, (ViewGroup.LayoutParams)layoutParams);
                    mLinearLayout.setBackgroundResource(this.mTable.getTableResource()[3]);
                    this.addView((View)mLinearLayout, (ViewGroup.LayoutParams)layoutParams);
                }
                mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        if (AbTableItemView.this.mPosition == 0) {
                            int i;
                            if (isChecked) {
                                ((AbTableItemView)AbTableItemView.this).mTable.getTitles()[index] = "1";
                                i = 0;
                                while (i < AbTableItemView.this.mTable.getContents().size()) {
                                    ((AbTableItemView)AbTableItemView.this).mTable.getContents().get((int)i)[index] = "1";
                                    ++i;
                                }
                            } else {
                                ((AbTableItemView)AbTableItemView.this).mTable.getTitles()[index] = "0";
                                i = 0;
                                while (i < AbTableItemView.this.mTable.getContents().size()) {
                                    ((AbTableItemView)AbTableItemView.this).mTable.getContents().get((int)i)[index] = "0";
                                    ++i;
                                }
                            }
                        } else {
                            ((AbTableItemView)AbTableItemView.this).mTable.getContents().get((int)(((AbTableItemView)AbTableItemView.this).mPosition - 1))[index] = isChecked ? "1" : "0";
                        }
                        AbTableItemView.this.mAdapter.notifyDataSetChanged();
                        AbOnItemClickListener itemCellCheckListener = AbTableItemView.this.mTable.getItemCellCheckListener();
                        if (itemCellCheckListener != null) {
                            itemCellCheckListener.onClick(AbTableItemView.this.mPosition);
                        }
                    }
                });
                this.rowCell[index] = mCheckBox;
            }
            ++i;
        }
    }

    public void setTableRowView(int position, AbTableRow tableRow) {
        this.mPosition = position;
        int i = 0;
        while (i < this.cellCount) {
            final int index = i;
            AbTableCell tableCell = tableRow.getCellValue(index);
            if (tableCell.type == 0) {
                TextView textCell = (TextView)this.rowCell[index];
                textCell.setMinimumWidth(tableCell.width);
                textCell.setMinimumHeight(tableRow.height);
                textCell.setLines(1);
                textCell.setGravity(17);
                textCell.setText((CharSequence)String.valueOf(tableCell.value));
                textCell.setTextColor(tableRow.textColor);
                textCell.setTextSize((float)tableRow.textSize);
                if (this.mPosition == 0) {
                    textCell.setTypeface(Typeface.DEFAULT_BOLD);
                    textCell.setBackgroundResource(this.mTable.getTableResource()[1]);
                } else {
                    textCell.setTypeface(Typeface.DEFAULT);
                    textCell.setBackgroundResource(this.mTable.getTableResource()[3]);
                }
            } else if (tableCell.type == 1) {
                ImageView imgCell;
                if (this.mPosition == 0) {
                    imgCell = (ImageView)this.rowCell[index];
                    imgCell.setImageDrawable(null);
                    ((LinearLayout)imgCell.getParent()).setBackgroundResource(this.mTable.getTableResource()[1]);
                } else {
                    imgCell = (ImageView)this.rowCell[index];
                    ((LinearLayout)imgCell.getParent()).setBackgroundResource(this.mTable.getTableResource()[3]);
                    imgCell.setImageResource(Integer.parseInt((String)tableCell.value));
                    imgCell.setOnTouchListener(new View.OnTouchListener(){

                        public boolean onTouch(View v, MotionEvent event) {
                            AbOnItemClickListener mAbOnItemClickListener;
                            if (event.getAction() == 0 && (mAbOnItemClickListener = AbTableItemView.this.mTable.getItemCellTouchListener()) != null) {
                                mAbOnItemClickListener.onClick(AbTableItemView.this.mPosition);
                            }
                            return false;
                        }
                    });
                }
            } else if (tableCell.type == 3) {
                CheckBox mCheckBox = (CheckBox)this.rowCell[index];
                mCheckBox.setOnCheckedChangeListener(null);
                int isCheck = Integer.parseInt(String.valueOf(tableCell.value));
                if (isCheck == 1) {
                    mCheckBox.setChecked(true);
                } else {
                    mCheckBox.setChecked(false);
                }
                if (this.mPosition == 0) {
                    ((LinearLayout)mCheckBox.getParent()).setBackgroundResource(this.mTable.getTableResource()[1]);
                } else {
                    ((LinearLayout)mCheckBox.getParent()).setBackgroundResource(this.mTable.getTableResource()[3]);
                }
                mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        if (AbTableItemView.this.mPosition == 0) {
                            int i;
                            if (isChecked) {
                                ((AbTableItemView)AbTableItemView.this).mTable.getTitles()[index] = "1";
                                i = 0;
                                while (i < AbTableItemView.this.mTable.getContents().size()) {
                                    ((AbTableItemView)AbTableItemView.this).mTable.getContents().get((int)i)[index] = "1";
                                    ++i;
                                }
                            } else {
                                ((AbTableItemView)AbTableItemView.this).mTable.getTitles()[index] = "0";
                                i = 0;
                                while (i < AbTableItemView.this.mTable.getContents().size()) {
                                    ((AbTableItemView)AbTableItemView.this).mTable.getContents().get((int)i)[index] = "0";
                                    ++i;
                                }
                            }
                        } else {
                            ((AbTableItemView)AbTableItemView.this).mTable.getContents().get((int)(((AbTableItemView)AbTableItemView.this).mPosition - 1))[index] = isChecked ? "1" : "0";
                        }
                        AbTableItemView.this.mAdapter.notifyDataSetChanged();
                        AbOnItemClickListener itemCellCheckListener = AbTableItemView.this.mTable.getItemCellCheckListener();
                        if (itemCellCheckListener != null) {
                            itemCellCheckListener.onClick(AbTableItemView.this.mPosition);
                        }
                    }
                });
                mCheckBox.setFocusable(false);
            }
            ++i;
        }
    }
}

