/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.wheel;

import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.ab.activity.AbActivity;
import com.ab.util.AbDateUtil;
import com.ab.util.AbStrUtil;
import com.ab.view.wheel.AbNumericWheelAdapter;
import com.ab.view.wheel.AbOnWheelChangedListener;
import com.ab.view.wheel.AbStringWheelAdapter;
import com.ab.view.wheel.AbWheelView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class AbWheelUtil {
    public static void initWheelDatePicker(final AbActivity activity, final TextView mText, final AbWheelView mWheelViewY, final AbWheelView mWheelViewM, final AbWheelView mWheelViewD, Button okBtn, Button cancelBtn, int defaultYear, int defaultMonth, int defaultDay, final int startYear, int endYearOffset, boolean initStart) {
        int endYear = startYear + endYearOffset;
        String[] months_big = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] months_little = new String[]{"4", "6", "9", "11"};
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        if (initStart) {
            defaultYear = year;
            defaultMonth = month;
            defaultDay = day;
        }
        mText.setText((CharSequence)AbStrUtil.dateTimeFormat(String.valueOf(defaultYear) + "-" + defaultMonth + "-" + defaultDay));
        final List<String> list_big = Arrays.asList(months_big);
        final List<String> list_little = Arrays.asList(months_little);
        mWheelViewY.setAdapter(new AbNumericWheelAdapter(startYear, endYear));
        mWheelViewY.setCyclic(true);
        mWheelViewY.setLabel("\u5e74");
        mWheelViewY.setCurrentItem(defaultYear - startYear);
        mWheelViewY.setValueTextSize(32);
        mWheelViewY.setLabelTextSize(30);
        mWheelViewY.setLabelTextColor(Integer.MIN_VALUE);
        mWheelViewM.setAdapter(new AbNumericWheelAdapter(1, 12));
        mWheelViewM.setCyclic(true);
        mWheelViewM.setLabel("\u6708");
        mWheelViewM.setCurrentItem(defaultMonth - 1);
        mWheelViewM.setValueTextSize(32);
        mWheelViewM.setLabelTextSize(30);
        mWheelViewM.setLabelTextColor(Integer.MIN_VALUE);
        if (list_big.contains(String.valueOf(month + 1))) {
            mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 31));
        } else if (list_little.contains(String.valueOf(month + 1))) {
            mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 30));
        } else if (AbDateUtil.isLeapYear(year)) {
            mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 29));
        } else {
            mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 28));
        }
        mWheelViewD.setCyclic(true);
        mWheelViewD.setLabel("\u65e5");
        mWheelViewD.setCurrentItem(defaultDay - 1);
        mWheelViewD.setValueTextSize(32);
        mWheelViewD.setLabelTextSize(30);
        mWheelViewD.setLabelTextColor(Integer.MIN_VALUE);
        AbOnWheelChangedListener wheelListener_year = new AbOnWheelChangedListener(){

            @Override
            public void onChanged(AbWheelView wheel, int oldValue, int newValue) {
                int year_num = newValue + startYear;
                int mDIndex = mWheelViewM.getCurrentItem();
                if (list_big.contains(String.valueOf(mWheelViewM.getCurrentItem() + 1))) {
                    mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 31));
                } else if (list_little.contains(String.valueOf(mWheelViewM.getCurrentItem() + 1))) {
                    mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 30));
                } else if (AbDateUtil.isLeapYear(year_num)) {
                    mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 29));
                } else {
                    mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 28));
                }
                mWheelViewM.setCurrentItem(mDIndex);
            }
        };
        AbOnWheelChangedListener wheelListener_month = new AbOnWheelChangedListener(){

            @Override
            public void onChanged(AbWheelView wheel, int oldValue, int newValue) {
                int month_num = newValue + 1;
                if (list_big.contains(String.valueOf(month_num))) {
                    mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 31));
                } else if (list_little.contains(String.valueOf(month_num))) {
                    mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 30));
                } else {
                    int year_num = mWheelViewY.getCurrentItem() + startYear;
                    if (AbDateUtil.isLeapYear(year_num)) {
                        mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 29));
                    } else {
                        mWheelViewD.setAdapter(new AbNumericWheelAdapter(1, 28));
                    }
                }
                mWheelViewD.setCurrentItem(0);
            }
        };
        mWheelViewY.addChangingListener(wheelListener_year);
        mWheelViewM.addChangingListener(wheelListener_month);
        okBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.removeDialog(1);
                int indexYear = mWheelViewY.getCurrentItem();
                String year = mWheelViewY.getAdapter().getItem(indexYear);
                int indexMonth = mWheelViewM.getCurrentItem();
                String month = mWheelViewM.getAdapter().getItem(indexMonth);
                int indexDay = mWheelViewD.getCurrentItem();
                String day = mWheelViewD.getAdapter().getItem(indexDay);
                mText.setText((CharSequence)AbStrUtil.dateTimeFormat(String.valueOf(year) + "-" + month + "-" + day));
            }
        });
        cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.removeDialog(1);
            }
        });
    }

    public static void initWheelTimePicker(final AbActivity activity, final TextView mText, final AbWheelView mWheelViewMD, final AbWheelView mWheelViewHH, final AbWheelView mWheelViewMM, Button okBtn, Button cancelBtn, int defaultYear, int defaultMonth, int defaultDay, int defaultHour, int defaultMinute, boolean initStart) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (initStart) {
            defaultYear = year;
            defaultMonth = month;
            defaultDay = day;
            defaultHour = hour;
            defaultMinute = minute;
        }
        String val = AbStrUtil.dateTimeFormat(String.valueOf(defaultYear) + "-" + defaultMonth + "-" + defaultDay + " " + defaultHour + ":" + defaultMinute + ":" + second);
        mText.setText((CharSequence)val);
        String[] months_big = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] months_little = new String[]{"4", "6", "9", "11"};
        List<String> list_big = Arrays.asList(months_big);
        List<String> list_little = Arrays.asList(months_little);
        ArrayList<String> textDMList = new ArrayList<String>();
        final ArrayList<String> textDMDateList = new ArrayList<String>();
        int i = 1;
        while (i < 13) {
            int j;
            if (list_big.contains(String.valueOf(i))) {
                j = 1;
                while (j < 32) {
                    textDMList.add(String.valueOf(i) + "\u6708" + " " + j + "\u65e5");
                    textDMDateList.add(String.valueOf(defaultYear) + "-" + i + "-" + j);
                    ++j;
                }
            } else if (i == 2) {
                if (AbDateUtil.isLeapYear(defaultYear)) {
                    j = 1;
                    while (j < 28) {
                        textDMList.add(String.valueOf(i) + "\u6708" + " " + j + "\u65e5");
                        textDMDateList.add(String.valueOf(defaultYear) + "-" + i + "-" + j);
                        ++j;
                    }
                } else {
                    j = 1;
                    while (j < 29) {
                        textDMList.add(String.valueOf(i) + "\u6708" + " " + j + "\u65e5");
                        textDMDateList.add(String.valueOf(defaultYear) + "-" + i + "-" + j);
                        ++j;
                    }
                }
            } else {
                j = 1;
                while (j < 29) {
                    textDMList.add(String.valueOf(i) + "\u6708" + " " + j + "\u65e5");
                    textDMDateList.add(String.valueOf(defaultYear) + "-" + i + "-" + j);
                    ++j;
                }
            }
            ++i;
        }
        String currentDay = String.valueOf(defaultMonth) + "\u6708" + " " + defaultDay + "\u65e5";
        int currentDayIndex = textDMList.indexOf(currentDay);
        mWheelViewMD.setAdapter(new AbStringWheelAdapter(textDMList, AbStrUtil.strLength("12\u6708 12\u65e5")));
        mWheelViewMD.setCyclic(true);
        mWheelViewMD.setLabel("");
        mWheelViewMD.setCurrentItem(currentDayIndex);
        mWheelViewMD.setValueTextSize(32);
        mWheelViewMD.setLabelTextSize(30);
        mWheelViewMD.setLabelTextColor(Integer.MIN_VALUE);
        mWheelViewHH.setAdapter(new AbNumericWheelAdapter(0, 23));
        mWheelViewHH.setCyclic(true);
        mWheelViewHH.setLabel("\u70b9");
        mWheelViewHH.setCurrentItem(defaultHour);
        mWheelViewHH.setValueTextSize(32);
        mWheelViewHH.setLabelTextSize(30);
        mWheelViewHH.setLabelTextColor(Integer.MIN_VALUE);
        mWheelViewMM.setAdapter(new AbNumericWheelAdapter(0, 59));
        mWheelViewMM.setCyclic(true);
        mWheelViewMM.setLabel("\u5206");
        mWheelViewMM.setCurrentItem(defaultMinute);
        mWheelViewMM.setValueTextSize(32);
        mWheelViewMM.setLabelTextSize(30);
        mWheelViewMM.setLabelTextColor(Integer.MIN_VALUE);
        okBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.removeDialog(1);
                int index1 = mWheelViewMD.getCurrentItem();
                int index2 = mWheelViewHH.getCurrentItem();
                int index3 = mWheelViewMM.getCurrentItem();
                String dmStr = (String)textDMDateList.get(index1);
                Calendar calendar = Calendar.getInstance();
                int second = calendar.get(13);
                String val = AbStrUtil.dateTimeFormat(String.valueOf(dmStr) + " " + index2 + ":" + index3 + ":" + second);
                mText.setText((CharSequence)val);
            }
        });
        cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.removeDialog(1);
            }
        });
    }

    public static void initWheelTimePicker2(final AbActivity activity, final TextView mText, final AbWheelView mWheelViewHH, final AbWheelView mWheelViewMM, Button okBtn, Button cancelBtn, int defaultHour, int defaultMinute, boolean initStart) {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        if (initStart) {
            defaultHour = hour;
            defaultMinute = minute;
        }
        String val = AbStrUtil.dateTimeFormat(String.valueOf(defaultHour) + ":" + defaultMinute);
        mText.setText((CharSequence)val);
        mWheelViewHH.setAdapter(new AbNumericWheelAdapter(0, 23));
        mWheelViewHH.setCyclic(true);
        mWheelViewHH.setLabel("\u70b9");
        mWheelViewHH.setCurrentItem(defaultHour);
        mWheelViewHH.setValueTextSize(32);
        mWheelViewHH.setLabelTextSize(30);
        mWheelViewHH.setLabelTextColor(Integer.MIN_VALUE);
        mWheelViewMM.setAdapter(new AbNumericWheelAdapter(0, 59));
        mWheelViewMM.setCyclic(true);
        mWheelViewMM.setLabel("\u5206");
        mWheelViewMM.setCurrentItem(defaultMinute);
        mWheelViewMM.setValueTextSize(32);
        mWheelViewMM.setLabelTextSize(30);
        mWheelViewMM.setLabelTextColor(Integer.MIN_VALUE);
        okBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.removeDialog(1);
                int index2 = mWheelViewHH.getCurrentItem();
                int index3 = mWheelViewMM.getCurrentItem();
                String val = AbStrUtil.dateTimeFormat(String.valueOf(index2) + ":" + index3);
                mText.setText((CharSequence)val);
            }
        });
        cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                activity.removeDialog(1);
            }
        });
    }
}

