/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.wheel;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.os.Message;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.ab.global.AbAppData;
import com.ab.util.AbGraphical;
import com.ab.util.AbViewUtil;
import com.ab.view.wheel.AbOnWheelChangedListener;
import com.ab.view.wheel.AbOnWheelScrollListener;
import com.ab.view.wheel.AbWheelAdapter;
import java.util.LinkedList;
import java.util.List;

public class AbWheelView
extends View {
    private static String TAG = "AbWheelView";
    private static final boolean D = AbAppData.DEBUG;
    private Context mContext = null;
    private static final int SCROLLING_DURATION = 400;
    private static final int MIN_DELTA_FOR_SCROLLING = 1;
    private static final int ITEMS_TEXT_COLOR = -16777216;
    private static int[] SHADOWS_COLORS = new int[]{-15658735, 0xAAAAAA, 0xAAAAAA};
    private static final int LABEL_OFFSET = 8;
    private static final int PADDING = 5;
    private static final int DEF_VISIBLE_ITEMS = 5;
    private AbWheelAdapter adapter = null;
    private int currentItem = 0;
    private int itemsWidth = 0;
    private int labelWidth = 0;
    private int visibleItems = 5;
    private int itemHeight = 0;
    private TextPaint itemsPaint;
    private TextPaint valuePaint;
    private TextPaint labelPaint;
    private StaticLayout itemsLayout;
    private StaticLayout labelLayout;
    private StaticLayout valueLayout;
    private String label;
    private boolean isScrollingPerformed;
    private int scrollingOffset;
    private GestureDetector gestureDetector;
    private Scroller scroller;
    private int lastScrollY;
    boolean isCyclic = false;
    private List<AbOnWheelChangedListener> changingListeners = new LinkedList<AbOnWheelChangedListener>();
    private List<AbOnWheelScrollListener> scrollingListeners = new LinkedList<AbOnWheelScrollListener>();
    private Drawable centerSelectDrawable;
    private int[] centerSelectGradientColors = new int[]{0x70222222, 0x70222222, 0x70EEEEEE};
    private int centerSelectStrokeWidth = 1;
    private int centerSelectStrokeColor = 0x70333333;
    private GradientDrawable topShadow;
    private GradientDrawable bottomShadow;
    private int valueTextColor = -268435456;
    private int labelTextColor = -268435456;
    private int[] bottomGradientColors = new int[]{819, 3549, 819};
    private int[] topGradientColors = new int[]{2730, 4095, 2730};
    private int topStrokeWidth = 1;
    private int topStrokeColor = -13421773;
    private int valueTextSize = 35;
    private int labelTextSize = 35;
    private int itemOffset = this.valueTextSize / 5;
    private int additionalItemHeight = 30;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private GestureDetector.SimpleOnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            if (AbWheelView.this.isScrollingPerformed) {
                AbWheelView.this.scroller.forceFinished(true);
                AbWheelView.this.clearMessages();
                return true;
            }
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            AbWheelView.this.startScrolling();
            AbWheelView.this.doScroll((int)(-distanceY));
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            AbWheelView.this.lastScrollY = AbWheelView.this.currentItem * AbWheelView.this.getItemHeight() + AbWheelView.this.scrollingOffset;
            int maxY = AbWheelView.this.isCyclic ? Integer.MAX_VALUE : AbWheelView.this.adapter.getItemsCount() * AbWheelView.this.getItemHeight();
            int minY = AbWheelView.this.isCyclic ? -maxY : 0;
            AbWheelView.this.scroller.fling(0, AbWheelView.this.lastScrollY, 0, (int)(-velocityY) / 2, 0, 0, minY, maxY);
            AbWheelView.this.setNextMessage(0);
            return true;
        }
    };
    private final int MESSAGE_SCROLL = 0;
    private final int MESSAGE_JUSTIFY = 1;
    private Handler animationHandler = new Handler(){

        public void handleMessage(Message msg) {
            AbWheelView.this.scroller.computeScrollOffset();
            int currY = AbWheelView.this.scroller.getCurrY();
            int delta = AbWheelView.this.lastScrollY - currY;
            AbWheelView.this.lastScrollY = currY;
            if (delta != 0) {
                AbWheelView.this.doScroll(delta);
            }
            if (Math.abs(currY - AbWheelView.this.scroller.getFinalY()) < 1) {
                currY = AbWheelView.this.scroller.getFinalY();
                AbWheelView.this.scroller.forceFinished(true);
            }
            if (!AbWheelView.this.scroller.isFinished()) {
                AbWheelView.this.animationHandler.sendEmptyMessage(msg.what);
            } else if (msg.what == 0) {
                AbWheelView.this.justify();
            } else {
                AbWheelView.this.finishScrolling();
            }
        }
    };

    public AbWheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initData(context);
    }

    public AbWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initData(context);
    }

    public AbWheelView(Context context) {
        super(context);
        this.initData(context);
    }

    private void initData(Context context) {
        this.mContext = context;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.gestureListener);
        this.gestureDetector.setIsLongpressEnabled(false);
        this.scroller = new Scroller(context);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        this.screenWidth = displayMetrics.widthPixels;
        this.screenHeight = displayMetrics.heightPixels;
    }

    public AbWheelAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(AbWheelAdapter adapter) {
        this.adapter = adapter;
        this.invalidateLayouts();
        this.invalidate();
    }

    public void setInterpolator(Interpolator interpolator) {
        this.scroller.forceFinished(true);
        this.scroller = new Scroller(this.getContext(), interpolator);
    }

    public int getVisibleItems() {
        return this.visibleItems;
    }

    public void setVisibleItems(int count) {
        this.visibleItems = count;
        this.invalidate();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newLabel) {
        if (this.label == null || !this.label.equals(newLabel)) {
            this.label = newLabel;
            this.labelLayout = null;
            this.invalidate();
        }
    }

    public void addChangingListener(AbOnWheelChangedListener listener) {
        this.changingListeners.add(listener);
    }

    public void removeChangingListener(AbOnWheelChangedListener listener) {
        this.changingListeners.remove(listener);
    }

    protected void notifyChangingListeners(int oldValue, int newValue) {
        for (AbOnWheelChangedListener listener : this.changingListeners) {
            listener.onChanged(this, oldValue, newValue);
        }
    }

    public void addScrollingListener(AbOnWheelScrollListener listener) {
        this.scrollingListeners.add(listener);
    }

    public void removeScrollingListener(AbOnWheelScrollListener listener) {
        this.scrollingListeners.remove(listener);
    }

    protected void notifyScrollingListenersAboutStart() {
        for (AbOnWheelScrollListener listener : this.scrollingListeners) {
            listener.onScrollingStarted(this);
        }
    }

    protected void notifyScrollingListenersAboutEnd() {
        for (AbOnWheelScrollListener listener : this.scrollingListeners) {
            listener.onScrollingFinished(this);
        }
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(int index, boolean animated) {
        if (this.adapter == null || this.adapter.getItemsCount() == 0) {
            return;
        }
        if (index < 0 || index >= this.adapter.getItemsCount()) {
            if (this.isCyclic) {
                while (index < 0) {
                    index += this.adapter.getItemsCount();
                }
                index %= this.adapter.getItemsCount();
            } else {
                return;
            }
        }
        if (index != this.currentItem) {
            if (animated) {
                this.scroll(index - this.currentItem, 400);
            } else {
                this.invalidateLayouts();
                int old = this.currentItem;
                this.currentItem = index;
                this.notifyChangingListeners(old, this.currentItem);
                this.invalidate();
            }
        }
    }

    public void setCurrentItem(int index) {
        this.setCurrentItem(index, false);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
        this.invalidate();
        this.invalidateLayouts();
    }

    private void invalidateLayouts() {
        this.itemsLayout = null;
        this.valueLayout = null;
        this.scrollingOffset = 0;
    }

    private void initResourcesIfNecessary() {
        if (this.itemsPaint == null) {
            this.itemsPaint = new TextPaint(33);
            this.itemsPaint.setTextSize((float)this.valueTextSize);
        }
        if (this.valuePaint == null) {
            this.valuePaint = new TextPaint(37);
            this.valuePaint.setTextSize((float)this.valueTextSize);
        }
        if (this.labelPaint == null) {
            this.labelPaint = new TextPaint(37);
            this.labelPaint.setTextSize((float)this.labelTextSize);
            this.labelPaint.setShadowLayer(0.5f, 0.0f, 1.0f, -1);
        }
        if (this.centerSelectDrawable == null) {
            GradientDrawable mGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, this.centerSelectGradientColors);
            mGradientDrawable.setStroke(this.centerSelectStrokeWidth, this.centerSelectStrokeColor);
            this.centerSelectDrawable = mGradientDrawable;
        }
        if (this.topShadow == null) {
            this.topShadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, SHADOWS_COLORS);
        }
        if (this.bottomShadow == null) {
            this.bottomShadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, SHADOWS_COLORS);
        }
        if (this.getBackground() == null) {
            GradientDrawable mGradientDrawable1 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, this.topGradientColors);
            GradientDrawable mGradientDrawable2 = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, this.bottomGradientColors);
            mGradientDrawable1.setStroke(this.topStrokeWidth, this.topStrokeColor);
            mGradientDrawable1.setShape(0);
            mGradientDrawable2.setShape(0);
            mGradientDrawable1.setGradientType(0);
            mGradientDrawable2.setGradientType(0);
            GradientDrawable[] mDrawables = new GradientDrawable[]{mGradientDrawable1, mGradientDrawable2};
            LayerDrawable layerDrawable = new LayerDrawable((Drawable[])mDrawables);
            layerDrawable.setLayerInset(0, 0, 0, 0, 0);
            layerDrawable.setLayerInset(1, 4, 1, 4, 1);
            this.setBackgroundDrawable((Drawable)layerDrawable);
        }
    }

    private int getDesiredHeight(Layout layout) {
        if (layout == null) {
            return 0;
        }
        int desired = this.getItemHeight() * this.visibleItems - this.itemOffset * 2 - this.additionalItemHeight;
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    /*
     * Unable to fully structure code
     */
    private String getTextItem(int index) {
        if (this.adapter == null || this.adapter.getItemsCount() == 0) {
            return null;
        }
        count = this.adapter.getItemsCount();
        if (index >= 0 && index < count || this.isCyclic) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            index = count + index;
lbl7:
            // 2 sources

            ** while (index < 0)
        }
lbl8:
        // 1 sources

        return this.adapter.getItem(index %= count);
    }

    private String buildText(boolean useCurrentValue) {
        StringBuilder itemsText = new StringBuilder();
        int addItems = this.visibleItems / 2 + 1;
        int i = this.currentItem - addItems;
        while (i <= this.currentItem + addItems) {
            String text;
            if ((useCurrentValue || i != this.currentItem) && (text = this.getTextItem(i)) != null) {
                itemsText.append(text);
            }
            if (i < this.currentItem + addItems) {
                itemsText.append("\n");
            }
            ++i;
        }
        return itemsText.toString();
    }

    private int getMaxTextLength() {
        AbWheelAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return 0;
        }
        int adapterLength = adapter.getMaximumLength();
        if (adapterLength > 0) {
            return adapterLength;
        }
        return 0;
    }

    private int getItemHeight() {
        if (this.itemHeight != 0) {
            return this.itemHeight;
        }
        if (this.itemsLayout != null && this.itemsLayout.getLineCount() > 2) {
            this.itemHeight = this.itemsLayout.getLineTop(2) - this.itemsLayout.getLineTop(1);
            return this.itemHeight;
        }
        return this.getHeight() / this.visibleItems;
    }

    private int calculateLayoutWidth(int widthSize, int mode) {
        this.initResourcesIfNecessary();
        int width = widthSize;
        int maxLength = this.getMaxTextLength();
        if (maxLength > 0) {
            float textWidth = (int)AbGraphical.getStringWidth("0", this.labelPaint);
            this.itemsWidth = (int)((float)maxLength * textWidth);
        } else {
            this.itemsWidth = 0;
        }
        this.itemsWidth += 8;
        this.labelWidth = 0;
        if (this.label != null && this.label.length() > 0) {
            this.labelWidth = (int)AbGraphical.getStringWidth(this.label, this.labelPaint);
            if (D) {
                Log.d((String)TAG, (String)("itemsWidth:" + this.itemsWidth + ",labelWidth:" + this.labelWidth));
            }
        }
        boolean recalculate = false;
        if (mode == 0x40000000) {
            width = widthSize;
            recalculate = true;
        } else {
            width = this.itemsWidth + this.labelWidth + 10;
            if (this.labelWidth > 0) {
                width += 8;
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (mode == Integer.MIN_VALUE && widthSize < width) {
                width = widthSize;
                recalculate = true;
            }
        }
        if (recalculate) {
            int pureWidth = width - 8 - 10;
            if (pureWidth <= 0) {
                this.labelWidth = 0;
                this.itemsWidth = 0;
            }
            if (this.labelWidth > 0) {
                int newItemsWidth = pureWidth / 2;
                int newLabelWidth = pureWidth - this.itemsWidth;
                if (newItemsWidth < this.itemsWidth) {
                    this.itemsWidth = newItemsWidth + newLabelWidth - this.labelWidth;
                } else {
                    this.labelWidth = newLabelWidth;
                    this.itemsWidth = newItemsWidth;
                }
            } else {
                this.itemsWidth = pureWidth + 8;
            }
        }
        if (this.itemsWidth > 0) {
            this.createLayouts(this.itemsWidth, this.labelWidth);
        }
        return width;
    }

    private void createLayouts(int widthItems, int widthLabel) {
        if (this.itemsLayout == null || this.itemsLayout.getWidth() > widthItems) {
            this.itemsLayout = new StaticLayout((CharSequence)this.buildText(this.isScrollingPerformed), this.itemsPaint, widthItems, widthLabel > 0 ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_CENTER, 1.0f, (float)this.additionalItemHeight, false);
        } else {
            this.itemsLayout.increaseWidthTo(widthItems);
        }
        if (!(this.isScrollingPerformed || this.valueLayout != null && this.valueLayout.getWidth() <= widthItems)) {
            String text = this.getAdapter() != null ? this.getAdapter().getItem(this.currentItem) : null;
            this.valueLayout = new StaticLayout((CharSequence)(text != null ? text : ""), this.valuePaint, widthItems, widthLabel > 0 ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_CENTER, 1.0f, (float)this.additionalItemHeight, false);
        } else if (this.isScrollingPerformed) {
            this.valueLayout = null;
        } else {
            this.valueLayout.increaseWidthTo(widthItems);
        }
        if (widthLabel > 0) {
            if (this.labelLayout == null || this.labelLayout.getWidth() > widthLabel) {
                this.labelLayout = new StaticLayout((CharSequence)this.label, this.labelPaint, widthLabel, Layout.Alignment.ALIGN_NORMAL, 1.0f, (float)this.additionalItemHeight, false);
            } else {
                this.labelLayout.increaseWidthTo(widthLabel);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = this.calculateLayoutWidth(widthSize, widthMode);
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.getDesiredHeight((Layout)this.itemsLayout);
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        if (D) {
            Log.d((String)TAG, (String)("onMeasure:" + width));
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.itemsLayout == null) {
            if (this.itemsWidth == 0) {
                this.calculateLayoutWidth(this.getWidth(), 0x40000000);
            } else {
                this.createLayouts(this.itemsWidth, this.labelWidth);
            }
        }
        if (this.itemsWidth > 0) {
            canvas.save();
            canvas.translate(5.0f, (float)(-this.itemOffset));
            this.drawItems(canvas);
            this.drawValue(canvas);
            canvas.restore();
        }
        this.drawCenterRect(canvas);
        this.drawShadows(canvas);
    }

    private void drawShadows(Canvas canvas) {
        this.topShadow.setBounds(0, 0, this.getWidth(), this.getHeight() / this.visibleItems);
        this.topShadow.draw(canvas);
        this.bottomShadow.setBounds(0, this.getHeight() - this.getHeight() / this.visibleItems, this.getWidth(), this.getHeight());
        this.bottomShadow.draw(canvas);
    }

    private void drawValue(Canvas canvas) {
        this.valuePaint.setColor(this.valueTextColor);
        this.valuePaint.drawableState = this.getDrawableState();
        this.labelPaint.setColor(this.labelTextColor);
        this.labelPaint.drawableState = this.getDrawableState();
        Rect bounds = new Rect();
        this.itemsLayout.getLineBounds(this.visibleItems / 2, bounds);
        if (this.labelLayout != null) {
            canvas.save();
            canvas.translate((float)(this.itemsLayout.getWidth() + 8), (float)bounds.top);
            this.labelLayout.draw(canvas);
            canvas.restore();
        }
        if (this.valueLayout != null) {
            canvas.save();
            canvas.translate(0.0f, (float)(bounds.top + this.scrollingOffset));
            this.valueLayout.draw(canvas);
            canvas.restore();
        }
    }

    private void drawItems(Canvas canvas) {
        canvas.save();
        int top = this.itemsLayout.getLineTop(1);
        canvas.translate(0.0f, (float)(-top + this.scrollingOffset));
        this.itemsPaint.setColor(-16777216);
        this.itemsPaint.drawableState = this.getDrawableState();
        this.itemsLayout.draw(canvas);
        canvas.restore();
    }

    private void drawCenterRect(Canvas canvas) {
        int center = this.getHeight() / 2;
        int offset = this.getItemHeight() / 2;
        this.centerSelectDrawable.setBounds(0, center - offset, this.getWidth(), center + offset);
        this.centerSelectDrawable.draw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        AbWheelAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return true;
        }
        if (!this.gestureDetector.onTouchEvent(event) && event.getAction() == 1) {
            this.justify();
        }
        return true;
    }

    private void doScroll(int delta) {
        this.scrollingOffset += delta;
        int count = this.scrollingOffset / this.getItemHeight();
        int pos = this.currentItem - count;
        if (this.isCyclic && this.adapter.getItemsCount() > 0) {
            while (pos < 0) {
                pos += this.adapter.getItemsCount();
            }
            pos %= this.adapter.getItemsCount();
        } else if (this.isScrollingPerformed) {
            if (pos < 0) {
                count = this.currentItem;
                pos = 0;
            } else if (pos >= this.adapter.getItemsCount()) {
                count = this.currentItem - this.adapter.getItemsCount() + 1;
                pos = this.adapter.getItemsCount() - 1;
            }
        } else {
            pos = Math.max(pos, 0);
            pos = Math.min(pos, this.adapter.getItemsCount() - 1);
        }
        int offset = this.scrollingOffset;
        if (pos != this.currentItem) {
            this.setCurrentItem(pos, false);
        } else {
            this.invalidate();
        }
        this.scrollingOffset = offset - count * this.getItemHeight();
        if (this.scrollingOffset > this.getHeight()) {
            this.scrollingOffset = this.scrollingOffset % this.getHeight() + this.getHeight();
        }
    }

    private void setNextMessage(int message) {
        this.clearMessages();
        this.animationHandler.sendEmptyMessage(message);
    }

    private void clearMessages() {
        this.animationHandler.removeMessages(0);
        this.animationHandler.removeMessages(1);
    }

    private void justify() {
        boolean needToIncrease;
        if (this.adapter == null) {
            return;
        }
        this.lastScrollY = 0;
        int offset = this.scrollingOffset;
        int itemHeight = this.getItemHeight();
        boolean bl = offset > 0 ? this.currentItem < this.adapter.getItemsCount() : (needToIncrease = this.currentItem > 0);
        if ((this.isCyclic || needToIncrease) && Math.abs((float)offset) > (float)itemHeight / 2.0f) {
            offset = offset < 0 ? (offset += itemHeight + 1) : (offset -= itemHeight + 1);
        }
        if (Math.abs(offset) > 1) {
            this.scroller.startScroll(0, 0, 0, offset, 400);
            this.setNextMessage(1);
        } else {
            this.finishScrolling();
        }
    }

    private void startScrolling() {
        if (!this.isScrollingPerformed) {
            this.isScrollingPerformed = true;
            this.notifyScrollingListenersAboutStart();
        }
    }

    void finishScrolling() {
        if (this.isScrollingPerformed) {
            this.notifyScrollingListenersAboutEnd();
            this.isScrollingPerformed = false;
        }
        this.invalidateLayouts();
        this.invalidate();
    }

    public void scroll(int itemsToScroll, int time) {
        this.scroller.forceFinished(true);
        this.lastScrollY = this.scrollingOffset;
        int offset = itemsToScroll * this.getItemHeight();
        this.scroller.startScroll(0, this.lastScrollY, 0, offset - this.lastScrollY, time);
        this.setNextMessage(0);
        this.startScrolling();
    }

    public void setValueTextSize(int textSize) {
        this.valueTextSize = AbViewUtil.resizeTextSize(this.screenWidth, this.screenHeight, textSize);
        this.itemOffset = this.valueTextSize / 5;
    }

    public int[] getCenterSelectGradientColors() {
        return this.centerSelectGradientColors;
    }

    public void setCenterSelectGradientColors(int[] centerSelectGradientColors) {
        this.centerSelectGradientColors = centerSelectGradientColors;
    }

    public int getCenterSelectStrokeWidth() {
        return this.centerSelectStrokeWidth;
    }

    public void setCenterSelectStrokeWidth(int centerSelectStrokeWidth) {
        this.centerSelectStrokeWidth = centerSelectStrokeWidth;
    }

    public int getCenterSelectStrokeColor() {
        return this.centerSelectStrokeColor;
    }

    public void setCenterSelectStrokeColor(int centerSelectStrokeColor) {
        this.centerSelectStrokeColor = centerSelectStrokeColor;
    }

    public void setCenterSelectDrawable(Drawable centerSelectDrawable) {
        this.centerSelectDrawable = centerSelectDrawable;
    }

    public void setValueTextColor(int valueTextColor) {
        this.valueTextColor = valueTextColor;
    }

    public void setLabelTextColor(int labelTextColor) {
        this.labelTextColor = labelTextColor;
    }

    public void setLabelTextSize(int labelTextSize) {
        this.labelTextSize = AbViewUtil.resizeTextSize(this.screenWidth, this.screenHeight, labelTextSize);
    }

    public void setAdditionalItemHeight(int additionalItemHeight) {
        this.additionalItemHeight = additionalItemHeight;
    }
}

