/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

public class PSAM
extends Device {
    private static final String TAG = PSAM.class.getSimpleName();
    protected DeviceConfiguration config = DeviceConfiguration.builderRFIDConfiguration();
    private static PSAM single = null;

    private PSAM() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized PSAM getInstance() {
        if (single != null) return single;
        Class<PSAM> clazz = PSAM.class;
        synchronized (PSAM.class) {
            if (single != null) return single;
            try {
                single = new PSAM();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public boolean init() {
        int result = this.getDeviceAPI().Psam_Init(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err :" + result));
        return false;
    }

    public boolean free() {
        int result = this.getDeviceAPI().Psam_Free(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err :" + result));
        return false;
    }

    public String executeCmd(String hexCmd, String hexData) {
        if (StringUtility.isEmpty(hexCmd)) {
            return null;
        }
        char[] cmd = StringUtility.hexString2Chars(hexCmd);
        char[] data = StringUtility.hexString2Chars(hexData);
        byte[] result = this.getDeviceAPI().Psam_Cmd(this.config.getDeviceName(), cmd[0], data, data.length);
        if (result != null && result.length > 1) {
            if (result[result.length - 1] != 0) {
                Log.e((String)TAG, (String)("Psam_Cmd() err :" + result[result.length - 1]));
                return null;
            }
            return StringUtility.bytes2HexString(result, result.length - 1);
        }
        Log.e((String)TAG, (String)"Psam_Cmd() err result == null or result.length<2");
        return null;
    }

    public synchronized boolean Upgrade(int packageCount, int index, int currSize, byte[] data) {
        int result = this.getDeviceAPI().PSAM_UPDATE(packageCount, index, currSize, data);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("Upgrade() err:" + result));
        return false;
    }
}

