/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.RFIDBase;
import com.rscja.deviceapi.entity.DESFireFile;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.RFIDNotFoundException;
import com.rscja.deviceapi.exception.RFIDReadFailureException;
import com.rscja.deviceapi.exception.RFIDVerificationException;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RFIDWithISO14443A
extends RFIDBase {
    private static final String TAG = "RFIDWithISO1443A";
    private static RFIDWithISO14443A single = null;

    protected RFIDWithISO14443A() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithISO14443A getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithISO14443A> clazz = RFIDWithISO14443A.class;
        synchronized (RFIDWithISO14443A.class) {
            if (single != null) return single;
            single = new RFIDWithISO14443A();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized SimpleRFIDEntity request() {
        byte[] result = this.getDeviceAPI().ISO14443A_request(this.config.getDeviceName(), 1);
        if (result == null || result[0] != 0 || result[4] == 0) {
            Log.e((String)TAG, (String)("request() err:" + result[0]));
            return null;
        }
        byte[] bUID = new byte[result[4]];
        TagType type_sak = TagType.Unknow;
        TagType type_atqa = TagType.Unknow;
        int i = 0;
        while (i < bUID.length) {
            bUID[i] = result[i + 5];
            ++i;
        }
        byte sak = result[5 + bUID.length];
        int b3 = sak >> 2 & 1;
        int b4 = sak >> 3 & 1;
        int b5 = sak >> 4 & 1;
        int b6 = sak >> 5 & 1;
        if (result[2] == 68 && result[3] == 0) {
            byte atqa = result[result[1] + 1];
            type_atqa = atqa == 0 ? TagType.Ultra_light : TagType.Mifare_plus;
            type_sak = sak == 0 ? TagType.Ultra_light : TagType.Mifare_plus;
        } else if (result[2] == 4 && result[3] == 0) {
            if (b4 == 1 || sak == 0) {
                type_sak = TagType.S50;
            }
        } else if (result[2] == 2 && result[3] == 0) {
            if (b4 == 1 && b5 == 1 || sak == 0) {
                type_sak = TagType.S70;
            }
        } else if (result[2] == 68 && result[3] == 3) {
            if (b6 == 1 || b6 == 1 && b3 == 1 || sak == 0) {
                type_sak = TagType.Mifare_DESFire;
            }
        } else {
            type_sak = result[2] == 8 && result[3] == 0 ? TagType.Mifare_Pro : (result[2] == 4 && result[3] == 3 ? TagType.Mifare_ProX : TagType.Unknow);
        }
        String strType = "";
        strType = type_atqa != type_sak && type_atqa != TagType.Unknow ? String.valueOf(type_atqa.toString()) + " or " + type_sak.toString() : type_sak.toString();
        return new SimpleRFIDEntity(StringUtility.bytes2HexString(bUID, bUID.length), strType);
    }

    public synchronized SimpleRFIDEntity read(String key, KeyType keyType, int sector, int block) throws RFIDVerificationException, RFIDReadFailureException {
        SimpleRFIDEntity entity = this.request();
        if (entity == null) {
            return null;
        }
        if (this.VerifySector(sector, key, keyType)) {
            char[] result = this.M1_ReadData(sector, block);
            if (result != null) {
                entity.setData(StringUtility.chars2HexString(result, result.length));
            }
        } else {
            throw new RFIDVerificationException();
        }
        return entity;
    }

    public synchronized SimpleRFIDEntity readAllData(String key, TagType tagType) throws RFIDVerificationException, RFIDReadFailureException {
        SimpleRFIDEntity entity = this.request();
        if (entity == null) {
            return null;
        }
        char[] dataInBlock = this.getDeviceAPI().ISO14443A_mifareone_alldata_read(tagType.ordinal(), StringUtility.hexString2Chars(key));
        if (dataInBlock[0] != '\u0000') {
            Log.e((String)TAG, (String)("readAllData() err:" + Integer.valueOf(dataInBlock[0])));
            throw new RFIDReadFailureException();
        }
        int dataLen = 4096;
        if (tagType == TagType.S50) {
            dataLen = 1024;
        }
        char[] result = new char[dataLen];
        int i = 0;
        while (i < dataLen) {
            result[i] = dataInBlock[i + 1];
            ++i;
        }
        if (result != null) {
            entity.setData(StringUtility.chars2HexString(result, result.length));
        }
        return entity;
    }

    public synchronized SimpleRFIDEntity read(int block) throws RFIDReadFailureException {
        SimpleRFIDEntity entity = this.request();
        if (entity == null) {
            return null;
        }
        char[] result = this.ML_ReadData(block);
        if (result != null) {
            entity.setData(StringUtility.chars2HexString(result, result.length));
        }
        return entity;
    }

    public synchronized boolean write(String key, KeyType keyType, int sector, int block, String hexData) throws RFIDVerificationException, RFIDNotFoundException {
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        this.request();
        if (this.VerifySector(sector, key, keyType)) {
            return this.M1_WriteData(sector, block, hexData);
        }
        throw new RFIDVerificationException();
    }

    public synchronized boolean write(int block, String hexData) throws RFIDNotFoundException {
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        SimpleRFIDEntity entity = this.request();
        if (entity == null) {
            throw new RFIDNotFoundException();
        }
        return this.ML_WriteData(block, hexData);
    }

    private synchronized boolean VerifySector(int sector, String key, KeyType keyType) {
        int Q = 0;
        Q = sector > 31 && sector < 40 ? 128 + (sector - 32) * 16 : sector * 4;
        int ires = this.getDeviceAPI().ISO14443A_authentication(keyType.ordinal(), Q, StringUtility.hexString2Chars(key), 6);
        if (ires == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("VerifySector() err:" + ires));
        return false;
    }

    private char[] M1_ReadData(int sector, int block) throws RFIDReadFailureException {
        if (sector < 0 || sector > 40) {
            return null;
        }
        int Q = 0;
        Q = sector > 31 && sector < 40 ? 128 + (sector - 32) * 16 : sector * 4;
        char[] dataInBlock = this.getDeviceAPI().ISO14443A_read(Q + block);
        if (dataInBlock[0] != '\u0000') {
            Log.e((String)TAG, (String)("M1_ReadData() err:" + Integer.valueOf(dataInBlock[0])));
            throw new RFIDReadFailureException();
        }
        char[] result = new char[dataInBlock[1]];
        int i = 0;
        while (i < dataInBlock[1]) {
            result[i] = dataInBlock[i + 2];
            ++i;
        }
        return result;
    }

    private char[] ML_ReadData(int block) throws RFIDReadFailureException {
        char[] dataInBlock = null;
        dataInBlock = this.getDeviceAPI().ISO14443A_ul_read(block);
        if (dataInBlock[0] != '\u0000') {
            Log.e((String)TAG, (String)("M1_ReadData() err:" + dataInBlock[0]));
            throw new RFIDReadFailureException();
        }
        char[] result = new char[dataInBlock[1]];
        int i = 0;
        while (i < dataInBlock[1]) {
            result[i] = dataInBlock[i + 2];
            ++i;
        }
        return result;
    }

    private boolean M1_WriteData(int sector, int block, String hexData) {
        if (sector < 0 || sector > 40) {
            return false;
        }
        int Q = 0;
        char[] arrChar = StringUtility.hexString2Chars(hexData);
        int Len = arrChar.length > 16 ? 16 : arrChar.length;
        char[] pszData = new char[16];
        int i = 0;
        while (i < 16) {
            pszData[i] = '\u0000';
            ++i;
        }
        int j = 0;
        while (j < Len) {
            pszData[j] = arrChar[j];
            ++j;
        }
        Q = sector > 31 && sector < 40 ? 128 + (sector - 32) * 16 : sector * 4;
        int iRes = this.getDeviceAPI().ISO14443A_write(Q + block, pszData, pszData.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("M1_WriteData() err:" + iRes));
        return false;
    }

    private boolean ML_WriteData(int block, String hexData) {
        char[] arrChar = StringUtility.hexString2Chars(hexData);
        int Len = arrChar.length > 4 ? 4 : arrChar.length;
        char[] pszData = new char[4];
        int i = 0;
        while (i < 4) {
            pszData[i] = '\u0000';
            ++i;
        }
        int j = 0;
        while (j < Len) {
            pszData[j] = arrChar[j];
            ++j;
        }
        int iRes = this.getDeviceAPI().ISO14443A_ul_write(block, pszData, pszData.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("M1_WriteData() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_RatsAndPss() {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_RatPss();
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_RatsAndPss() err:" + iRes));
        return false;
    }

    public synchronized int[] DESFire_GetKeySetting() {
        char[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetKeySetting();
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_GetKeySetting() err:result==null");
            return null;
        }
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("DESFire_GetKeySetting() err:" + Character.getNumericValue(result[0])));
            return null;
        }
        int[] arr = new int[]{result[2], result[3]};
        return arr;
    }

    public synchronized boolean DESFire_ChangeKeySetting(int keySetting) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ChangeKeySetting(keySetting);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_ChangeKeySetting() err:" + iRes));
        return false;
    }

    public int getIntegerSomeBit(int resource, int mask) {
        return resource >> mask & 1;
    }

    public synchronized boolean DESFire_SelApp(String hexAppId) {
        if (StringUtility.isEmpty(hexAppId)) {
            Log.e((String)TAG, (String)"DESFire_SelApp() err:hexAppId==null");
            return false;
        }
        byte[] apps = StringUtility.hexString2Bytes(hexAppId);
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_SelApp(apps);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_SelApp() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_Auth(int keyNo, String key) {
        if (StringUtility.isEmpty(key)) {
            Log.e((String)TAG, (String)"DESFire_Auth() key==null");
            return false;
        }
        char[] arrChar = StringUtility.hexString2Chars(key);
        Log.i((String)TAG, (String)("DESFire_Auth() key:" + key));
        int i = 0;
        while (i < arrChar.length) {
            Log.i((String)TAG, (String)("DESFire_Auth() arrChar:" + Character.getNumericValue(arrChar[i])));
            ++i;
        }
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_Auth(keyNo, arrChar, arrChar.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_Auth() err:" + iRes));
        return false;
    }

    public synchronized void DESFire_selCpy(int cpyType) {
        this.getDeviceAPI().RF_ISO14443A_DESFIRE_Cpysel(cpyType);
    }

    public synchronized boolean DESFire_ChangeKey(int keyNo, String newKey) {
        if (StringUtility.isEmpty(newKey)) {
            Log.e((String)TAG, (String)"DESFire_ChangeKey() newKey==null");
            return false;
        }
        char[] arrChar = StringUtility.hexString2Chars(newKey);
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ChangeKey(keyNo, arrChar, arrChar.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_ChangeKey() err:" + iRes));
        return false;
    }

    public synchronized String[] DESFire_GetApps() {
        byte[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetApps();
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_GetApps() err:result==null");
            return null;
        }
        if (result[0] != 0) {
            Log.e((String)TAG, (String)("DESFire_GetApps() err:" + Integer.valueOf(result[0])));
            return null;
        }
        int appNum = result[2];
        String[] ids = new String[appNum];
        byte[] arrs = null;
        int i = 0;
        while (i < appNum) {
            arrs = Arrays.copyOfRange(result, 3 + i * 3, 6 + i * 3);
            ids[i] = StringUtility.bytes2HexString(arrs, arrs.length);
            ++i;
        }
        return ids;
    }

    public synchronized boolean DESFire_DelApp(String hexAppId) {
        if (StringUtility.isEmpty(hexAppId)) {
            Log.e((String)TAG, (String)"DESFire_DelApp() err:hexAppId==null");
            return false;
        }
        char[] apps = StringUtility.hexString2Chars(hexAppId);
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_DelApp(apps);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_DelApp() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_FormatCard() {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_FormatCard();
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_FormatCard() err:" + iRes));
        return false;
    }

    public synchronized String[] DESFire_GetPiccInfo() {
        char[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetPiccInfo();
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_GetPiccInfo() err:result==null");
            return null;
        }
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("DESFire_GetPiccInfo() err:" + Character.getNumericValue(result[0])));
            return null;
        }
        char len = result[1];
        Log.i((String)TAG, (String)("DESFire_GetPiccInfo() len=" + len));
        char[] data = Arrays.copyOfRange(result, 2, len + 2);
        int i = 0;
        while (i < data.length) {
            Log.i((String)TAG, (String)("DESFire_GetPiccInfo() result[" + i + "]=" + StringUtility.char2HexString(data[i])));
            ++i;
        }
        char infoLenPart1 = data[0];
        char infoLenPart2 = data[infoLenPart1 + '\u0001'];
        char infoLenPart3 = data[infoLenPart1 + infoLenPart2 + 2];
        Log.i((String)TAG, (String)("DESFire_GetPiccInfo() infoLenPart1=" + infoLenPart1 + " infoLenPart2=" + infoLenPart2 + " infoLenPart3=" + infoLenPart3));
        char[] data_1 = Arrays.copyOfRange(data, 1, infoLenPart1 + '\u0001');
        char[] data_2 = Arrays.copyOfRange(data, 2 + infoLenPart1, infoLenPart2 + infoLenPart1 + 2);
        char[] data_3 = Arrays.copyOfRange(data, 3 + infoLenPart1 + infoLenPart2, infoLenPart3 + infoLenPart1 + infoLenPart2 + 3);
        String[] infos = new String[]{StringUtility.chars2HexString(data_1, data_1.length), StringUtility.chars2HexString(data_2, data_2.length), StringUtility.chars2HexString(data_3, data_3.length)};
        Log.i((String)TAG, (String)("DESFire_GetPiccInfo() infos[0]=" + infos[0]));
        Log.i((String)TAG, (String)("DESFire_GetPiccInfo() infos[1]=" + infos[1]));
        Log.i((String)TAG, (String)("DESFire_GetPiccInfo() infos[2]=" + infos[2]));
        return infos;
    }

    public synchronized boolean DESFire_AddApp(String hexAppId, int keySetting, int fileNums) {
        if (StringUtility.isEmpty(hexAppId)) {
            Log.e((String)TAG, (String)"DESFire_AddApp() err:hexAppId==null");
            return false;
        }
        char[] appId = StringUtility.hexString2Chars(hexAppId);
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_AddApp(appId, keySetting, fileNums);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_AddApp() err:" + iRes));
        return false;
    }

    public synchronized int[] DESFire_GetFileIds() {
        byte[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetFileIds();
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_GetFileIds() err:result==null");
            return null;
        }
        if (result[0] != 0) {
            Log.e((String)TAG, (String)("DESFire_GetFileIds() err:" + result[0]));
            return null;
        }
        int[] ids = new int[result[2]];
        int i = 0;
        while (i < ids.length) {
            ids[i] = result[i + 3];
            ++i;
        }
        return ids;
    }

    public synchronized List<DESFireFile> DESFire_GetFiles() {
        int[] ids = this.DESFire_GetFileIds();
        if (ids == null) {
            Log.e((String)TAG, (String)"DESFire_GetFiles() ids==null");
            return null;
        }
        ArrayList<DESFireFile> lst = new ArrayList<DESFireFile>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            DESFireFile file;
            int id = nArray[n2];
            String readPermissions = null;
            String writePermissions = null;
            String readWritePermissions = null;
            String updataPermissions = null;
            String temp1 = null;
            String temp2 = null;
            int fileSize = 0;
            byte[] tempByte = null;
            int minValue = 0;
            int maxValue = 0;
            byte[] setting = this.DESFire_GetFileSetting(id);
            if (setting == null) {
                file = new DESFireFile(id, DESFireFileTypekEnum.Unknown, DESFireEncryptionTypekEnum.Unknown, null, null, null, null);
            } else {
                DESFireEncryptionTypekEnum encryptionType;
                DESFireFileTypekEnum fileType;
                Log.i((String)TAG, (String)("DESFire_GetFiles() setting[0]=" + setting[0]));
                switch (setting[0]) {
                    case 0: {
                        fileType = DESFireFileTypekEnum.StandardDataFile;
                        break;
                    }
                    case 1: {
                        fileType = DESFireFileTypekEnum.BackupDataFile;
                        break;
                    }
                    case 2: {
                        fileType = DESFireFileTypekEnum.ValueFile;
                        break;
                    }
                    case 3: {
                        fileType = DESFireFileTypekEnum.LinearRecordFile;
                        break;
                    }
                    case 4: {
                        fileType = DESFireFileTypekEnum.CyclicRecordFile;
                        break;
                    }
                    default: {
                        fileType = DESFireFileTypekEnum.Unknown;
                    }
                }
                switch (setting[1]) {
                    case 0: {
                        encryptionType = DESFireEncryptionTypekEnum.Transparent;
                        break;
                    }
                    case 3: {
                        encryptionType = DESFireEncryptionTypekEnum.DES;
                        break;
                    }
                    default: {
                        encryptionType = DESFireEncryptionTypekEnum.Unknown;
                    }
                }
                temp1 = StringUtility.byte2HexString(setting[2]);
                temp2 = StringUtility.byte2HexString(setting[3]);
                readWritePermissions = temp1.substring(0, 1);
                updataPermissions = temp1.substring(1, 2);
                readPermissions = temp2.substring(0, 1);
                writePermissions = temp2.substring(1, 2);
                file = new DESFireFile(id, fileType, encryptionType, readPermissions, writePermissions, readWritePermissions, updataPermissions);
                if (fileType == DESFireFileTypekEnum.StandardDataFile || fileType == DESFireFileTypekEnum.BackupDataFile) {
                    byte[] byArray = new byte[4];
                    byArray[0] = setting[4];
                    byArray[1] = setting[5];
                    byArray[2] = setting[6];
                    tempByte = byArray;
                    fileSize = StringUtility.bytesToInt(tempByte);
                    file.setFileSize(fileSize);
                } else if (fileType == DESFireFileTypekEnum.ValueFile) {
                    tempByte = new byte[]{setting[4], setting[5], setting[6], setting[7]};
                    minValue = StringUtility.bytesToInt(tempByte);
                    tempByte = new byte[]{setting[8], setting[9], setting[10], setting[11]};
                    maxValue = StringUtility.bytesToInt(tempByte);
                    file.setMaxValue(maxValue);
                    file.setMinValue(minValue);
                }
            }
            lst.add(file);
            ++n2;
        }
        return lst;
    }

    public synchronized byte[] DESFire_GetFileSetting(int fileNo) {
        byte[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetFileSetting(fileNo);
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_GetFileSetting() err:result==null");
            return null;
        }
        if (result[0] != 0) {
            Log.e((String)TAG, (String)("DESFire_GetFileSetting() err:" + result[0]));
            return null;
        }
        byte[] ids = new byte[result[1]];
        int i = 0;
        while (i < ids.length) {
            ids[i] = result[i + 2];
            Log.i((String)TAG, (String)("DESFire_GetFileSetting() ids[i]=" + ids[i]));
            ++i;
        }
        return ids;
    }

    public synchronized boolean DESFire_ChangeFileSetting(int fileNo, int commSet, char[] accessRights) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ChangeFileSetting(fileNo, commSet, accessRights);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_ChangeFileSetting() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_DelFile(int fileNo) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_DelFile(fileNo);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_DelFile() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_AddStdFile(int fileNo, int commSet, char[] accessRight, int fileSize) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_AddStdFile(fileNo, commSet, accessRight, fileSize);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_AddStdFile() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_WriteStdFile(int fileNo, int offSet, int dataSize, char[] dataBuf) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_WriteStdFile(fileNo, offSet, dataSize, dataBuf);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_WriteStdFile() err:" + iRes));
        return false;
    }

    public synchronized char[] DESFire_ReadStdFile(int fileNo, int offSet, int dataSize) {
        char[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ReadStdFile(fileNo, offSet, dataSize);
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_ReadStdFile() err:result==null");
            return null;
        }
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("DESFire_ReadStdFile() err:" + Character.getNumericValue(result[0])));
            return null;
        }
        char[] data = new char[dataSize];
        data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return data;
    }

    public synchronized boolean DESFire_AddValueFile(int fileNo, int commSet, char[] accessRights, int minValue, int maxValue, int initValue) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_AddValueFile(fileNo, commSet, accessRights, minValue, maxValue, initValue);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_AddValueFile() err:" + iRes));
        return false;
    }

    public synchronized int[] DESFire_ReadValueFile(int fileNo) {
        int[] result = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetValueFile(fileNo);
        if (result == null) {
            Log.e((String)TAG, (String)"DESFire_ReadValueFile() err:result==null");
            return null;
        }
        if (result[0] != 0) {
            Log.e((String)TAG, (String)("DESFire_ReadValueFile() err:" + Character.getNumericValue(result[0])));
            return null;
        }
        int[] data = new int[]{result[2]};
        return data;
    }

    public synchronized boolean DESFire_CreditValueFile(int fileNo, int value) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_CreditValueFile(fileNo, value);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_CreditValueFile() err:" + iRes));
        return false;
    }

    public synchronized boolean DESFire_DebitValueFile(int fileNo, int value) {
        int iRes = this.getDeviceAPI().RF_ISO14443A_DESFIRE_DebitValueFile(fileNo, value);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("DESFire_DebitValueFile() err:" + iRes));
        return false;
    }

    public static /* bridge */ /* synthetic */ RFIDBase getInstance() throws ConfigurationException {
        return RFIDWithISO14443A.getInstance();
    }

    public static enum DESFireEncryptionTypekEnum {
        Unknown(0),
        Transparent(1),
        DES(2);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private DESFireEncryptionTypekEnum(byte value) {
            this.value = value;
        }
    }

    public static enum DESFireFileTypekEnum {
        Unknown(0),
        StandardDataFile(1),
        BackupDataFile(2),
        ValueFile(3),
        LinearRecordFile(4),
        CyclicRecordFile(5);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private DESFireFileTypekEnum(byte value) {
            this.value = value;
        }
    }

    public static enum KeyType {
        TypeA,
        TypeB,
        TypeDes;

    }

    public static enum TagType {
        Ultra_light,
        S50,
        S70,
        Mifare_DESFire,
        Mifare_Pro,
        Mifare_ProX,
        Mifare_plus,
        Mifare_plus_4k,
        Mifare_plus_2k,
        Mifare_Mini,
        Unknow;

    }
}

