/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.UHFApi;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

@Deprecated
class UHFWithRLM {
    private static final String TAG = "UhfWithRLM";
    private static final byte POWER_ON = 1;
    private static final byte POWER_OFF = 0;
    private int flag_com = -1;
    private UHFCrcFlagEnum mFlagCrc;
    private static UHFWithRLM single = null;
    protected DeviceConfiguration config = DeviceConfiguration.builderUHFConfiguration();

    public static synchronized UHFWithRLM getInstance() throws ConfigurationException {
        if (single == null) {
            single = new UHFWithRLM();
        }
        return single;
    }

    private UHFWithRLM() throws ConfigurationException {
    }

    public synchronized boolean open(UHFCrcFlagEnum flagCrc) {
        this.mFlagCrc = flagCrc;
        if (UHFApi.UhfSelDev(this.config.getDeviceName(), 1)) {
            this.flag_com = UHFApi.UhfReaderConnect(this.config.getUart(), this.config.getBaudrate(), flagCrc.value);
            if (this.flag_com != -1) {
                this.setPower(24);
                return true;
            }
        }
        return false;
    }

    public synchronized boolean close() {
        if (UHFApi.UhfReaderDisconnect(this.flag_com, this.mFlagCrc.value)) {
            this.flag_com = -1;
            return UHFApi.UhfSelDev(this.config.getDeviceName(), 0);
        }
        return false;
    }

    public String convertUiiToEPC(String uii) {
        if (StringUtility.isEmpty(uii)) {
            return "";
        }
        String sUii = uii.replace("-", "").toUpperCase();
        sUii = sUii.substring(4, sUii.length());
        return sUii;
    }

    public synchronized String inventorySingleTag() {
        byte[] bLenUii = new byte[1];
        byte[] bUii = new byte[255];
        if (!UHFApi.UhfInventorySingleTag(this.flag_com, bLenUii, bUii, this.mFlagCrc.value)) {
            return null;
        }
        if (bLenUii[0] == 0) {
            return null;
        }
        return StringUtility.bytes2HexString(bUii, bLenUii[0]);
    }

    public synchronized boolean startInventory(byte flagAnti, byte initQ) {
        return UHFApi.UhfStartInventory(this.flag_com, flagAnti, initQ, this.mFlagCrc.value);
    }

    public synchronized String readInventory() {
        byte[] bLenUii = new byte[1];
        byte[] bUii = new byte[255];
        if (!UHFApi.UhfReadInventory(this.flag_com, bLenUii, bUii)) {
            return null;
        }
        if (bLenUii[0] == 0) {
            return null;
        }
        return StringUtility.bytes2HexString(bUii, bLenUii[0]);
    }

    public synchronized boolean stopOperation() {
        return UHFApi.UhfStopOperation(this.flag_com, this.mFlagCrc.value);
    }

    public synchronized String readDataByEPC(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bEpc = StringUtility.hexString2Bytes(uii);
        byte[] bReadData = new byte[255];
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        if (UHFApi.UhfReadDataByEPC(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bEpc, bReadData, bErrorCode, this.mFlagCrc.value)) {
            return StringUtility.bytes2HexString(bReadData, cnt * 2);
        }
        Log.e((String)TAG, (String)("readDataByEPC() err:" + bErrorCode[0]));
        return null;
    }

    public synchronized boolean getPaStatus() {
        byte[] status = new byte[1];
        return UHFApi.UhfGetPaStatus(this.flag_com, status, this.mFlagCrc.value);
    }

    public synchronized int getPower() {
        byte[] power = new byte[1];
        if (UHFApi.UhfGetPower(this.flag_com, power, this.mFlagCrc.value)) {
            return power[0] & 0x7F;
        }
        return -1;
    }

    public synchronized boolean setPower(int power) {
        if (power > 24) {
            power = 24;
        }
        return UHFApi.UhfSetPower(this.flag_com, (byte)1, (byte)power, this.mFlagCrc.value);
    }

    public synchronized String getFrequency() {
        byte[] bFreMode = new byte[1];
        byte[] bFreBase = new byte[1];
        byte[] bBaseFre = new byte[2];
        byte[] bChannNum = new byte[1];
        byte[] bChannSpc = new byte[1];
        byte[] bFreHop = new byte[1];
        String freStr = null;
        if (UHFApi.UhfGetFrequency(this.flag_com, bFreMode, bFreBase, bBaseFre, bChannNum, bChannSpc, bFreHop, this.mFlagCrc.value)) {
            int iFreBase0 = bBaseFre[0] & 0xFF;
            int iFreBase1 = bBaseFre[1] & 0xFF;
            int freI = (iFreBase0 << 3) + (iFreBase1 >> 5);
            int freD = 0;
            int eFreD = 0;
            int eFreI = 0;
            if (bFreBase[0] == 0) {
                freD = (iFreBase1 & 0x1F) * 50;
                eFreD = (freD + bChannSpc[0] * 50 * (bChannNum[0] - 1)) % 1000;
                eFreI = freI + (freD + bChannSpc[0] * 50 * (bChannNum[0] - 1)) / 1000;
            } else {
                freD = (iFreBase1 & 0x1F) * 125;
                eFreD = (freD + bChannSpc[0] * 125 * (bChannNum[0] - 1)) % 1000;
                eFreI = freI + (freD + bChannSpc[0] * 125 * (bChannNum[0] - 1)) / 1000;
            }
            freStr = String.valueOf(String.valueOf(freI)) + "." + String.valueOf(freD) + "~" + String.valueOf(eFreI) + "." + String.valueOf(eFreD) + "MHz";
        }
        return freStr;
    }

    public synchronized boolean setFrequency(byte uFreMode, byte uFreBase, byte[] uBaseFre, byte uChannNum, byte uChannSpc, byte uFreHop) {
        return UHFApi.UhfSetFrequency(this.flag_com, uFreMode, uFreBase, uBaseFre, uChannNum, uChannSpc, uFreHop, this.mFlagCrc.value);
    }

    public synchronized String getReaderUID() {
        byte[] bUid = new byte[12];
        String uidStr = null;
        if (UHFApi.UhfGetReaderUID(this.flag_com, bUid, this.mFlagCrc.value)) {
            uidStr = StringUtility.bytes2HexString(bUid, bUid.length);
        }
        return uidStr;
    }

    public synchronized boolean writeDataByEPC(String accessPwd, BankEnum bank, int ptr, String data, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii) || StringUtility.isEmpty(data)) {
            return false;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bEpc = StringUtility.hexString2Bytes(uii);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        byte[] bData = StringUtility.hexString2Bytes(data);
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        if (UHFApi.UhfWriteDataByEPC(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)1, bEpc, bData, bErrorCode, this.mFlagCrc.value)) {
            return true;
        }
        Log.e((String)TAG, (String)("writeDataByEPC() err:" + bErrorCode[0]));
        return false;
    }

    public synchronized boolean eraseDataByEPC(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bEpc = StringUtility.hexString2Bytes(uii);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        if (UHFApi.UhfEraseDataByEPC(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bEpc, bErrorCode, this.mFlagCrc.value)) {
            return true;
        }
        Log.e((String)TAG, (String)("eraseDataByEPC() err:" + bErrorCode[0]));
        return false;
    }

    public synchronized boolean lockMemByEPC(String accessPwd, String lockCode, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bEpc = StringUtility.hexString2Bytes(uii);
        byte[] bErrorCode = new byte[1];
        byte[] bLockData = StringUtility.hexString2Bytes(lockCode);
        if (UHFApi.UhfLockMemByEPC(this.flag_com, bAccessPwd, bLockData, bEpc, bErrorCode, this.mFlagCrc.value)) {
            return true;
        }
        Log.e((String)TAG, (String)("lockMemByEPC() err:" + bErrorCode[0]));
        return false;
    }

    public synchronized String generateLockCode(LockModeEnum killPwd, LockModeEnum accessPwd, LockModeEnum uii, LockModeEnum tid, LockModeEnum user) {
        byte bkill = killPwd.value;
        byte baccess = accessPwd.value;
        byte buii = uii.value;
        byte btid = tid.value;
        byte buser = user.value;
        byte[] LockCode = new byte[]{0, 0, 0};
        if (bkill == 1) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 2);
        } else if (bkill == 2) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 0);
        } else if (bkill == 3) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 3);
        } else if (bkill == 4) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 1);
        } else {
            LockCode[0] = (byte)(LockCode[0] & 3);
            LockCode[1] = (byte)(LockCode[1] & 0xFC);
        }
        if (baccess == 1) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0x80);
        } else if (baccess == 2) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (baccess == 3) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0xC0);
        } else if (baccess == 4) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0x40);
        } else {
            LockCode[0] = (byte)(LockCode[0] & 0xC);
            LockCode[2] = (byte)(LockCode[2] & 0x3F);
        }
        if (buii == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x20);
        } else if (buii == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (buii == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x30);
        } else if (buii == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x10);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0x3F);
            LockCode[2] = (byte)(LockCode[2] & 0xCF);
        }
        if (btid == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 8);
        } else if (btid == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (btid == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 0xC);
        } else if (btid == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 4);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0xCF);
            LockCode[2] = (byte)(LockCode[2] & 0xF3);
        }
        if (buser == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 2);
        } else if (buser == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (buser == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 3);
        } else if (buser == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 1);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0xF3);
            LockCode[2] = (byte)(LockCode[2] & 0xFC);
        }
        return StringUtility.bytes2HexString(LockCode, LockCode.length);
    }

    public synchronized boolean killTagByEPC(String killPwd, String uii) {
        byte[] bEpc;
        if (StringUtility.isEmpty(killPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        byte[] bErrorCode = new byte[1];
        byte[] bKillPwd = StringUtility.hexString2Bytes(killPwd);
        if (UHFApi.UhfKillTagByEPC(this.flag_com, bKillPwd, bEpc = StringUtility.hexString2Bytes(uii), bErrorCode, this.mFlagCrc.value)) {
            return true;
        }
        Log.e((String)TAG, (String)("killTagByEPC() err:" + bErrorCode[0]));
        return false;
    }

    public synchronized String getHardwareSerialNumber() {
        byte[] bSerial = new byte[6];
        byte[] bVersion = new byte[3];
        String str = null;
        if (UHFApi.UhfGetVersion(this.flag_com, bSerial, bVersion, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bSerial, bSerial.length);
        }
        return str;
    }

    public synchronized String getSoftwareVersion() {
        byte[] bSerial = new byte[6];
        byte[] bVersion = new byte[3];
        String str = null;
        if (UHFApi.UhfGetVersion(this.flag_com, bSerial, bVersion, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bVersion, bVersion.length);
        }
        return str;
    }

    public synchronized SimpleRFIDEntity readDataFromSingleTag(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        SimpleRFIDEntity entity = null;
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bReadData = new byte[255];
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        byte[] bLenUii = new byte[1];
        byte[] bUii = new byte[255];
        if (UHFApi.UhfReadDataFromSingleTag(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bReadData, bUii, bLenUii, bErrorCode, this.mFlagCrc.value)) {
            entity = new SimpleRFIDEntity(StringUtility.bytes2HexString(bUii, bLenUii[0]), "UHF");
            entity.setData(StringUtility.bytes2HexString(bReadData, cnt * 2));
        }
        Log.e((String)TAG, (String)("readDataFromSingleTag() err:" + bErrorCode[0]));
        return entity;
    }

    public synchronized String writeDataToSingleTag(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bWriteData = StringUtility.hexString2Bytes(data);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        byte[] bLenUii = new byte[1];
        byte[] bUii = new byte[255];
        String strUii = null;
        if (UHFApi.UhfWriteDataToSingleTag(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bWriteData, bUii, bLenUii, bErrorCode, this.mFlagCrc.value)) {
            strUii = StringUtility.bytes2HexString(bUii, bLenUii[0]);
        }
        Log.e((String)TAG, (String)("writeDataToSingleTag() err:" + bErrorCode[0]));
        return strUii;
    }

    public synchronized boolean blockWriteDataByEPC(String accessPwd, BankEnum bank, int ptr, int cnt, String data, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data) || StringUtility.isEmpty(uii)) {
            return false;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bEPC = StringUtility.hexString2Bytes(uii);
        byte[] bWriteData = StringUtility.hexString2Bytes(data);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        byte[] bStatus = new byte[1];
        byte[] bWritedLen = new byte[1];
        byte[] bUii = new byte[255];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        if (UHFApi.UhfBlockWriteDataByEPC(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bEPC, bWriteData, bErrorCode, bStatus, bWritedLen, bUii, this.mFlagCrc.value)) {
            return true;
        }
        Log.e((String)TAG, (String)("blockWriteDataByEPC() err:" + bErrorCode[0]));
        return false;
    }

    public synchronized String readMaxDataByEPC(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bEPC = StringUtility.hexString2Bytes(uii);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        byte[] bReadLen = new byte[1];
        byte[] bReadData = new byte[255];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        String str = null;
        if (UHFApi.UhfReadMaxDataByEPC(this.flag_com, bAccessPwd, bank.value, bPtr, bEPC, bReadLen, bReadData, bErrorCode, this.mFlagCrc.value)) {
            return StringUtility.bytes2HexString(bReadData, bReadLen[0]);
        }
        Log.e((String)TAG, (String)("readMaxDataByEPC() err:" + bErrorCode[0]));
        return str;
    }

    public synchronized SimpleRFIDEntity readMaxDataFromSingleTag(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        byte[] bReadLen = new byte[1];
        byte[] bReadData = new byte[255];
        byte[] bLenUii = new byte[1];
        byte[] bUii = new byte[255];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        SimpleRFIDEntity entity = null;
        if (UHFApi.UhfReadMaxDataFromSingleTag(this.flag_com, bAccessPwd, bank.value, bPtr, bReadLen, bReadData, bUii, bLenUii, bErrorCode, this.mFlagCrc.value)) {
            entity = new SimpleRFIDEntity(StringUtility.bytes2HexString(bUii, bLenUii[0]), "UHF");
            entity.setData(StringUtility.bytes2HexString(bReadData, bReadData.length));
            return entity;
        }
        Log.e((String)TAG, (String)("readMaxDataFromSingleTag() err:" + bErrorCode[0]));
        return null;
    }

    public synchronized String eraseDataFromSingleTag(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        byte[] bUii = new byte[255];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        String str = null;
        if (UHFApi.UhfEraseDataFromSingleTag(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bUii, bErrorCode, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bUii, ((bUii[0] >> 3) + 1) * 2);
        } else {
            Log.e((String)TAG, (String)("eraseDataFromSingleTag() err:" + bErrorCode[0]));
        }
        return str;
    }

    public synchronized String lockMemFromSingleTag(String accessPwd, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bErrorCode = new byte[1];
        byte[] bLockData = StringUtility.hexString2Bytes(lockCode);
        byte[] bUii = new byte[255];
        String str = null;
        if (UHFApi.UhfLockMemFromSingleTag(this.flag_com, bAccessPwd, bLockData, bUii, bErrorCode, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bUii, ((bUii[0] >> 3) + 1) * 2);
        } else {
            Log.e((String)TAG, (String)("lockMemFromSingleTag() err:" + bErrorCode[0]));
        }
        return str;
    }

    public synchronized String killSingleTag(String killPwd) {
        if (StringUtility.isEmpty(killPwd)) {
            return null;
        }
        byte[] bErrorCode = new byte[1];
        byte[] bUii = new byte[255];
        byte[] bKillPwd = StringUtility.hexString2Bytes(killPwd);
        String str = null;
        if (UHFApi.UhfKillSingleTag(this.flag_com, bKillPwd, bUii, bErrorCode, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bUii, ((bUii[0] >> 3) + 1) * 2);
        } else {
            Log.e((String)TAG, (String)("killSingleTag() err:" + bErrorCode[0]));
        }
        return str;
    }

    public synchronized String blockWriteDataToSingleTag(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bWriteData = StringUtility.hexString2Bytes(data);
        byte[] bErrorCode = new byte[1];
        byte[] bPtr = new byte[2];
        byte[] bStatus = new byte[1];
        byte[] bWritedLen = new byte[1];
        byte[] bUii = new byte[255];
        byte[] bUiiLen = new byte[1];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        String str = null;
        if (UHFApi.UhfBlockWriteDataToSingleTag(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bWriteData, bUii, bUiiLen, bStatus, bErrorCode, bWritedLen, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bUii, bUiiLen[0]);
        } else {
            Log.e((String)TAG, (String)("blockWriteDataToSingleTag() err:" + bErrorCode[0]));
        }
        return str;
    }

    public synchronized boolean startReadDataFromMultiTag(String accessPwd, BankEnum bank, int ptr, int cnt, int option) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bPtr = new byte[2];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        byte bOption = 0;
        byte[] bPayLoad = null;
        if (option == 1) {
            bOption = 0;
            bPayLoad = new byte[]{3, 32};
        } else if (option == 2) {
            bOption = 1;
            bPayLoad = new byte[6];
            if ((bPtr[0] & 0x80) == 128) {
                bPayLoad = new byte[6];
                bPayLoad[0] = bank.value;
                bPayLoad[1] = bPtr[0];
                bPayLoad[3] = bPtr[1];
                bPayLoad[2] = (byte)cnt;
                bPayLoad[4] = 3;
                bPayLoad[5] = 32;
            } else {
                bPayLoad = new byte[]{bank.value, bPtr[0], (byte)cnt, 3, 32};
            }
        }
        return UHFApi.UhfStartReadDataFromMultiTag(this.flag_com, bAccessPwd, bank.value, bPtr, (byte)cnt, bOption, bPayLoad, this.mFlagCrc.value);
    }

    public synchronized boolean getDataFromMultiTag(byte[] uStatus, byte[] ufData_len, byte[] ufReadData, byte[] usData_len, byte[] usReadData, byte[] uUii, byte[] uLenUii) {
        return UHFApi.UhfGetDataFromMultiTag(this.flag_com, uStatus, ufData_len, ufReadData, usData_len, usReadData, uUii, uLenUii);
    }

    public synchronized String getRegister(int RADD, int RLEN) {
        byte[] bStatus = new byte[1];
        byte[] bReadData = new byte[1];
        String str = null;
        if (UHFApi.UhfGetRegister(this.flag_com, RADD, RLEN, bStatus, bReadData, this.mFlagCrc.value)) {
            str = StringUtility.byte2HexString(bReadData[0]);
        }
        return str;
    }

    public synchronized boolean setRegister(int RADD, int RLEN, String data) {
        byte[] bStatus = new byte[1];
        byte[] bData = StringUtility.hexString2Bytes(data);
        return UHFApi.UhfSetRegister(this.flag_com, RADD, RLEN, bData, bStatus, this.mFlagCrc.value);
    }

    public synchronized boolean resetRegister() {
        return UHFApi.UhfResetRegister(this.flag_com, this.mFlagCrc.value);
    }

    public synchronized boolean saveRegister() {
        return UHFApi.UhfSaveRegister(this.flag_com, this.mFlagCrc.value);
    }

    public synchronized boolean enterSleepMode() {
        return UHFApi.UhfEnterSleepMode(this.flag_com, this.mFlagCrc.value);
    }

    public synchronized byte[] updateInit() {
        byte[] RN32 = new byte[4];
        byte[] bStatus = new byte[1];
        byte[] bResult = null;
        if (UHFApi.UhfUpdateInit(this.config.getUart(), this.config.getBaudrate(), bStatus, RN32, this.mFlagCrc.value) == 1) {
            bResult = RN32;
        }
        return bResult;
    }

    public synchronized boolean updateSendRN32(byte[] RN32) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfUpdateSendRN32(this.flag_com, RN32, bStatus, this.mFlagCrc.value);
    }

    public synchronized boolean updateSendSize(byte[] FILESIZE) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfUpdateSendSize(this.flag_com, bStatus, FILESIZE, this.mFlagCrc.value);
    }

    public synchronized boolean updateSendData(byte PACKNUM, byte LASTPACK, int Data_len, byte[] TRANDATA) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfUpdateSendData(this.flag_com, bStatus, PACKNUM, LASTPACK, Data_len, TRANDATA, this.mFlagCrc.value);
    }

    public synchronized boolean updateCommit() {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfUpdateCommit(this.flag_com, bStatus, this.mFlagCrc.value);
    }

    public synchronized String blockWriteEPCToSingleTag(String accessPwd, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bWriteData = StringUtility.hexString2Bytes(data);
        byte[] bErrorCode = new byte[1];
        byte[] bStatus = new byte[1];
        byte[] bWritedLen = new byte[1];
        byte[] bUii = new byte[255];
        byte[] bUiiLen = new byte[1];
        String str = null;
        if (UHFApi.UhfBlockWriteEPCToSingleTag(this.flag_com, bAccessPwd, (byte)cnt, bWriteData, bUii, bUiiLen, bStatus, bErrorCode, bWritedLen, this.mFlagCrc.value)) {
            str = StringUtility.bytes2HexString(bUii, bUiiLen[0]);
        } else {
            Log.e((String)TAG, (String)("blockWriteEPCToSingleTag() err:" + bErrorCode[0]));
        }
        return str;
    }

    public synchronized boolean blockWriteEPCByEPC(String accessPwd, int cnt, String data, String uii) {
        byte[] bUii;
        byte[] bWritedLen;
        byte[] bStatus;
        byte[] bErrorCode;
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        byte[] bAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] bWriteData = StringUtility.hexString2Bytes(data);
        byte[] bEPC = StringUtility.hexString2Bytes(uii);
        if (UHFApi.UhfBlockWriteEPCByEPC(this.flag_com, bAccessPwd, (byte)cnt, bEPC, bWriteData, bErrorCode = new byte[1], bStatus = new byte[1], bWritedLen = new byte[1], bUii = new byte[255], this.mFlagCrc.value)) {
            return true;
        }
        Log.e((String)TAG, (String)("blockWriteEPCByEPC() err:" + bErrorCode[0]));
        return false;
    }

    public synchronized boolean addFilter(int index, BankEnum bank, int ptr, String mask) {
        if (StringUtility.isEmpty(mask)) {
            return false;
        }
        byte[] bMask = StringUtility.hexString2Bytes(mask);
        byte[] bStatus = new byte[1];
        byte[] bPtr = new byte[2];
        if (ptr > 127) {
            bPtr[0] = (byte)(ptr >> 7 | 0x80);
            bPtr[1] = (byte)(ptr & 0x7F);
        } else {
            bPtr[0] = (byte)ptr;
        }
        return UHFApi.UhfAddFilter(this.flag_com, (byte)index, (byte)0, (byte)4, bank.value, bPtr, bMask, (byte)0, bStatus, this.mFlagCrc.value);
    }

    public synchronized boolean deleteFilterByIndex(int index) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfDeleteFilterByIndex(this.flag_com, (byte)index, bStatus, this.mFlagCrc.value);
    }

    public synchronized boolean startGetFilterByIndex(int index, int num) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfStartGetFilterByIndex(this.flag_com, (byte)index, (byte)num, bStatus, this.mFlagCrc.value);
    }

    public synchronized boolean readFilterByIndex(byte[] Sindex, byte[] Slen, byte[] Target, byte[] Action, byte[] bank, byte[] Ptr, byte[] Len, byte[] Mask, byte[] Truncate) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfReadFilterByIndex(this.flag_com, bStatus, Sindex, Slen, Target, Action, bank, Ptr, Len, Mask, Truncate);
    }

    public synchronized boolean selectFilterByIndex(int index, int num) {
        byte[] bStatus = new byte[1];
        return UHFApi.UhfSelectFilterByIndex(this.flag_com, (byte)index, (byte)num, bStatus, this.mFlagCrc.value);
    }

    public static enum BankEnum {
        RESERVED(0),
        UII(1),
        TID(2),
        USER(3);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private BankEnum(byte value) {
            this.value = value;
        }
    }

    public static enum LockModeEnum {
        HOLD(0),
        LOCK(1),
        UNLOCK(2),
        PLOCK(3),
        PUNLOCK(4);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private LockModeEnum(byte value) {
            this.value = value;
        }
    }

    public static enum UHFCrcFlagEnum {
        NONUSE(0),
        USE(1);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private UHFCrcFlagEnum(byte value) {
            this.value = value;
        }
    }
}

