/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.adc.decoder;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import com.rscja.deviceapi.ScanerLedLight;
import com.zebra.adc.decoder.BarCodeReader;
import java.io.IOException;

public class Barcode2DWithSoft {
    private static final String TAG = Barcode2DWithSoft.class.getSimpleName();
    private BarCodeReader bcr = null;
    private static Barcode2DWithSoft single;

    static {
        System.loadLibrary("IAL");
        System.loadLibrary("SDL");
        if (Build.VERSION.SDK_INT >= 19) {
            System.loadLibrary("barcodereader44");
        } else if (Build.VERSION.SDK_INT >= 18) {
            System.loadLibrary("barcodereader43");
        } else {
            System.loadLibrary("barcodereader");
        }
        single = null;
    }

    private Barcode2DWithSoft() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Barcode2DWithSoft getInstance() {
        if (single != null) return single;
        Class<Barcode2DWithSoft> clazz = Barcode2DWithSoft.class;
        synchronized (Barcode2DWithSoft.class) {
            if (single != null) return single;
            single = new Barcode2DWithSoft();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean open(Context context) {
        block8: {
            block7: {
                try {
                    if (Build.VERSION.SDK_INT < 21) break block7;
                    int mScannerId = Barcode2DWithSoft.getScannerIdFromCamera2(context);
                    try {
                        this.bcr = BarCodeReader.open(mScannerId, context);
                        break block8;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            this.bcr = Build.VERSION.SDK_INT >= 18 ? BarCodeReader.open(context) : BarCodeReader.open();
        }
        if (this.bcr == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.bcr.setParameter(765, 0);
        }
        Log.i((String)TAG, (String)"open() succ");
        ScanerLedLight.getInstance().init();
        return true;
    }

    public static int getScannerIdFromCamera(Context context) {
        int n = 0;
        try {
            n = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)"getScannerIdFromCamera", (String)("all bcr Number=" + n));
        int scannerid = -1;
        boolean isScanner = false;
        String scannerParameters = "picture-size-values=752x480,720x480,640x480,352x288,320x240,176x144,160x120;preferred-preview-size-for-video=752x480;preview-size=752x480;preview-size-values=752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;raw-size=752x480;supported-live-snapshot-sizes=752x480,720x480,640x480,352x288,320x240,176x144,160x120;video-size=752x480;video-size-values=752x480,720x480,640x480,480x360,352x288,320x240,176x144,160x120";
        BarCodeReader.Parameters scannerPar = null;
        BarCodeReader bcr = null;
        int i = 0;
        while (i < n) {
            try {
                bcr = BarCodeReader.open(i, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bcr != null) {
                if (scannerPar == null) {
                    scannerPar = bcr.getParametersFromString(scannerParameters);
                }
                BarCodeReader.Parameters bcrPar = bcr.getParameters();
                boolean bl = isScanner = scannerPar.get("picture-size-values").equals(bcrPar.get("picture-size-values")) && scannerPar.get("preferred-preview-size-for-video").equals(bcrPar.get("preferred-preview-size-for-video")) && scannerPar.get("preview-size").equals(bcrPar.get("preview-size")) && scannerPar.get("preview-size-values").equals(bcrPar.get("preview-size-values")) && scannerPar.get("raw-size").equals(bcrPar.get("raw-size")) && scannerPar.get("supported-live-snapshot-sizes").equals(bcrPar.get("supported-live-snapshot-sizes")) && scannerPar.get("video-size").equals(bcrPar.get("video-size")) && scannerPar.get("video-size-values").equals(bcrPar.get("video-size-values"));
                if (isScanner) {
                    scannerid = i;
                }
                bcr.release();
            }
            ++i;
        }
        Log.d((String)"getScannerIdFromCamera", (String)(" scannerid=" + scannerid));
        return scannerid;
    }

    public static int getScannerIdFromCamera2(Context context) {
        int n = 0;
        try {
            n = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)"getScannerIdFromCamera2", (String)("all bcr Number=" + n));
        int scannerid = -1;
        boolean isScanner = false;
        String scannerParameters = "picture-size-values=752x480,720x480,640x480,352x288,320x240,176x144,160x120;preferred-preview-size-for-video=752x480;preview-size=752x480;preview-size-values=752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;raw-size=752x480;supported-live-snapshot-sizes=752x480,720x480,640x480,352x288,320x240,176x144,160x120;video-size=752x480;video-size-values=752x480,720x480,640x480,480x360,352x288,320x240,176x144,160x120";
        BarCodeReader.Parameters scannerPar = null;
        BarCodeReader bcr = null;
        int i = n - 1;
        while (i > -1) {
            try {
                bcr = BarCodeReader.open(i, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bcr != null) {
                if (scannerPar == null) {
                    scannerPar = bcr.getParametersFromString(scannerParameters);
                }
                BarCodeReader.Parameters bcrPar = bcr.getParameters();
                isScanner = scannerPar.get("picture-size-values").equals(bcrPar.get("picture-size-values")) && scannerPar.get("preferred-preview-size-for-video").equals(bcrPar.get("preferred-preview-size-for-video")) && scannerPar.get("preview-size").equals(bcrPar.get("preview-size")) && scannerPar.get("preview-size-values").equals(bcrPar.get("preview-size-values")) && scannerPar.get("raw-size").equals(bcrPar.get("raw-size")) && scannerPar.get("supported-live-snapshot-sizes").equals(bcrPar.get("supported-live-snapshot-sizes")) && scannerPar.get("video-size").equals(bcrPar.get("video-size")) && scannerPar.get("video-size-values").equals(bcrPar.get("video-size-values"));
                bcr.release();
                if (isScanner) {
                    scannerid = i;
                    break;
                }
            }
            --i;
        }
        Log.i((String)"getScannerIdFromCamera2", (String)(" scannerid=" + scannerid));
        return scannerid;
    }

    public synchronized void scan() {
        Log.i((String)TAG, (String)"scan() ok");
        if (this.bcr != null) {
            this.setNoDisplayMode();
            this.bcr.startDecode();
        }
    }

    public synchronized void stopScan() {
        if (this.bcr != null) {
            this.bcr.stopDecode();
            ScanerLedLight.getInstance().off();
        }
    }

    public synchronized void setScanCallback(final ScanCallback sc) {
        if (this.bcr != null) {
            this.bcr.setDecodeCallback(new BarCodeReader.DecodeCallback(){

                @Override
                public void onEvent(int event, int info, byte[] data, BarCodeReader reader) {
                }

                @Override
                public void onDecodeComplete(int symbology, int length, byte[] data, BarCodeReader reader) {
                    if (length == -3) {
                        Log.i((String)TAG, (String)"onDecodeComplete() DECODE_STATUS_MULTI_DEC_COUNT ");
                        return;
                    }
                    if (data != null && data.length > 0 && length > 1) {
                        ScanerLedLight.getInstance().blink();
                    }
                    sc.onScanComplete(symbology, length, data);
                }
            });
        }
    }

    public void setNoDisplayMode() {
        if (this.bcr != null) {
            this.bcr.setNoDisplayMode();
        }
    }

    public boolean setParameter(int paramNum, int paramVal) {
        return this.bcr != null && this.bcr.setParameter(paramNum, paramVal) == 0;
    }

    public boolean setParameter(int paramNum, String paramVal) {
        return this.bcr != null && this.bcr.setParameter(paramNum, paramVal) == 0;
    }

    public int getNumParameter(int paramNum) {
        if (this.bcr != null) {
            return this.bcr.getNumParameter(paramNum);
        }
        return -1;
    }

    public String getStrParameter(int paramNum) {
        if (this.bcr != null) {
            return this.bcr.getStrParameter(paramNum);
        }
        return "-1";
    }

    public void setDefaultParameters() {
        if (this.bcr != null) {
            this.bcr.setDefaultParameters();
        }
    }

    public int getNumProperty(int propNum) {
        if (this.bcr != null) {
            return this.bcr.getNumProperty(propNum);
        }
        return -1;
    }

    public String getStrProperty(int propNum) {
        if (this.bcr != null) {
            return this.bcr.getStrParameter(propNum);
        }
        return "-1";
    }

    public void enableAllCodeTypes() {
        if (this.bcr != null) {
            this.bcr.enableAllCodeTypes();
        }
    }

    public void disableAllCodeTypes() {
        if (this.bcr != null) {
            this.bcr.disableAllCodeTypes();
        }
    }

    public void takePicture(final PictureCallback cb) {
        if (this.bcr != null) {
            this.bcr.takePicture(new BarCodeReader.PictureCallback(){

                @Override
                public void onPictureTaken(int format, int width, int height, byte[] data, BarCodeReader reader) {
                    cb.onPictureTaken(format, width, height, data);
                }
            });
        }
    }

    public void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (this.bcr != null) {
            this.bcr.setPreviewDisplay(holder);
        }
    }

    public void startViewFinder(final VideoCallback cb) {
        if (this.bcr != null) {
            this.bcr.startViewFinder(new BarCodeReader.VideoCallback(){

                @Override
                public void onVideoFrame(int format, int width, int height, byte[] data, BarCodeReader reader) {
                    cb.onVideoFrame(format, width, height, data);
                }
            });
        }
    }

    public void startPreview() {
        if (this.bcr != null) {
            this.bcr.startPreview();
        }
    }

    public void stopPreview() {
        if (this.bcr != null) {
            this.bcr.stopPreview();
        }
    }

    public synchronized boolean close() {
        if (this.bcr != null) {
            this.bcr.release();
            this.bcr = null;
            ScanerLedLight.getInstance().free();
            Log.i((String)TAG, (String)"close() succ");
        }
        return true;
    }

    public static interface PictureCallback {
        public void onPictureTaken(int var1, int var2, int var3, byte[] var4);
    }

    public static interface ScanCallback {
        public void onScanComplete(int var1, int var2, byte[] var3);
    }

    public static class ScanerParamNum
    extends BarCodeReader.ParamNum {
    }

    public static class ScanerParamVal
    extends BarCodeReader.ParamVal {
    }

    public static class ScanerPropertyNum
    extends BarCodeReader.PropertyNum {
    }

    public static interface VideoCallback {
        public void onVideoFrame(int var1, int var2, int var3, byte[] var4);
    }
}

