/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.ScanerLedLight;
import com.rscja.deviceapi.exception.ConfigurationException;

public class Barcode1D
extends Device {
    private static final String TAG = Barcode1D.class.getSimpleName();
    protected DeviceConfiguration config = DeviceConfiguration.builder1DConfiguration();
    private static Barcode1D single = null;

    private Barcode1D() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Barcode1D getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Barcode1D> clazz = Barcode1D.class;
        synchronized (Barcode1D.class) {
            if (single != null) return single;
            single = new Barcode1D();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean open() {
        int result = DeviceAPI.getInstance().Barcode_1D_Open(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate());
        if (result == 1) {
            this.setPowerOn(true);
            ScanerLedLight.getInstance().init();
            return true;
        }
        Log.e((String)TAG, (String)("open() err:" + result));
        return false;
    }

    public synchronized String scan() {
        byte[] b = DeviceAPI.getInstance().Barcode_1D_Scan(this.config.getDeviceName());
        if (b != null && b.length > 0) {
            ScanerLedLight.getInstance().blink();
        }
        return new String(b);
    }

    public boolean stopScan() {
        Log.i((String)TAG, (String)"Barcode_1D_stopScan()");
        int result = DeviceAPI.getInstance().Barcode_1D_StopScan(this.config.getDeviceName());
        if (result == 1) {
            ScanerLedLight.getInstance().off();
            return true;
        }
        Log.e((String)TAG, (String)("stopScan() err:" + result));
        return false;
    }

    public synchronized boolean close() {
        int result = DeviceAPI.getInstance().Barcode_1D_Close(this.config.getDeviceName());
        if (result == 1) {
            this.setPowerOn(false);
            ScanerLedLight.getInstance().free();
            return true;
        }
        Log.e((String)TAG, (String)("close() err:" + result));
        return false;
    }
}

