/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class Infrared
extends Device {
    private static final String TAG = Infrared.class.getSimpleName();
    protected DeviceConfiguration config = DeviceConfiguration.builderInfraredConfiguration();
    private static Infrared single = null;

    private Infrared() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Infrared getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Infrared> clazz = Infrared.class;
        synchronized (Infrared.class) {
            if (single != null) return single;
            single = new Infrared();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean open() {
        return this.open(this.config.getBaudrate());
    }

    public synchronized boolean open(int baudrate) {
        return this.open(baudrate, 0);
    }

    public synchronized boolean open(int baudrate, int check) {
        int result = DeviceAPI.getInstance().Infrared_Open(this.config.getDeviceName(), this.config.getUart(), baudrate, check);
        if (result == 1) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("open() err:" + result));
        return false;
    }

    public synchronized boolean close() {
        int result = DeviceAPI.getInstance().Infrared_Close(this.config.getDeviceName());
        if (result == 1) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("close() err:" + result));
        return false;
    }

    public synchronized boolean send(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        int iRes = DeviceAPI.getInstance().infrared_write(data, data.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("send() err:" + iRes));
        return false;
    }

    public byte[] receive() {
        return DeviceAPI.getInstance().infrared_read();
    }

    public String getIDAndPowerWithWattmeter() {
        byte[] result = DeviceAPI.getInstance().Infared_IDPOWER();
        if (result == null || result[0] != 0) {
            return null;
        }
        byte[] arrsID = Arrays.copyOfRange(result, 1, 7);
        byte[] arrsPower = Arrays.copyOfRange(result, 7, 11);
        String strPower = StringUtility.bytes2HexString(arrsPower, arrsPower.length);
        String str = strPower.substring(strPower.length() - 2, strPower.length());
        strPower = String.valueOf(strPower.substring(0, strPower.length() - 2)) + "." + str;
        return String.valueOf(StringUtility.bytes2HexString(arrsID, arrsID.length)) + ":" + strPower;
    }
}

