/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;

public class Module {
    private static final String TAG = "Module";
    private static Module single = null;
    protected DeviceConfiguration config;

    private Module() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Module getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Module> clazz = Module.class;
        synchronized (Module.class) {
            if (single != null) return single;
            single = new Module();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    @Deprecated
    public boolean powerOn(int module) {
        int result = this.getDeviceAPI().ModulePowerOn(this.config.getDeviceName(), module);
        return result != -1;
    }

    @Deprecated
    public boolean powerOff(int module) {
        int result = this.getDeviceAPI().ModulePowerOff(this.config.getDeviceName(), module);
        return result != -1;
    }

    @Deprecated
    public boolean uartSwitch(int module) {
        int result = this.getDeviceAPI().UartSwitch(this.config.getDeviceName(), module);
        return result != -1;
    }

    public synchronized boolean init(int module) {
        int result = -1;
        switch (module) {
            case 1: {
                try {
                    this.config = DeviceConfiguration.builder1DConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.config = DeviceConfiguration.builderUHFConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return this.config != null && (result = this.getDeviceAPI().ModuleInit(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate(), module)) != -1;
    }

    public synchronized boolean init(int module, int baudrate) {
        int result = -1;
        switch (module) {
            case 1: {
                try {
                    this.config = DeviceConfiguration.builder1DConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.config = DeviceConfiguration.builderRFIDConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.config = DeviceConfiguration.builderUHFConfiguration();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return this.config != null && (result = this.getDeviceAPI().ModuleInit(this.config.getDeviceName(), this.config.getUart(), baudrate, module)) != -1;
    }

    public synchronized boolean free() {
        int result = -1;
        return this.config != null && (result = this.getDeviceAPI().ModuleFree(this.config.getDeviceName())) != -1;
    }

    public synchronized boolean send(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        int iRes = DeviceAPI.getInstance().ModuleSend(data, data.length);
        if (iRes == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("send() err:" + iRes));
        return false;
    }

    public byte[] receive() {
        return DeviceAPI.getInstance().ModuleReceive();
    }
}

