/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.entity.BDLocation;
import com.rscja.deviceapi.entity.SatelliteEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class BDNavigation
extends Device {
    private static final String TAG = BDNavigation.class.getSimpleName();
    protected DeviceConfiguration config;
    private static BDNavigation single = null;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;
    private BDLocationListener mListener;
    private BDStatusListener mBDStatusListener;
    private ReadThread mReadThread;
    private BDLocation mLastLocation = null;
    private int satelliteVCount = 0;
    private int satelliteVCount_gps = 0;
    private int satelliteVCount_bd = 0;
    private int lastsatelliteVCount = 0;
    private Date mUTCDateTime;
    private ArrayList<SatelliteEntity> lstStatellite = new ArrayList();
    private int satelliteUCount = 0;
    private int lastSatelliteUCount = 0;
    private long startLocationTime;
    private int timeToFirstFix = -1;
    private int locFail = 0;
    private String resultData = "";
    private BDProviderEnum mBDProviderEnum;

    protected BDNavigation() throws ConfigurationException {
        this.config = DeviceConfiguration.builderBDConfiguration();
    }

    public Date getLastUTCDateTime() {
        return this.mUTCDateTime;
    }

    public int getLastSatelliteUCount() {
        return this.lastSatelliteUCount;
    }

    public int getLastsatelliteVCount() {
        return this.lastsatelliteVCount;
    }

    public int getTimeToFirstFix() {
        return this.timeToFirstFix;
    }

    public void addBDStatusListener(BDStatusListener listener) {
        if (this.mFileInputStream == null || this.mFileOutputStream == null) {
            return;
        }
        if (listener != null) {
            this.mBDStatusListener = listener;
        }
    }

    public static synchronized BDNavigation getInstance() throws ConfigurationException {
        if (single == null) {
            single = new BDNavigation();
        }
        return single;
    }

    public BDLocation getLastLocation() {
        return this.mLastLocation;
    }

    public synchronized boolean open() throws SecurityException, IOException {
        int result = DeviceAPI.getInstance().bdOn(this.config.getDeviceName());
        if (result > 0) {
            this.initSerialPort(new File(this.config.getUart()), this.config.getBaudrate(), 0);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("open() err:" + result));
        return false;
    }

    public synchronized boolean close() {
        int result = DeviceAPI.getInstance().bdOff(this.config.getDeviceName());
        if (this.mReadThread != null) {
            this.mReadThread.interrupt();
            this.mReadThread = null;
        }
        try {
            if (this.mFileInputStream != null) {
                this.mFileInputStream.close();
            }
            if (this.mFileOutputStream != null) {
                this.mFileOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (DeviceAPI.getInstance().mFd != null) {
            DeviceAPI.getInstance().spClose();
        }
        if (result > 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("close() err:" + result));
        return false;
    }

    private void initSerialPort(File device, int baudrate, int flags) throws SecurityException, IOException {
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("/system/bin/su");
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\n" + "exit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException();
            }
        }
        DeviceAPI.getInstance().mFd = DeviceAPI.getInstance().spOpen(device.getAbsolutePath(), baudrate, flags);
        if (DeviceAPI.getInstance().mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(DeviceAPI.getInstance().mFd);
        this.mFileOutputStream = new FileOutputStream(DeviceAPI.getInstance().mFd);
    }

    private synchronized void proccResult(byte[] buffer, int size) {
        String result = new String(buffer, 0, size);
        this.parseNMEAMsg(result);
    }

    private void parseNMEAMsg(String result) {
        String[] arrResult;
        if (StringUtility.isEmpty(result)) {
            return;
        }
        int idx = result.indexOf("$");
        if (idx == -1) {
            return;
        }
        this.resultData = result;
        Log.e((String)TAG, (String)("parseNMEAMsg() result:" + result));
        BDLocation loc = null;
        result = result.substring(idx);
        String[] stringArray = arrResult = result.split("\r\n");
        int n = arrResult.length;
        int n2 = 0;
        while (n2 < n) {
            String[] arr;
            String msg = stringArray[n2];
            if (msg.indexOf(",") == -1 || msg.split("$").length > 1 || (arr = msg.split(",")).length < 2 || arr[0].length() < 6) break;
            String type = arr[0].substring(1, 3);
            String head = arr[0].substring(3, 6);
            if (head.equals("GGA")) {
                if (arr.length < 10) break;
                if (this.mListener != null) {
                    this.mListener.onDataResult(msg);
                }
                if (this.mBDProviderEnum == BDProviderEnum.GPS) {
                    if (!type.toUpperCase().trim().equals("GP")) {
                        break;
                    }
                } else if (this.mBDProviderEnum != BDProviderEnum.BD ? this.mBDProviderEnum == BDProviderEnum.GPSandBD && !type.toUpperCase().trim().equals("GN") : !type.toUpperCase().trim().equals("BD")) break;
                if (this.convert2Double(arr[6]) != 1.0 || StringUtility.isEmpty(arr[2]) || StringUtility.isEmpty(arr[4])) break;
                double latT = this.convert2Double(arr[2]) / 100.0;
                double lonT = this.convert2Double(arr[4]) / 100.0;
                double lat = (double)((int)latT) + (latT - (double)((int)latT)) * 100.0 / 60.0;
                double lon = (double)((int)lonT) + (lonT - (double)((int)lonT)) * 100.0 / 60.0;
                if (!StringUtility.isEmpty(arr[3]) && arr[3].toUpperCase().equals("S")) {
                    lat = -lat;
                }
                if (!StringUtility.isEmpty(arr[5]) && arr[5].toUpperCase().equals("W")) {
                    lon = -lon;
                }
                if (this.timeToFirstFix == -1) {
                    long curr = System.currentTimeMillis();
                    this.timeToFirstFix = (int)(curr - this.startLocationTime);
                }
                loc = new BDLocation(lat, lon, this.convert2Double(arr[9]), type);
                this.satelliteUCount = (int)this.convert2Double(arr[7]);
            } else if (!head.equals("GLL") && !head.equals("GSA")) {
                if (head.equals("GSV")) {
                    Log.i((String)TAG, (String)(" GSV mBDProviderEnum=" + (Object)((Object)this.mBDProviderEnum)));
                    if (arr.length < 4) break;
                    if (this.mListener != null) {
                        this.mListener.onDataResult(msg);
                    }
                    if (type.toUpperCase().trim().equals("GP")) {
                        this.satelliteVCount_gps = (int)this.convert2Double(arr[3]);
                    } else if (type.toUpperCase().trim().equals("BD")) {
                        this.satelliteVCount_bd = (int)this.convert2Double(arr[3]);
                    }
                    if (this.mBDProviderEnum == BDProviderEnum.GPS) {
                        this.satelliteVCount = this.satelliteVCount_gps;
                    } else if (this.mBDProviderEnum == BDProviderEnum.BD) {
                        this.satelliteVCount = this.satelliteVCount_bd;
                    } else if (this.mBDProviderEnum == BDProviderEnum.GPSandBD) {
                        this.satelliteVCount = this.satelliteVCount_gps + this.satelliteVCount_bd;
                    }
                    if (arr.length < 20) break;
                    if (this.mBDProviderEnum == BDProviderEnum.GPS) {
                        if (type.toUpperCase().trim().equals("GP")) {
                            this.proccSatelliteList(arr, this.satelliteVCount);
                        }
                    } else if (this.mBDProviderEnum == BDProviderEnum.BD) {
                        if (type.toUpperCase().trim().equals("BD")) {
                            this.proccSatelliteList(arr, this.satelliteVCount);
                        }
                    } else if (this.mBDProviderEnum == BDProviderEnum.GPSandBD) {
                        this.proccSatelliteList(arr, this.satelliteVCount);
                    }
                } else if (head.equals("RMC")) {
                    if (arr.length < 10 || StringUtility.isEmpty(arr[1]) || StringUtility.isEmpty(arr[9]) || arr[1].length() != 10 || arr[9].length() != 4 || arr[1].indexOf(".") < 0) break;
                    String strDt = String.valueOf(arr[9]) + " " + arr[1].substring(0, arr[1].indexOf("."));
                    SimpleDateFormat format = new SimpleDateFormat("ddMMyy HH:mm:ss");
                    format.setLenient(false);
                    try {
                        Date dt = format.parse(strDt);
                        if (dt != null) {
                            this.mUTCDateTime = dt;
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        if (loc == null) {
            if (this.mBDStatusListener != null) {
                if (this.timeToFirstFix == -1) {
                    this.mBDStatusListener.onBDSatelliteLocating();
                } else {
                    ++this.locFail;
                    if (this.locFail > 50) {
                        this.mBDStatusListener.onBDSatelliteLocating();
                        this.locFail = 0;
                    }
                }
            }
        } else if (loc != null && this.mLastLocation == null) {
            this.mLastLocation = loc;
            if (this.mListener != null) {
                this.mListener.onLocationChanged(loc);
            }
            if (this.mBDStatusListener != null) {
                this.mBDStatusListener.onBDSatelliteFIX(this.satelliteUCount);
            }
        } else if (this.mLastLocation != null && !this.mLastLocation.equals(loc)) {
            this.mLastLocation = loc;
            if (this.mListener != null) {
                this.mListener.onLocationChanged(loc);
            }
            if (this.mBDStatusListener != null) {
                this.mBDStatusListener.onBDSatelliteFIX(this.satelliteUCount);
            }
        }
        if (this.satelliteVCount != this.lastsatelliteVCount) {
            this.lastsatelliteVCount = this.satelliteVCount;
            if (this.mBDStatusListener != null) {
                this.mBDStatusListener.onBDSatelliteViewChanged(this.lastsatelliteVCount);
            }
        }
        if (this.satelliteUCount != this.lastSatelliteUCount) {
            this.lastSatelliteUCount = this.satelliteUCount;
            if (this.mBDStatusListener != null) {
                this.mBDStatusListener.onBDSatelliteUsedChanged(this.lastSatelliteUCount);
            }
        }
    }

    private synchronized void proccSatelliteList(String[] arr, int sVcount) {
        Log.i((String)TAG, (String)"proccSatelliteList()");
        int sidx = -1;
        int diff = 0;
        int ssize = 0;
        int i = 1;
        while (i < 5) {
            String num = arr[i * 4];
            String signal = arr[i * 4 + 3];
            if (this.valiSatelliteNum(num)) {
                SatelliteEntity s = new SatelliteEntity(num, signal);
                sidx = this.lstStatellite.indexOf(s);
                if (sidx > -1) {
                    this.lstStatellite.get(sidx).setSignal(signal);
                } else {
                    this.lstStatellite.add(s);
                }
            }
            ++i;
        }
        ssize = this.lstStatellite.size();
        diff = ssize - sVcount;
        if (diff > 0) {
            int j = 0;
            while (j < diff) {
                if (j >= this.lstStatellite.size()) break;
                this.lstStatellite.remove(j);
                ++j;
            }
        }
        if (this.mBDStatusListener != null) {
            this.mBDStatusListener.onBDSatelliteChanged(this.lstStatellite);
        }
    }

    private boolean valiSatelliteNum(String num) {
        int iNum = (int)this.convert2Double(num);
        if (iNum > 0 && iNum < 33) {
            return true;
        }
        return iNum > 160 && iNum < 198;
    }

    private BDLocation parseNavMsg(String msg) {
        return null;
    }

    private double convert2Double(String value) {
        if (StringUtility.isEmpty(value)) {
            return 0.0;
        }
        if (!StringUtility.isNum(value) || value.trim().equals("-")) {
            return 0.0;
        }
        return Double.parseDouble(value.trim());
    }

    public void addBDLocationListener(BDProviderEnum provider, BDLocationListener listener) {
        if (this.mFileInputStream == null || this.mFileOutputStream == null) {
            return;
        }
        if (listener == null) {
            return;
        }
        this.mListener = listener;
        this.changeBDProvider(provider);
    }

    public void changeBDProvider(BDProviderEnum provider) {
        if (this.mFileInputStream == null || this.mFileOutputStream == null) {
            return;
        }
        String snavSys = "h11";
        if (provider == BDProviderEnum.GPS) {
            snavSys = "h01";
        } else if (provider == BDProviderEnum.BD) {
            snavSys = "h10";
        }
        this.mBDProviderEnum = provider;
        Log.i((String)TAG, (String)("changeBDProvider() snavSys:" + snavSys));
        try {
            this.mFileOutputStream.write(new String("$CFGSYS," + snavSys + "\r\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mReadThread = new ReadThread(1000L);
        this.resetData();
        this.mReadThread.start();
    }

    public void changeBDStartMode(BDStartModeEnum mode) {
        String sMode = "h00";
        if (mode == BDStartModeEnum.WARM) {
            sMode = "h01";
        } else if (mode == BDStartModeEnum.COLD) {
            sMode = "h9D";
        }
        try {
            this.mFileOutputStream.write(new String("$RESET,0," + sMode + "\r\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mReadThread = new ReadThread(1000L);
        this.resetData();
        this.mReadThread.start();
    }

    private void resetData() {
        this.lstStatellite.clear();
        this.satelliteVCount_gps = 0;
        this.satelliteVCount_bd = 0;
        this.lastsatelliteVCount = 0;
        this.satelliteUCount = 0;
        this.startLocationTime = System.currentTimeMillis();
        this.timeToFirstFix = -1;
        if (this.mBDStatusListener != null) {
            this.mBDStatusListener.onBDSatelliteLocating();
            this.mBDStatusListener.onBDSatelliteChanged(this.lstStatellite);
        }
        if (this.satelliteVCount != this.lastsatelliteVCount) {
            this.lastsatelliteVCount = this.satelliteVCount;
            if (this.mBDStatusListener != null) {
                this.mBDStatusListener.onBDSatelliteViewChanged(this.lastsatelliteVCount);
            }
        }
        if (this.satelliteUCount != this.lastSatelliteUCount) {
            this.lastSatelliteUCount = this.satelliteUCount;
            if (this.mBDStatusListener != null) {
                this.mBDStatusListener.onBDSatelliteUsedChanged(this.lastSatelliteUCount);
            }
        }
        if (this.mListener != null) {
            this.mListener.onLocationChanged(null);
            this.mListener.onDataResult("============resetData==============");
        }
    }

    public String getResultData() {
        return this.resultData;
    }

    public static interface BDLocationListener {
        public void onLocationChanged(BDLocation var1);

        public void onDataResult(String var1);
    }

    public static enum BDProviderEnum {
        GPS,
        BD,
        GPSandBD;

    }

    public static enum BDStartModeEnum {
        COLD,
        WARM,
        HOT;

    }

    public static interface BDStatusListener {
        public void onBDSatelliteViewChanged(int var1);

        public void onBDSatelliteUsedChanged(int var1);

        public void onBDSatelliteChanged(ArrayList<SatelliteEntity> var1);

        public void onBDSatelliteFIX(int var1);

        public void onBDSatelliteLocating();
    }

    private class ReadThread
    extends Thread {
        private long wait = 0L;

        private ReadThread(long minTime) {
            BDNavigation.this.startLocationTime = System.currentTimeMillis();
            this.wait = minTime;
            if (BDNavigation.this.mBDStatusListener != null) {
                BDNavigation.this.mBDStatusListener.onBDSatelliteLocating();
            }
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    byte[] buffer = new byte[256];
                    if (BDNavigation.this.mFileInputStream == null) {
                        return;
                    }
                    int size = BDNavigation.this.mFileInputStream.read(buffer);
                    if (size > 0) {
                        BDNavigation.this.proccResult(buffer, size);
                    }
                    try {
                        ReadThread.sleep(this.wait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }

        public void setWait(int time) {
            this.wait = time;
        }
    }
}

