/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.os.Build;
import android.util.Log;
import com.rscja.deviceapi.exception.ConfigurationException;

public class DeviceConfiguration {
    private static final String TAG = "DeviceConfiguration";
    private static String model = Build.DISPLAY.toUpperCase();
    private static final String uart_mtk = "/dev/ttyMT3";
    private static final String uart_msm = "/dev/ttyHSL1";
    private static final String uart_Fingerprint_mtk = "/dev/ttyMT0";
    private static final String uart_Fingerprint_msm = "/dev/ttyHSL1";
    private static String uartPath = "/dev/ttyMT3";
    private static String uartPath_Fingerprint = "/dev/ttyMT0";
    private String deviceName;
    private String uart;
    private int baudrate;

    static {
        if (model.contains("C4000")) {
            model = "C4000";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40006577")) {
            model = "C4000";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40006582")) {
            model = "C40006582";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40506582")) {
            model = "C40506582";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        } else if (model.contains("40508909")) {
            model = "C40508909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else if (model.contains("60008909")) {
            model = "C60008909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else if (model.contains("20151118")) {
            model = "C40508909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else {
            model = "C4000";
            uartPath = uart_mtk;
            uartPath_Fingerprint = uart_Fingerprint_mtk;
        }
    }

    public static String getModel() {
        if (model.equals("i760")) {
            return "C4000";
        }
        Log.i((String)TAG, (String)("getModel() model=" + model));
        return model.toUpperCase();
    }

    public static DeviceConfiguration builder1DConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builder2DConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builderRFIDConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderUHFConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderPrinterConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builderFingerprintConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath_Fingerprint, 57600);
    }

    public static DeviceConfiguration builderLFConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderBDConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), "/dev/ttyMT1", 9600);
    }

    public static DeviceConfiguration builderInfraredConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 1200);
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setUart(String uart) {
        uartPath = uart;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    private DeviceConfiguration(String deviceName, String uart, int baudrate) {
        this.deviceName = deviceName;
        uartPath = uart;
        this.baudrate = baudrate;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUart() {
        return uartPath;
    }

    public int getBaudrate() {
        return this.baudrate;
    }
}

