/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

public class RFIDBase
extends Device {
    private static final String TAG = "RFIDBase";
    protected DeviceConfiguration config = DeviceConfiguration.builderRFIDConfiguration();
    private static RFIDBase single = null;

    protected RFIDBase() throws ConfigurationException {
    }

    public static synchronized RFIDBase getInstance() throws ConfigurationException {
        if (single == null) {
            single = new RFIDBase();
        }
        return single;
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public synchronized boolean init() {
        int result = -1;
        result = this.getDeviceAPI().RFID_init(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate());
        if (result == 0) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean free() {
        int result = -1;
        result = this.getDeviceAPI().RFID_free(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        return false;
    }

    public synchronized String getVersion() {
        byte[] b = this.getDeviceAPI().RFID_GetVer();
        Log.d((String)TAG, (String)("getVersion b[0]=" + Integer.valueOf(b[0]) + " b.length=" + b.length));
        if (b[0] == 0) {
            Log.d((String)TAG, (String)("b[1]=" + Integer.valueOf(b[1])));
            byte[] re = new byte[b[1]];
            int i = 0;
            while (i < re.length) {
                re[i] = b[i + 2];
                ++i;
            }
            return String.valueOf(StringUtility.getChars(re));
        }
        Log.e((String)TAG, (String)("getVersion() err:" + b[0]));
        return null;
    }

    public synchronized boolean rfidUpgrade(int packageCount, int index, int currSize, byte[] data) {
        int result = this.getDeviceAPI().RFID_UPDATE(packageCount, index, currSize, data);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("rfidUpgrade() err:" + result));
        return false;
    }
}

