/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.text.DecimalFormat;
import java.util.Arrays;

public class RFIDWithUHF
extends Device {
    private static final String TAG = "RFIDWithUHF";
    private static RFIDWithUHF single = null;
    protected DeviceConfiguration config = DeviceConfiguration.builderUHFConfiguration();

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHF getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithUHF> clazz = RFIDWithUHF.class;
        synchronized (RFIDWithUHF.class) {
            if (single != null) return single;
            single = new RFIDWithUHF();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    private RFIDWithUHF() throws ConfigurationException {
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result == 0) {
            result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
            if (result == 0) {
                this.setPowerOn(true);
                return true;
            }
            Log.e((String)TAG, (String)("init() err UHFOpenAndConnect result:" + result));
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + result));
        }
        return false;
    }

    public synchronized boolean free() {
        this.getDeviceAPI().UHFCloseAndDisconnect();
        int result = this.getDeviceAPI().UHFFree(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err UHFFree result:" + result));
        return false;
    }

    public synchronized void crcOn() {
        this.getDeviceAPI().UHFFlagCrcOn();
    }

    public synchronized void crcOff() {
        this.getDeviceAPI().UHFFlafCrcOff();
    }

    public String convertUiiToEPC(String uii) {
        if (StringUtility.isEmpty(uii)) {
            return "";
        }
        String sUii = uii.replace("-", "").toUpperCase();
        sUii = sUii.substring(4, sUii.length());
        return sUii;
    }

    public synchronized String getHardwareType() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] result = this.getDeviceAPI().UHFGetHwType();
        if (result != null && result[0] == '\u0000') {
            char[] arrs = Arrays.copyOfRange(result, 2, result[1] + 2);
            return new String(arrs);
        }
        Log.e((String)TAG, (String)("getHardwareType() err:" + result[0]));
        return null;
    }

    public synchronized int getPower() {
        char[] result = this.getDeviceAPI().UHFGetPower();
        if (result != null && result[0] == '\u0000') {
            return result[1];
        }
        Log.e((String)TAG, (String)("getPower() err :" + result[0]));
        return -1;
    }

    public synchronized boolean setPower(int power) {
        int result = this.getDeviceAPI().UHFSetPower((char)power);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPower() err :" + result));
        return false;
    }

    synchronized String getFrequency() {
        char bFreMode = '\u0000';
        char bFreBase = '\u0000';
        char[] bBaseFre = new char[2];
        char bChannNum = '\u0000';
        char bChannSpc = '\u0000';
        char bFreHop = '\u0000';
        String freStr = null;
        char[] result = this.getDeviceAPI().UHFGetFrequency();
        if (result != null && result[0] == '\u0000') {
            bFreMode = result[2];
            bFreBase = result[3];
            bBaseFre[0] = result[4];
            bBaseFre[1] = result[5];
            bChannNum = result[6];
            bChannSpc = result[7];
            bFreHop = result[8];
            int iFreBase0 = bBaseFre[0] & 0xFF;
            int iFreBase1 = bBaseFre[1] & 0xFF;
            int freI = (iFreBase0 << 3) + (iFreBase1 >> 5);
            int freD = 0;
            int eFreD = 0;
            int eFreI = 0;
            if (bFreBase == '\u0000') {
                freD = (iFreBase1 & 0x1F) * 50;
                eFreD = (freD + bChannSpc * 50 * (bChannNum - '\u0001')) % 1000;
                eFreI = freI + (freD + bChannSpc * 50 * (bChannNum - '\u0001')) / 1000;
            } else {
                freD = (iFreBase1 & 0x1F) * 125;
                eFreD = (freD + bChannSpc * 125 * (bChannNum - '\u0001')) % 1000;
                eFreI = freI + (freD + bChannSpc * 125 * (bChannNum - '\u0001')) / 1000;
            }
            freStr = String.valueOf(String.valueOf(freI)) + "." + String.valueOf(freD) + "~" + String.valueOf(eFreI) + "." + String.valueOf(eFreD) + "MHz";
            return freStr;
        }
        Log.e((String)TAG, (String)("getFrequency() err :" + result[0]));
        return null;
    }

    public synchronized int getFrequencyMode() {
        char[] result = this.getDeviceAPI().UHFGetFrequency_Ex();
        if (result != null && result[0] == '\u0000') {
            return result[1];
        }
        Log.e((String)TAG, (String)("getFrequencyMode() err :" + result[0]));
        return -1;
    }

    synchronized boolean setFrequency(byte uFreMode, byte uFreBase, byte[] uBaseFre, byte uChannNum, byte uChannSpc, byte uFreHop) {
        char[] cBaseFre = new char[]{(char)uBaseFre[0], (char)uBaseFre[1]};
        int result = this.getDeviceAPI().UHFSetFrequency((char)uFreMode, (char)uFreBase, cBaseFre, (char)uChannNum, (char)uChannSpc, (char)uFreHop);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFrequency() err :" + result));
        return false;
    }

    public synchronized boolean setFrequencyMode(byte freMode) {
        int result = this.getDeviceAPI().UHFSetFrequency_EX((char)freMode);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFrequencyMode() err :" + result));
        return false;
    }

    public synchronized boolean startInventory(int flagAnti, int initQ) {
        int result = this.getDeviceAPI().UHFInventory((char)flagAnti, (char)initQ);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("startInventory() err :" + result));
        return false;
    }

    public synchronized boolean startInventoryTag(int flagAnti, int initQ) {
        return this.startInventoryTag((char)flagAnti, (char)initQ, 4);
    }

    public synchronized boolean startInventoryTag(int flagAnti, int initQ, int cnt) {
        int result = this.getDeviceAPI().UHFInventory_EX_cnt((char)flagAnti, (char)initQ, (char)cnt);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("startInventory() err :" + result));
        return false;
    }

    @Deprecated
    public synchronized String readUidFormBuffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readUidFormBuffer() err :" + result[0]));
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uii, uii.length);
    }

    public synchronized String readUidFromBuffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readUidFormBuffer() err :" + result[0]));
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uii, uii.length);
    }

    @Deprecated
    public synchronized String[] readTagFormBuffer() {
        return this.readTagFromBuffer();
    }

    public synchronized String[] readTagFromBuffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived_EX();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readTagFromBuffer() err :" + result[0]));
            return null;
        }
        Log.i((String)TAG, (String)("readTagFromBuffer() result[1] :" + result[1]));
        char[] uii = Arrays.copyOfRange(result, 3, 3 + result[2]);
        char[] tid = Arrays.copyOfRange(result, 3 + uii.length + 1, 4 + uii.length + result[3 + uii.length]);
        char[] rssi = Arrays.copyOfRange(result, (int)result[1], result[1] + 2);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
        Log.i((String)TAG, (String)("readTagFromBuffer() dBm :" + dBm));
        String strdBm = "N/A";
        if (dBm < 200.0f && dBm > 0.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        String[] res = new String[]{StringUtility.chars2HexString(tid, tid.length), StringUtility.chars2HexString(uii, uii.length), strdBm};
        return res;
    }

    public synchronized String[] readTagFromR2000Buffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived_EX_R2000();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readTagFromR2000Buffer() err :" + result[0]));
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 3, 3 + result[2]);
        char[] tid = Arrays.copyOfRange(result, 3 + uii.length + 1, 4 + uii.length + result[3 + uii.length]);
        char[] rssi = Arrays.copyOfRange(result, (int)result[1], result[1] + 2);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        float dBm = (float)(65536 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        String[] res = new String[]{StringUtility.chars2HexString(tid, tid.length), StringUtility.chars2HexString(uii, uii.length), strdBm};
        return res;
    }

    public synchronized boolean stopInventory() {
        int result = this.getDeviceAPI().UHFStopGet();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("stopInventory() err :" + result));
        return false;
    }

    public synchronized boolean setPwm(int WorkTime, int WaitTime) {
        int result = this.getDeviceAPI().UHFSetPwm(WorkTime, WaitTime);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPwm() err :" + result));
        return false;
    }

    public synchronized int[] getPwm() {
        int[] result = this.getDeviceAPI().UHFGetPwm();
        if (result == null || result[0] != 0) {
            Log.e((String)TAG, (String)("getPwm() err :" + result[0]));
            return null;
        }
        int[] res = Arrays.copyOfRange(result, 1, 3);
        return res;
    }

    @Deprecated
    public synchronized boolean setReadMode(SingelModeEnum mode) {
        int result = this.getDeviceAPI().UHFSetSingelMode((char)mode.value);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setReadMode() err :" + result));
        return false;
    }

    public synchronized boolean setReadMode(SingleModeEnum mode) {
        int result = this.getDeviceAPI().UHFSetSingelMode((char)mode.value);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setReadMode() err :" + result));
        return false;
    }

    public synchronized int getReadMode() {
        char[] result = this.getDeviceAPI().UHFGetSingelMode();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("getReadMode() err :" + result[0]));
            return -1;
        }
        return result[1];
    }

    public synchronized String lockMem(String accessPwd, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        char[] result = this.getDeviceAPI().UHFLockMemSingle(bAccessPwd, bLockData);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("lockMem() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uiiData, uiiData.length);
    }

    public synchronized boolean lockMem(String accessPwd, String lockCode, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEpc = StringUtility.hexString2Chars(uii);
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        int result = this.getDeviceAPI().UHFLockMem(bAccessPwd, bLockData, bEpc);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("lockMem() err :" + result));
        return false;
    }

    synchronized String[] getVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] result = this.getDeviceAPI().UHFGetVersion();
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("getVersion() err :" + result[0]));
            return null;
        }
        int i = 0;
        while (i < result.length) {
            Log.e((String)TAG, (String)("result[i] :" + result[i]));
            ++i;
        }
        char[] serialData = Arrays.copyOfRange(result, 3, result[2] + 3);
        char[] versionData = Arrays.copyOfRange(result, 4 + serialData.length, result[3 + serialData.length] + 4 + serialData.length);
        String[] res = new String[]{new String(serialData), new String(versionData)};
        return res;
    }

    public synchronized String inventorySingleTag() {
        char[] result = this.getDeviceAPI().UHFInventorySingle();
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("inventorySingleTag() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public synchronized SimpleRFIDEntity readData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        SimpleRFIDEntity entity = null;
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] result = this.getDeviceAPI().UHFReadDataSingle(bAccessPwd, (char)bank.value, ptr, (char)cnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 3, result[2] + 3);
        entity = new SimpleRFIDEntity(StringUtility.chars2HexString(uiiData, uiiData.length), "UHF");
        char[] data = Arrays.copyOfRange(result, 4 + uiiData.length, result[3 + uiiData.length] + 4 + uiiData.length);
        entity.setData(StringUtility.chars2HexString(data, cnt * 2));
        return entity;
    }

    public synchronized String readData(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] result = this.getDeviceAPI().UHFReadData(bAccessPwd, (char)bank.value, (char)ptr, (char)cnt, bEPC);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public synchronized String writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        char[] cData = new char[cnt * 2];
        int i = 0;
        while (i < cData.length) {
            cData[i] = i < bWriteData.length ? bWriteData[i] : (char)'\u0000';
            ++i;
        }
        char[] result = null;
        int i2 = 0;
        while (i2 < cnt) {
            char[] cwData = Arrays.copyOfRange(cData, i2 * 2, i2 * 2 + 2);
            result = this.getDeviceAPI().UHFWriteDataSingle(bAccessPwd, (char)bank.value, i2 + ptr, '\u0001', cwData);
            if (result[0] != '\u0000') {
                Log.e((String)TAG, (String)("writeData() err :" + result[0]));
                return null;
            }
            ++i2;
        }
        if (result != null) {
            char[] uiiData = Arrays.copyOfRange(result, 2, (int)(result[1] + 2));
            return StringUtility.chars2HexString(uiiData, uiiData.length);
        }
        return null;
    }

    public synchronized boolean writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        Log.i((String)TAG, (String)("writeData() bWriteData.length :" + bWriteData.length));
        int result = this.getDeviceAPI().UHFWriteData(bAccessPwd, (char)bank.value, ptr, (char)cnt, bEPC, bWriteData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeData() err :" + result));
        return false;
    }

    public synchronized String eraseData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] result = this.getDeviceAPI().UHFEraseDataSingle(bAccessPwd, (char)bank.value, ptr, (char)cnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("eraseData() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uiiData, uiiData.length);
    }

    public synchronized boolean eraseData(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEpc = StringUtility.hexString2Chars(uii);
        int result = this.getDeviceAPI().UHFEraseData(bAccessPwd, (char)bank.value, ptr, (char)cnt, bEpc);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("eraseData() err :" + result));
        return false;
    }

    public synchronized boolean setFilter(int bank, int ptr, String data) {
        if (StringUtility.isEmpty(data)) {
            data = "";
        }
        char[] bData = StringUtility.hexString2Chars(data);
        int result = this.getDeviceAPI().UHFSetFilter('\u0001', (char)bank, ptr, bData.length, bData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFilter() err :" + result));
        return false;
    }

    public synchronized boolean setFilter(int bank, byte ptr, String data) {
        if (StringUtility.isEmpty(data)) {
            data = "";
        }
        char[] bData = StringUtility.hexString2Chars(data);
        int result = this.getDeviceAPI().UHFSetFilter('\u0001', (char)bank, ptr, bData.length, bData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFilter() err :" + result));
        return false;
    }

    public synchronized String killTag(String killPwd) {
        if (StringUtility.isEmpty(killPwd)) {
            return null;
        }
        char[] bKillPwd = StringUtility.hexString2Chars(killPwd);
        char[] result = this.getDeviceAPI().UHFKillTagSingle(bKillPwd);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("killTag() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uiiData, uiiData.length);
    }

    public synchronized boolean killTag(String killPwd, String uii) {
        if (StringUtility.isEmpty(killPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bKillPwd = StringUtility.hexString2Chars(killPwd);
        char[] bEpc = StringUtility.hexString2Chars(uii);
        int result = this.getDeviceAPI().UHFKillTag(bKillPwd, bEpc);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("killTag() err :" + result));
        return false;
    }

    public synchronized String generateLockCode(LockModeEnum killPwd, LockModeEnum accessPwd, LockModeEnum uii, LockModeEnum tid, LockModeEnum user) {
        byte bkill = killPwd.value;
        byte baccess = accessPwd.value;
        byte buii = uii.value;
        byte btid = tid.value;
        byte buser = user.value;
        byte[] LockCode = new byte[]{0, 0, 0};
        if (bkill == 1) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 2);
        } else if (bkill == 2) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 0);
        } else if (bkill == 3) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 3);
        } else if (bkill == 4) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 1);
        } else {
            LockCode[0] = (byte)(LockCode[0] & 3);
            LockCode[1] = (byte)(LockCode[1] & 0xFC);
        }
        if (baccess == 1) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0x80);
        } else if (baccess == 2) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (baccess == 3) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0xC0);
        } else if (baccess == 4) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0x40);
        } else {
            LockCode[0] = (byte)(LockCode[0] & 0xC);
            LockCode[2] = (byte)(LockCode[2] & 0x3F);
        }
        if (buii == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x20);
        } else if (buii == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (buii == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x30);
        } else if (buii == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x10);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0x3F);
            LockCode[2] = (byte)(LockCode[2] & 0xCF);
        }
        if (btid == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 8);
        } else if (btid == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (btid == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 0xC);
        } else if (btid == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 4);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0xCF);
            LockCode[2] = (byte)(LockCode[2] & 0xF3);
        }
        if (buser == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 2);
        } else if (buser == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (buser == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 3);
        } else if (buser == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 1);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0xF3);
            LockCode[2] = (byte)(LockCode[2] & 0xFC);
        }
        return StringUtility.bytes2HexString(LockCode, LockCode.length);
    }

    public synchronized boolean setProtocol(int protocol) {
        int result = this.getDeviceAPI().Um7ProtocolConfig((char)protocol);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setProtocol() err :" + result));
        return false;
    }

    public synchronized boolean openInventoryEPCAndTIDMode() {
        int result = this.getDeviceAPI().R2000_OPENMODE();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("openInventoryEPCAndTIDMode() err :" + result));
        return false;
    }

    public synchronized boolean setFreHop(float fre) {
        int ifre = (int)(fre * 1000.0f);
        int result = this.getDeviceAPI().R2000_FreHopSet(ifre);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFreHop() err :" + result));
        return false;
    }

    public synchronized SimpleRFIDEntity readDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        SimpleRFIDEntity entity = null;
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] result = this.getDeviceAPI().UHFReadQTDataSingle(bAccessPwd, (char)bank.value, ptr, (char)cnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 3, result[2] + 3);
        entity = new SimpleRFIDEntity(StringUtility.chars2HexString(uiiData, uiiData.length), "UHF");
        char[] data = Arrays.copyOfRange(result, 4 + uiiData.length, result[3 + uiiData.length] + 4 + uiiData.length);
        entity.setData(StringUtility.chars2HexString(data, cnt * 2));
        return entity;
    }

    public synchronized String readDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] result = this.getDeviceAPI().UHFReadQTData(bAccessPwd, (char)bank.value, (char)ptr, (char)cnt, bEPC);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readDataWithQT() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public synchronized String writeDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        char[] cData = new char[cnt * 2];
        int i = 0;
        while (i < cData.length) {
            cData[i] = i < bWriteData.length ? bWriteData[i] : (char)'\u0000';
            ++i;
        }
        char[] result = null;
        int i2 = 0;
        while (i2 < cnt) {
            char[] cwData = Arrays.copyOfRange(cData, i2 * 2, i2 * 2 + 2);
            result = this.getDeviceAPI().UHFWriteQTDataSingle(bAccessPwd, (char)bank.value, i2 + ptr, '\u0001', cwData);
            if (result[0] != '\u0000') {
                Log.e((String)TAG, (String)("writeData() err :" + result[0]));
                return null;
            }
            ++i2;
        }
        if (result != null) {
            char[] uiiData = Arrays.copyOfRange(result, 2, (int)(result[1] + 2));
            return StringUtility.chars2HexString(uiiData, uiiData.length);
        }
        return null;
    }

    public synchronized boolean writeDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt, String data, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        Log.i((String)TAG, (String)("writeData() bWriteData.length :" + bWriteData.length));
        int result = this.getDeviceAPI().UHFWriteData(bAccessPwd, (char)bank.value, ptr, (char)cnt, bEPC, bWriteData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeData() err :" + result));
        return false;
    }

    public synchronized boolean setQTPara(boolean enable) {
        int result = this.getDeviceAPI().SetQTPara(enable ? (char)'\u0001' : '\u0000');
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setQTPara() err :" + result));
        return false;
    }

    public synchronized int[] getQTPara() {
        char[] result = this.getDeviceAPI().GetQTPara();
        int[] ires = new int[2];
        if (result != null && result[0] == '\u0000') {
            ires[0] = 1;
            ires[1] = result[1];
            return ires;
        }
        Log.e((String)TAG, (String)("getQTPara() err :" + result[0]));
        return ires;
    }

    public static enum BankEnum {
        RESERVED(0),
        UII(1),
        TID(2),
        USER(3);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private BankEnum(byte value) {
            this.value = value;
        }
    }

    public static enum LockModeEnum {
        HOLD(0),
        LOCK(1),
        UNLOCK(2),
        PLOCK(3),
        PUNLOCK(4);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private LockModeEnum(byte value) {
            this.value = value;
        }
    }

    @Deprecated
    public static enum SingelModeEnum {
        SINGEL(0),
        MORE(1);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private SingelModeEnum(byte value) {
            this.value = value;
        }
    }

    public static enum SingleModeEnum {
        SINGEL(0),
        MORE(1);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private SingleModeEnum(byte value) {
            this.value = value;
        }
    }
}

