﻿using System;

using Android.App;
using Android.Content;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.OS;
using Com.Rscja.Deviceapi.Entity;
using Com.Rscja.Deviceapi.Exception;
using Com.Rscja.Deviceapi;
using System.Text.RegularExpressions;


namespace xm_15693
{
	[Activity (Label = "xm_15693", MainLauncher = true)]
	public class MainActivity : Activity
	{
		static RFIDWithISO15693 iso15693;

		Spinner spblock;
		Button btnread;
		Button btngetid;
		Button btnwrite;
		Button btnafiwrite;
		Button btnafisd;
		Button btndsfidwrite;
		Button btndsfidsd;
		EditText data;
		EditText afi;
		EditText dsfid;
		TextView labmsg;
		private ArrayAdapter adapterBlock;
		protected override void OnCreate (Bundle bundle)
		{
			base.OnCreate (bundle);

			// Set our view from the "main" layout resource
			SetContentView (Resource.Layout.Main);
			iso15693 = RFIDWithISO15693.Instance;
			// Get our button from the layout resource,
			// and attach an event to it

			InitView ();
		}

		void InitView()
		{
			spblock = FindViewById<Spinner> (Resource.Id.spblock);
			btnread = FindViewById<Button> (Resource.Id.btnread);
			btngetid = FindViewById<Button> (Resource.Id.btngetid);
			btnwrite = FindViewById<Button> (Resource.Id.btnwrite);
			btnafiwrite = FindViewById<Button> (Resource.Id.btnafiwrite);
			btnafisd = FindViewById<Button> (Resource.Id.btnafisd);
			btndsfidwrite = FindViewById<Button> (Resource.Id.btndsfidwrite);
			btndsfidsd = FindViewById<Button> (Resource.Id.btndsfidsd);
			data = FindViewById<EditText> (Resource.Id.editdata);
			afi = FindViewById<EditText> (Resource.Id.editafi);
			dsfid = FindViewById<EditText> (Resource.Id.editdsfid);
			labmsg = FindViewById<TextView> (Resource.Id.labmsg);
			//块
			adapterBlock = ArrayAdapter.CreateFromResource(this,Resource.Array.block15693, 
				global::Android.Resource.Layout.SimpleSpinnerItem);
			adapterBlock
				.SetDropDownViewResource (global::Android.Resource.Layout.SimpleSpinnerDropDownItem);
			spblock.Adapter = adapterBlock;
			spblock.SetSelection (0);

			btnread.Click += new EventHandler (delegate {

				try{
				labmsg.Text="";
				ISO15693Entity card=GetId ();
				string msg="";
				if(card!=null)
				{

					msg="NO:"+card.Id+"\r\n";
					card=iso15693.Read (spblock.SelectedItemPosition);
					if(card!=null)
					{
						msg+=card.Data;
					}

					else
						msg+=GetString (Resource.String.msgreaddatafail);
					labmsg.Text=msg;
				}
				else
					labmsg.Text=GetString(Resource.String.msgnocard);

				}
				catch(Exception ex)
				{
					labmsg.Text=ex.Message;
				}
			});

			btngetid.Click += new EventHandler (delegate {
				labmsg.Text="";
				ISO15693Entity card=GetId ();
				string msg="";
				if(card!=null)
				{
					msg="NO:"+card.Id+"\r\n"+"type:"+card.Type+"\r\nAFI:"+card.AFI+"\r\nDSFID:"+card.DESFID;
					labmsg.Text=msg;
				}
				else
					labmsg.Text=GetString(Resource.String.msgnocard);
			});

			btnwrite.Click += new EventHandler (delegate {
				try{
					labmsg.Text="";


					if(string.IsNullOrEmpty(data.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputdata, ToastLength.Long).Show();
						return;
					}

					if(!isHexNumberRex(data.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputkeyhex, ToastLength.Long).Show();
						return;
					}


					ISO15693Entity card=GetId ();
					string msg="";
					if(card!=null)
					{

						msg="NO:"+card.Id+"\r\n";
						Boolean re=iso15693.Write(spblock.SelectedItemPosition,data.Text.PadRight(8,'0'));
							if(re)
						{
								msg+=GetString(Resource.String.msgwritesucc);
						}

						else
							msg+=GetString (Resource.String.msgwritefail);
						labmsg.Text=msg;
					}
					else
						labmsg.Text=GetString(Resource.String.msgnocard);

				}
				catch(Exception ex)
				{
					labmsg.Text=ex.Message;
				}
			});

			btnafiwrite.Click += new EventHandler (delegate {
				try{
					labmsg.Text="";


					if(string.IsNullOrEmpty(afi.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputdata, ToastLength.Long).Show();

					
						return;
					}

					if(!isHexNumberRex(afi.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputkeyhex, ToastLength.Long).Show();

						return;
					}


					ISO15693Entity card=GetId ();
					string msg="";
					if(card!=null)
					{

						msg="NO:"+card.Id+"\r\n";
						Boolean re=iso15693.WriteAFI(int.Parse(afi.Text));
						if(re)
						{
							msg+=GetString(Resource.String.msgwritesucc);
						}

						else
							msg+=GetString (Resource.String.msgwritefail);
						labmsg.Text=msg;
					}
					else
						labmsg.Text=GetString(Resource.String.msgnocard);

				}
				catch(Exception ex)
				{
					labmsg.Text=ex.Message;
				}
			});

			btnafisd.Click += new EventHandler (delegate {
				try{
					labmsg.Text="";


					if(string.IsNullOrEmpty(afi.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputdata, ToastLength.Long).Show();


						return;
					}

					if(!isHexNumberRex(afi.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputkeyhex, ToastLength.Long).Show();

						return;
					}


					ISO15693Entity card=GetId ();
					string msg="";
					if(card!=null)
					{

						msg="NO:"+card.Id+"\r\n";
						Boolean re=iso15693.LockAFI();
						if(re)
						{
							msg+=GetString(Resource.String.msglockafisucc);
						}

						else
							msg+=GetString (Resource.String.msglockafifail);
						labmsg.Text=msg;
					}
					else
						labmsg.Text=GetString(Resource.String.msgnocard);

				}
				catch(Exception ex)
				{
					labmsg.Text=ex.Message;
				}
			});

			btndsfidwrite.Click += new EventHandler (delegate {
				try{
					labmsg.Text="";


					if(string.IsNullOrEmpty(dsfid.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputdata, ToastLength.Long).Show();


						return;
					}

					if(!isHexNumberRex(dsfid.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputkeyhex, ToastLength.Long).Show();

						return;
					}


					ISO15693Entity card=GetId ();
					string msg="";
					if(card!=null)
					{

						msg="NO:"+card.Id+"\r\n";
						Boolean re=iso15693.WriteDSFID(int.Parse(dsfid.Text));
						if(re)
						{
							msg+=GetString(Resource.String.msgwritesucc);
						}

						else
							msg+=GetString (Resource.String.msgwritefail);
						labmsg.Text=msg;
					}
					else
						labmsg.Text=GetString(Resource.String.msgnocard);

				}
				catch(Exception ex)
				{
					labmsg.Text=ex.Message;
				}
			});

			btndsfidsd.Click += new EventHandler (delegate {
				try{
					labmsg.Text="";


					if(string.IsNullOrEmpty(dsfid.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputdata, ToastLength.Long).Show();


						return;
					}

					if(!isHexNumberRex(dsfid.Text))
					{
						Toast.MakeText(this, Resource.String.msgm1inputkeyhex, ToastLength.Long).Show();

						return;
					}


					ISO15693Entity card=GetId ();
					string msg="";
					if(card!=null)
					{

						msg="NO:"+card.Id+"\r\n";
						Boolean re=iso15693.LockDSFID();
						if(re)
						{
							msg+=GetString(Resource.String.msglockdsfidsucc);
						}

						else
							msg+=GetString (Resource.String.msglockdsfidfail);
						labmsg.Text=msg;
					}
					else
						labmsg.Text=GetString(Resource.String.msgnocard);

				}
				catch(Exception ex)
				{
					labmsg.Text=ex.Message;
				}
			});
		}



		ISO15693Entity GetId()
		{
			return	iso15693.Inventory ();
		}

		public static Boolean isHexNumberRex(String str) {



			return Regex.IsMatch(str, "^[0-9A-Fa-f]+$");

		}

		protected override void OnResume()
		{
			base.OnResume ();
			new init15693 (this).Execute ();
		}
		protected override void OnPause()
		{
			base.OnPause ();
			if (iso15693 != null)
			{
				iso15693.Free();
			}
		}
		protected override void OnStop()
		{
			base.OnStop ();

		}


		public class init15693:AsyncTask{

			MainActivity mContext;
			ProgressDialog pro;
			public init15693(MainActivity m)
			{
				mContext=m;
			}

			protected override void OnPreExecute()
			{
				pro = new ProgressDialog (mContext);
				pro.SetProgressStyle (ProgressDialogStyle.Spinner);
				pro.SetMessage ("15693 Init...");
				pro.Show ();

			}
			#region implemented abstract members of AsyncTask

			protected override Java.Lang.Object DoInBackground (params Java.Lang.Object[] @params)
			{
				if (iso15693.Init ()) 
				{//throw new NotImplementedException ();
					//mContext.StartScanThread ();

					return "OK";
				}
				return "";
			}

			#endregion
			protected override void  OnPostExecute(Java.Lang.Object obj)
			{
				if (obj.ToString() != "OK") {
					Toast.MakeText (mContext,"init failuer",ToastLength.Short).Show();
				}
				else
					Toast.MakeText (mContext,"init OK",ToastLength.Short).Show();
				pro.Cancel ();
			}
		}
	}
}


