/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap.core;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.lidroid.xutils.BitmapUtils;
import com.lidroid.xutils.bitmap.BitmapCommonUtils;
import com.lidroid.xutils.bitmap.BitmapDisplayConfig;
import com.lidroid.xutils.bitmap.BitmapGlobalConfig;
import com.lidroid.xutils.bitmap.core.BitmapDecoder;
import com.lidroid.xutils.util.IOUtils;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.util.core.LruDiskCache;
import com.lidroid.xutils.util.core.LruMemoryCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class BitmapCache {
    private final int DISK_CACHE_INDEX = 0;
    private LruDiskCache mDiskLruCache;
    private LruMemoryCache<MemoryCacheKey, Bitmap> mMemoryCache;
    private final Object mDiskCacheLock = new Object();
    private boolean isDiskCacheReadied = false;
    private BitmapGlobalConfig globalConfig;

    public BitmapCache(BitmapGlobalConfig globalConfig) {
        if (globalConfig == null) {
            throw new IllegalArgumentException("globalConfig may not be null");
        }
        this.globalConfig = globalConfig;
    }

    public void initMemoryCache() {
        if (!this.globalConfig.isMemoryCacheEnabled()) {
            return;
        }
        if (this.mMemoryCache != null) {
            try {
                this.clearMemoryCache();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.mMemoryCache = new LruMemoryCache<MemoryCacheKey, Bitmap>(this.globalConfig.getMemoryCacheSize()){

            @Override
            protected int sizeOf(MemoryCacheKey key, Bitmap bitmap) {
                if (bitmap == null) {
                    return 0;
                }
                return bitmap.getRowBytes() * bitmap.getHeight();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        if (!this.globalConfig.isDiskCacheEnabled()) {
            return;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) {
                long diskCacheSize;
                long availableSpace;
                File diskCacheDir = new File(this.globalConfig.getDiskCachePath());
                if (!diskCacheDir.exists()) {
                    diskCacheDir.mkdirs();
                }
                diskCacheSize = (availableSpace = BitmapCommonUtils.getAvailableSpace(diskCacheDir)) > (diskCacheSize = (long)this.globalConfig.getDiskCacheSize()) ? diskCacheSize : availableSpace;
                try {
                    this.mDiskLruCache = LruDiskCache.open(diskCacheDir, 1, 1, diskCacheSize);
                    this.mDiskLruCache.setDiskCacheFileNameGenerator(this.globalConfig.getDiskCacheFileNameGenerator());
                }
                catch (Throwable e) {
                    this.mDiskLruCache = null;
                    LogUtils.e(e.getMessage(), e);
                }
            }
            this.isDiskCacheReadied = true;
            this.mDiskCacheLock.notifyAll();
        }
    }

    public void setMemoryCacheSize(int maxSize) {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.setMaxSize(maxSize);
        }
    }

    public void setDiskCacheSize(int maxSize) {
        if (this.mDiskLruCache != null) {
            this.mDiskLruCache.setMaxSize(maxSize);
        }
    }

    public void setDiskCacheFileNameGenerator(LruDiskCache.DiskCacheFileNameGenerator diskCacheFileNameGenerator) {
        if (this.mDiskLruCache != null && diskCacheFileNameGenerator != null) {
            this.mDiskLruCache.setDiskCacheFileNameGenerator(diskCacheFileNameGenerator);
        }
    }

    /*
     * Exception decompiling
     */
    public Bitmap downloadBitmap(String uri, BitmapDisplayConfig config, BitmapUtils.BitmapLoadTask<?> task) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addBitmapToMemoryCache(String uri, BitmapDisplayConfig config, Bitmap bitmap, long expiryTimestamp) throws IOException {
        if (uri != null && bitmap != null && this.globalConfig.isMemoryCacheEnabled() && this.mMemoryCache != null) {
            MemoryCacheKey key = new MemoryCacheKey(uri, config == null ? null : config.toString());
            this.mMemoryCache.put(key, bitmap, expiryTimestamp);
        }
    }

    public Bitmap getBitmapFromMemCache(String uri, BitmapDisplayConfig config) {
        if (this.mMemoryCache != null && this.globalConfig.isMemoryCacheEnabled()) {
            MemoryCacheKey key = new MemoryCacheKey(uri, config == null ? null : config.toString());
            return this.mMemoryCache.get(key);
        }
        return null;
    }

    public File getBitmapFileFromDiskCache(String uri) {
        if (this.mDiskLruCache != null) {
            return this.mDiskLruCache.getCacheFile(uri, 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmapFromDiskCache(String uri, BitmapDisplayConfig config) {
        if (uri == null || !this.globalConfig.isDiskCacheEnabled()) {
            return null;
        }
        var3_3 = this.mDiskCacheLock;
        synchronized (var3_3) {
            block11: {
                while (true) {
                    if (!this.isDiskCacheReadied) ** GOTO lbl26
                    if (this.mDiskLruCache == null) break block11;
                    snapshot = null;
                    try {
                        snapshot = this.mDiskLruCache.get(uri);
                        if (snapshot == null) break;
                        bitmap = null;
                        bitmap = config == null || config.isShowOriginal() != false ? BitmapDecoder.decodeFileDescriptor(snapshot.getInputStream(0).getFD()) : BitmapDecoder.decodeSampledBitmapFromDescriptor(snapshot.getInputStream(0).getFD(), config.getBitmapMaxSize(), config.getBitmapConfig());
                        bitmap = this.rotateBitmapIfNeeded(uri, config, bitmap);
                        this.addBitmapToMemoryCache(uri, config, bitmap, this.mDiskLruCache.getExpiryTimestamp(uri));
                        var7_8 = bitmap;
                        ** GOTO lbl32
                    }
                    catch (Throwable e) {
                        try {
                            LogUtils.e(e.getMessage(), e);
                        }
                        catch (Throwable var6_9) {
                            IOUtils.closeQuietly(snapshot);
                            throw var6_9;
                        }
lbl26:
                        // 1 sources

                        try {
                            this.mDiskCacheLock.wait();
                        }
                        catch (Throwable var4_4) {
                            // empty catch block
                        }
                        continue;
lbl32:
                        // 1 sources

                        IOUtils.closeQuietly(snapshot);
                        return var7_8;
                        IOUtils.closeQuietly(snapshot);
                        break block11;
                    }
                    break;
                }
                IOUtils.closeQuietly(snapshot);
            }
            return null;
        }
    }

    public void clearCache() {
        this.clearMemoryCache();
        this.clearDiskCache();
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
                this.mDiskLruCache = null;
                this.isDiskCacheReadied = false;
            }
        }
        this.initDiskCache();
    }

    public void clearCache(String uri) {
        this.clearMemoryCache(uri);
        this.clearDiskCache(uri);
    }

    public void clearMemoryCache(String uri) {
        MemoryCacheKey key = new MemoryCacheKey(uri, null);
        if (this.mMemoryCache != null) {
            while (this.mMemoryCache.containsKey(key)) {
                this.mMemoryCache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDiskCache(String uri) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.remove(uri);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                    }
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
    }

    private Bitmap decodeBitmapMeta(BitmapMeta bitmapMeta, BitmapDisplayConfig config) throws IOException {
        if (bitmapMeta == null) {
            return null;
        }
        Bitmap bitmap = null;
        if (bitmapMeta.inputStream != null) {
            bitmap = config == null || config.isShowOriginal() ? BitmapDecoder.decodeFileDescriptor(bitmapMeta.inputStream.getFD()) : BitmapDecoder.decodeSampledBitmapFromDescriptor(bitmapMeta.inputStream.getFD(), config.getBitmapMaxSize(), config.getBitmapConfig());
        } else if (bitmapMeta.data != null) {
            bitmap = config == null || config.isShowOriginal() ? BitmapDecoder.decodeByteArray(bitmapMeta.data) : BitmapDecoder.decodeSampledBitmapFromByteArray(bitmapMeta.data, config.getBitmapMaxSize(), config.getBitmapConfig());
        }
        return bitmap;
    }

    private Bitmap rotateBitmapIfNeeded(String uri, BitmapDisplayConfig config, Bitmap bitmap) {
        File bitmapFile;
        Bitmap result = bitmap;
        if (config != null && config.isAutoRotation() && (bitmapFile = this.getBitmapFileFromDiskCache(uri)) != null && bitmapFile.exists()) {
            ExifInterface exif = null;
            try {
                exif = new ExifInterface(bitmapFile.getPath());
            }
            catch (Throwable e) {
                return result;
            }
            int orientation = exif.getAttributeInt("Orientation", 0);
            int angle = 0;
            switch (orientation) {
                case 6: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 180;
                    break;
                }
                case 8: {
                    angle = 270;
                    break;
                }
                default: {
                    angle = 0;
                }
            }
            if (angle != 0) {
                Matrix m = new Matrix();
                m.postRotate((float)angle);
                result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
                bitmap.recycle();
                bitmap = null;
            }
        }
        return result;
    }

    private class BitmapMeta {
        public FileInputStream inputStream;
        public byte[] data;
        public long expiryTimestamp;

        private BitmapMeta() {
        }
    }

    public class MemoryCacheKey {
        private String uri;
        private String subKey;

        private MemoryCacheKey(String uri, String subKey) {
            this.uri = uri;
            this.subKey = subKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MemoryCacheKey)) {
                return false;
            }
            MemoryCacheKey that = (MemoryCacheKey)o;
            if (!this.uri.equals(that.uri)) {
                return false;
            }
            if (this.subKey != null && that.subKey != null) {
                return this.subKey.equals(that.subKey);
            }
            return true;
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }
}

