/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.callback;

import com.lidroid.xutils.http.callback.RequestCallBackHandler;
import com.lidroid.xutils.util.IOUtils;
import com.lidroid.xutils.util.OtherUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;

public class StringDownloadHandler {
    public String handleEntity(HttpEntity entity, RequestCallBackHandler callBackHandler, String charset) throws IOException {
        if (entity == null) {
            return null;
        }
        long current = 0L;
        long total = entity.getContentLength();
        if (callBackHandler != null && !callBackHandler.updateProgress(total, current, true)) {
            return null;
        }
        InputStream inputStream = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStream = entity.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
                if (callBackHandler != null && !callBackHandler.updateProgress(total, current += OtherUtils.sizeOfString(line, charset), false)) break;
            }
            if (callBackHandler != null) {
                callBackHandler.updateProgress(total, current, true);
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return sb.toString().trim();
    }
}

